/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.virtual;

import javax.annotation.Nullable;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Predicate;
import org.apache.hive.druid.io.druid.java.util.common.ISE;
import org.apache.hive.druid.io.druid.math.expr.Expr;
import org.apache.hive.druid.io.druid.math.expr.Parser;
import org.apache.hive.druid.io.druid.query.filter.ValueMatcher;
import org.apache.hive.druid.io.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.hive.druid.io.druid.segment.DimensionSelector;
import org.apache.hive.druid.io.druid.segment.DimensionSelectorUtils;
import org.apache.hive.druid.io.druid.segment.IdLookup;
import org.apache.hive.druid.io.druid.segment.data.IndexedInts;
import org.apache.hive.druid.io.druid.segment.data.SingleIndexedInt;
import org.apache.hive.druid.io.druid.segment.virtual.SingleInputBindings;

public class SingleStringInputDimensionSelector
implements DimensionSelector {
    private final DimensionSelector selector;
    private final Expr expression;
    private final SingleInputBindings bindings = new SingleInputBindings();
    private final int nullAdjustment;

    public SingleStringInputDimensionSelector(DimensionSelector selector, Expr expression) {
        if (Parser.findRequiredBindings(expression).size() != 1) {
            throw new ISE("WTF?! Expected expression with just one binding", new Object[0]);
        }
        if (selector.getValueCardinality() == -1 || !selector.nameLookupPossibleInAdvance()) {
            throw new ISE("Selector of class[%s] does not have a dictionary, cannot use it.", selector.getClass().getName());
        }
        this.selector = Preconditions.checkNotNull(selector, "selector");
        this.expression = Preconditions.checkNotNull(expression, "expression");
        this.nullAdjustment = selector.getValueCardinality() == 0 || selector.lookupName(0) != null ? 1 : 0;
    }

    @Override
    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        inspector.visit("selector", this.selector);
        inspector.visit("expression", this.expression);
    }

    @Override
    public IndexedInts getRow() {
        IndexedInts row = this.selector.getRow();
        if (row.size() == 1) {
            if (this.nullAdjustment == 0) {
                return row;
            }
            return SingleIndexedInt.of(row.get(0) + this.nullAdjustment);
        }
        return SingleIndexedInt.of(0);
    }

    @Override
    public ValueMatcher makeValueMatcher(@Nullable String value) {
        return DimensionSelectorUtils.makeValueMatcherGeneric((DimensionSelector)this, value);
    }

    @Override
    public ValueMatcher makeValueMatcher(Predicate<String> predicate) {
        return DimensionSelectorUtils.makeValueMatcherGeneric((DimensionSelector)this, predicate);
    }

    @Override
    public int getValueCardinality() {
        return this.selector.getValueCardinality() + this.nullAdjustment;
    }

    @Override
    public String lookupName(int id) {
        String value = id == 0 ? null : this.selector.lookupName(id - this.nullAdjustment);
        this.bindings.set(value);
        return this.expression.eval(this.bindings).asString();
    }

    @Override
    public boolean nameLookupPossibleInAdvance() {
        return true;
    }

    @Override
    @Nullable
    public IdLookup idLookup() {
        return null;
    }

    @Override
    @Nullable
    public Object getObject() {
        return this.defaultGetObject();
    }

    @Override
    public Class classOfObject() {
        return Object.class;
    }
}

