/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.realtime.firehose;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.google.common.base.Predicate;
import org.apache.hive.druid.io.druid.data.input.Firehose;
import org.apache.hive.druid.io.druid.data.input.InputRow;
import org.apache.hive.druid.io.druid.java.util.common.logger.Logger;

public class PredicateFirehose
implements Firehose {
    private static final Logger log = new Logger(PredicateFirehose.class);
    private static final int IGNORE_THRESHOLD = 5000;
    private long ignored = 0L;
    private final Firehose firehose;
    private final Predicate<InputRow> predicate;
    private InputRow savedInputRow = null;

    public PredicateFirehose(Firehose firehose, Predicate<InputRow> predicate) {
        this.firehose = firehose;
        this.predicate = predicate;
    }

    @Override
    public boolean hasMore() {
        if (this.savedInputRow != null) {
            return true;
        }
        while (this.firehose.hasMore()) {
            InputRow row = this.firehose.nextRow();
            if (this.predicate.apply(row)) {
                this.savedInputRow = row;
                return true;
            }
            if (this.ignored % 5000L == 0L) {
                log.warn("[%,d] InputRow(s) ignored as they do not satisfy the predicate", this.ignored);
            }
            ++this.ignored;
        }
        return false;
    }

    @Override
    @Nullable
    public InputRow nextRow() {
        InputRow row = this.savedInputRow;
        this.savedInputRow = null;
        return row;
    }

    @Override
    public Runnable commit() {
        return this.firehose.commit();
    }

    @Override
    public void close() throws IOException {
        this.firehose.close();
    }
}

