/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.loading;

import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.io.druid.java.util.common.CompressionUtils;
import org.apache.hive.druid.io.druid.java.util.common.IOE;
import org.apache.hive.druid.io.druid.java.util.common.logger.Logger;
import org.apache.hive.druid.io.druid.segment.SegmentUtils;
import org.apache.hive.druid.io.druid.segment.loading.DataSegmentPusher;
import org.apache.hive.druid.io.druid.segment.loading.LocalDataSegmentPusherConfig;
import org.apache.hive.druid.io.druid.timeline.DataSegment;

public class LocalDataSegmentPusher
implements DataSegmentPusher {
    private static final Logger log = new Logger(LocalDataSegmentPusher.class);
    private static final String INDEX_FILENAME = "index.zip";
    private static final String DESCRIPTOR_FILENAME = "descriptor.json";
    private final LocalDataSegmentPusherConfig config;
    private final ObjectMapper jsonMapper;

    @Inject
    public LocalDataSegmentPusher(LocalDataSegmentPusherConfig config, ObjectMapper jsonMapper) {
        this.config = config;
        this.jsonMapper = jsonMapper;
        log.info("Configured local filesystem as deep storage", new Object[0]);
    }

    @Override
    public String getPathForHadoop() {
        return this.config.getStorageDirectory().getAbsoluteFile().toURI().toString();
    }

    @Override
    @Deprecated
    public String getPathForHadoop(String dataSource) {
        return this.getPathForHadoop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSegment push(File dataSegmentFile, DataSegment segment, boolean replaceExisting) throws IOException {
        File baseStorageDir = this.config.getStorageDirectory();
        File outDir = new File(baseStorageDir, this.getStorageDir(segment));
        log.info("Copying segment[%s] to local filesystem at location[%s]", segment.getIdentifier(), outDir.toString());
        if (dataSegmentFile.equals(outDir)) {
            long size = 0L;
            for (File file : dataSegmentFile.listFiles()) {
                size += file.length();
            }
            return this.createDescriptorFile(segment.withLoadSpec(this.makeLoadSpec(outDir.toURI())).withSize(size).withBinaryVersion(SegmentUtils.getVersionFromDir(dataSegmentFile)), outDir);
        }
        File tmpOutDir = new File(baseStorageDir, this.makeIntermediateDir());
        log.info("Creating intermediate directory[%s] for segment[%s]", tmpOutDir.toString(), segment.getIdentifier());
        FileUtils.forceMkdir((File)tmpOutDir);
        try {
            File tmpIndexFile = new File(tmpOutDir, INDEX_FILENAME);
            long size = this.compressSegment(dataSegmentFile, tmpIndexFile);
            File tmpDescriptorFile = new File(tmpOutDir, DESCRIPTOR_FILENAME);
            DataSegment dataSegment = this.createDescriptorFile(segment.withLoadSpec(this.makeLoadSpec(new File(outDir, INDEX_FILENAME).toURI())).withSize(size).withBinaryVersion(SegmentUtils.getVersionFromDir(dataSegmentFile)), tmpDescriptorFile);
            FileUtils.forceMkdir((File)outDir);
            if (replaceExisting) {
                File indexFileTarget = new File(outDir, tmpIndexFile.getName());
                File descriptorFileTarget = new File(outDir, tmpDescriptorFile.getName());
                if (!tmpIndexFile.renameTo(indexFileTarget)) {
                    throw new IOE("Failed to rename [%s] to [%s]", tmpIndexFile, indexFileTarget);
                }
                if (!tmpDescriptorFile.renameTo(descriptorFileTarget)) {
                    throw new IOE("Failed to rename [%s] to [%s]", tmpDescriptorFile, descriptorFileTarget);
                }
            } else {
                try {
                    Files.move(tmpIndexFile.toPath(), outDir.toPath().resolve(tmpIndexFile.toPath().getFileName()), new CopyOption[0]);
                }
                catch (FileAlreadyExistsException e) {
                    log.info("[%s] already exists at [%s], ignore if replication is configured", INDEX_FILENAME, outDir);
                }
                try {
                    Files.move(tmpDescriptorFile.toPath(), outDir.toPath().resolve(tmpDescriptorFile.toPath().getFileName()), new CopyOption[0]);
                }
                catch (FileAlreadyExistsException e) {
                    log.info("[%s] already exists at [%s], ignore if replication is configured", DESCRIPTOR_FILENAME, outDir);
                    dataSegment = this.jsonMapper.readValue(new File(outDir, DESCRIPTOR_FILENAME), DataSegment.class);
                }
            }
            DataSegment dataSegment2 = dataSegment;
            return dataSegment2;
        }
        finally {
            FileUtils.deleteDirectory((File)tmpOutDir);
        }
    }

    @Override
    public Map<String, Object> makeLoadSpec(URI finalIndexZipFilePath) {
        return ImmutableMap.of("type", "local", "path", finalIndexZipFilePath.getPath());
    }

    private String makeIntermediateDir() {
        return "intermediate_pushes/" + UUID.randomUUID().toString();
    }

    private long compressSegment(File dataSegmentFile, File dest) throws IOException {
        log.info("Compressing files from[%s] to [%s]", dataSegmentFile, dest);
        return CompressionUtils.zip(dataSegmentFile, dest, true);
    }

    private DataSegment createDescriptorFile(DataSegment segment, File dest) throws IOException {
        log.info("Creating descriptor file at[%s]", dest);
        Files.write(dest.toPath(), this.jsonMapper.writeValueAsBytes(segment), StandardOpenOption.CREATE, StandardOpenOption.SYNC);
        return segment;
    }
}

