/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.loading;

import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.hive.druid.io.druid.java.util.common.MapUtils;
import org.apache.hive.druid.io.druid.java.util.common.logger.Logger;
import org.apache.hive.druid.io.druid.segment.loading.DataSegmentKiller;
import org.apache.hive.druid.io.druid.segment.loading.LocalDataSegmentPusherConfig;
import org.apache.hive.druid.io.druid.segment.loading.SegmentLoadingException;
import org.apache.hive.druid.io.druid.timeline.DataSegment;

public class LocalDataSegmentKiller
implements DataSegmentKiller {
    private static final Logger log = new Logger(LocalDataSegmentKiller.class);
    private static final String PATH_KEY = "path";
    private final File storageDirectory;

    @Inject
    public LocalDataSegmentKiller(LocalDataSegmentPusherConfig config) {
        this.storageDirectory = config.getStorageDirectory();
    }

    @Override
    public void kill(DataSegment segment) throws SegmentLoadingException {
        block4: {
            File path = this.getPath(segment);
            log.info("killing segment[%s] mapped to path[%s]", segment.getIdentifier(), path);
            try {
                if (path.getName().endsWith(".zip")) {
                    File intervalDir;
                    File partitionNumDir = path.getParentFile();
                    FileUtils.deleteDirectory((File)partitionNumDir);
                    File versionDir = partitionNumDir.getParentFile();
                    if (versionDir.delete() && (intervalDir = versionDir.getParentFile()).delete()) {
                        File dataSourceDir = intervalDir.getParentFile();
                        dataSourceDir.delete();
                    }
                    break block4;
                }
                throw new SegmentLoadingException("Unknown file type[%s]", path);
            }
            catch (IOException e) {
                throw new SegmentLoadingException(e, "Unable to kill segment", new Object[0]);
            }
        }
    }

    @Override
    public void killAll() throws IOException {
        log.info("Deleting all segment files from local dir [%s].", this.storageDirectory.getAbsolutePath());
        FileUtils.deleteDirectory((File)this.storageDirectory);
    }

    private File getPath(DataSegment segment) throws SegmentLoadingException {
        return new File(MapUtils.getString(segment.getLoadSpec(), PATH_KEY));
    }
}

