/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.filter;

import org.apache.hive.druid.io.druid.query.BitmapResultFactory;
import org.apache.hive.druid.io.druid.query.filter.BitmapIndexSelector;
import org.apache.hive.druid.io.druid.query.filter.Filter;
import org.apache.hive.druid.io.druid.query.filter.ValueMatcher;
import org.apache.hive.druid.io.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.hive.druid.io.druid.segment.ColumnSelector;
import org.apache.hive.druid.io.druid.segment.ColumnSelectorFactory;

public class NotFilter
implements Filter {
    private final Filter baseFilter;

    public NotFilter(Filter baseFilter) {
        this.baseFilter = baseFilter;
    }

    @Override
    public <T> T getBitmapResult(BitmapIndexSelector selector, BitmapResultFactory<T> bitmapResultFactory) {
        return bitmapResultFactory.complement(this.baseFilter.getBitmapResult(selector, bitmapResultFactory), selector.getNumRows());
    }

    @Override
    public ValueMatcher makeMatcher(ColumnSelectorFactory factory) {
        final ValueMatcher baseMatcher = this.baseFilter.makeMatcher(factory);
        return new ValueMatcher(){

            @Override
            public boolean matches() {
                return !baseMatcher.matches();
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("baseMatcher", baseMatcher);
            }
        };
    }

    @Override
    public boolean supportsBitmapIndex(BitmapIndexSelector selector) {
        return this.baseFilter.supportsBitmapIndex(selector);
    }

    @Override
    public boolean supportsSelectivityEstimation(ColumnSelector columnSelector, BitmapIndexSelector indexSelector) {
        return this.baseFilter.supportsSelectivityEstimation(columnSelector, indexSelector);
    }

    @Override
    public double estimateSelectivity(BitmapIndexSelector indexSelector) {
        return 1.0 - this.baseFilter.estimateSelectivity(indexSelector);
    }

    public Filter getBaseFilter() {
        return this.baseFilter;
    }
}

