/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.filter;

import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Predicate;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.apache.hive.druid.io.druid.query.BitmapResultFactory;
import org.apache.hive.druid.io.druid.query.extraction.ExtractionFn;
import org.apache.hive.druid.io.druid.query.filter.BitmapIndexSelector;
import org.apache.hive.druid.io.druid.query.filter.DruidDoublePredicate;
import org.apache.hive.druid.io.druid.query.filter.DruidFloatPredicate;
import org.apache.hive.druid.io.druid.query.filter.DruidLongPredicate;
import org.apache.hive.druid.io.druid.query.filter.DruidPredicateFactory;
import org.apache.hive.druid.io.druid.query.filter.Filter;
import org.apache.hive.druid.io.druid.query.filter.ValueMatcher;
import org.apache.hive.druid.io.druid.segment.ColumnSelector;
import org.apache.hive.druid.io.druid.segment.ColumnSelectorFactory;
import org.apache.hive.druid.io.druid.segment.filter.Filters;

public class DimensionPredicateFilter
implements Filter {
    private final String dimension;
    private final DruidPredicateFactory predicateFactory;
    private final String basePredicateString;
    private final ExtractionFn extractionFn;

    public DimensionPredicateFilter(String dimension, final DruidPredicateFactory predicateFactory, final ExtractionFn extractionFn) {
        Preconditions.checkNotNull(predicateFactory, "predicateFactory");
        this.dimension = Preconditions.checkNotNull(dimension, "dimension");
        this.basePredicateString = predicateFactory.toString();
        this.extractionFn = extractionFn;
        this.predicateFactory = extractionFn == null ? predicateFactory : new DruidPredicateFactory(){
            final Predicate<String> baseStringPredicate;
            {
                this.baseStringPredicate = predicateFactory.makeStringPredicate();
            }

            @Override
            public Predicate<String> makeStringPredicate() {
                return input -> this.baseStringPredicate.apply(extractionFn.apply((String)input));
            }

            @Override
            public DruidLongPredicate makeLongPredicate() {
                return input -> this.baseStringPredicate.apply(extractionFn.apply(input));
            }

            @Override
            public DruidFloatPredicate makeFloatPredicate() {
                return input -> this.baseStringPredicate.apply(extractionFn.apply(Float.valueOf(input)));
            }

            @Override
            public DruidDoublePredicate makeDoublePredicate() {
                return input -> this.baseStringPredicate.apply(extractionFn.apply(input));
            }
        };
    }

    @Override
    public <T> T getBitmapResult(BitmapIndexSelector selector, BitmapResultFactory<T> bitmapResultFactory) {
        return Filters.matchPredicate(this.dimension, selector, bitmapResultFactory, this.predicateFactory.makeStringPredicate());
    }

    @Override
    public ValueMatcher makeMatcher(ColumnSelectorFactory factory) {
        return Filters.makeValueMatcher(factory, this.dimension, this.predicateFactory);
    }

    @Override
    public boolean supportsBitmapIndex(BitmapIndexSelector selector) {
        return selector.getBitmapIndex(this.dimension) != null;
    }

    @Override
    public boolean supportsSelectivityEstimation(ColumnSelector columnSelector, BitmapIndexSelector indexSelector) {
        return Filters.supportsSelectivityEstimation(this, this.dimension, columnSelector, indexSelector);
    }

    @Override
    public double estimateSelectivity(BitmapIndexSelector indexSelector) {
        return Filters.estimateSelectivity(this.dimension, indexSelector, this.predicateFactory.makeStringPredicate());
    }

    public String toString() {
        if (this.extractionFn != null) {
            return StringUtils.format("%s(%s) = %s", this.extractionFn, this.dimension, this.basePredicateString);
        }
        return StringUtils.format("%s = %s", this.dimension, this.basePredicateString);
    }
}

