/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.data;

import com.ning.compress.BufferRecycler;
import com.ning.compress.lzf.LZFDecoder;
import com.ning.compress.lzf.LZFEncoder;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4SafeDecompressor;
import org.apache.commons.lang.ArrayUtils;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonValue;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.io.druid.collections.ResourceHolder;
import org.apache.hive.druid.io.druid.java.util.common.ByteBufferUtils;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.apache.hive.druid.io.druid.java.util.common.io.Closer;
import org.apache.hive.druid.io.druid.segment.CompressedPools;

public enum CompressionStrategy {
    LZF(0){

        @Override
        public Decompressor getDecompressor() {
            return LZFDecompressor.defaultDecompressor;
        }

        @Override
        public Compressor getCompressor() {
            return LZFCompressor.defaultCompressor;
        }
    }
    ,
    LZ4(1){

        @Override
        public Decompressor getDecompressor() {
            return LZ4Decompressor.defaultDecompressor;
        }

        @Override
        public Compressor getCompressor() {
            return LZ4Compressor.defaultCompressor;
        }
    }
    ,
    UNCOMPRESSED(-1){

        @Override
        public Decompressor getDecompressor() {
            return UncompressedDecompressor.defaultDecompressor;
        }

        @Override
        public Compressor getCompressor() {
            return UncompressedCompressor.defaultCompressor;
        }
    }
    ,
    NONE(-2){

        @Override
        public Decompressor getDecompressor() {
            throw new UnsupportedOperationException("NONE compression strategy shouldn't use any decompressor");
        }

        @Override
        public Compressor getCompressor() {
            throw new UnsupportedOperationException("NONE compression strategy shouldn't use any compressor");
        }
    };

    public static final CompressionStrategy DEFAULT_COMPRESSION_STRATEGY;
    final byte id;
    static final Map<Byte, CompressionStrategy> idMap;

    private CompressionStrategy(byte id) {
        this.id = id;
    }

    public byte getId() {
        return this.id;
    }

    public abstract Compressor getCompressor();

    public abstract Decompressor getDecompressor();

    @JsonValue
    public String toString() {
        return StringUtils.toLowerCase(this.name());
    }

    @JsonCreator
    public static CompressionStrategy fromString(String name) {
        return CompressionStrategy.valueOf(StringUtils.toUpperCase(name));
    }

    public static CompressionStrategy forId(byte id) {
        return idMap.get(id);
    }

    public static CompressionStrategy[] noNoneValues() {
        return (CompressionStrategy[])ArrayUtils.removeElement((Object[])CompressionStrategy.values(), (Object)((Object)NONE));
    }

    static {
        DEFAULT_COMPRESSION_STRATEGY = LZ4;
        idMap = Maps.newHashMap();
        for (CompressionStrategy strategy : CompressionStrategy.values()) {
            idMap.put(strategy.getId(), strategy);
        }
    }

    public static class LZ4Compressor
    extends Compressor {
        private static final LZ4Compressor defaultCompressor = new LZ4Compressor();
        private static final net.jpountz.lz4.LZ4Compressor lz4High = LZ4Factory.fastestInstance().highCompressor();

        @Override
        ByteBuffer allocateInBuffer(int inputSize, Closer closer) {
            ByteBuffer inBuffer = ByteBuffer.allocateDirect(inputSize);
            closer.register(() -> ByteBufferUtils.free(inBuffer));
            return inBuffer;
        }

        @Override
        ByteBuffer allocateOutBuffer(int inputSize, Closer closer) {
            ByteBuffer outBuffer = ByteBuffer.allocateDirect(lz4High.maxCompressedLength(inputSize));
            closer.register(() -> ByteBufferUtils.free(outBuffer));
            return outBuffer;
        }

        @Override
        public ByteBuffer compress(ByteBuffer in, ByteBuffer out) {
            out.clear();
            int position = in.position();
            lz4High.compress(in, out);
            in.position(position);
            out.flip();
            return out;
        }
    }

    public static class LZ4Decompressor
    implements Decompressor {
        private static final LZ4SafeDecompressor lz4Safe = LZ4Factory.fastestInstance().safeDecompressor();
        private static final LZ4Decompressor defaultDecompressor = new LZ4Decompressor();

        @Override
        public void decompress(ByteBuffer in, int numBytes, ByteBuffer out) {
            int numDecompressedBytes = lz4Safe.decompress(in, in.position(), numBytes, out, out.position(), out.remaining());
            out.limit(out.position() + numDecompressedBytes);
        }
    }

    public static class LZFCompressor
    extends Compressor {
        private static final LZFCompressor defaultCompressor = new LZFCompressor();

        @Override
        public ByteBuffer allocateOutBuffer(int inputSize, Closer closer) {
            return ByteBuffer.allocate(LZFEncoder.estimateMaxWorkspaceSize((int)inputSize));
        }

        @Override
        public ByteBuffer compress(ByteBuffer in, ByteBuffer out) {
            try (ResourceHolder<BufferRecycler> bufferRecycler = CompressedPools.getBufferRecycler();){
                int encodedLen = LZFEncoder.appendEncoded((byte[])in.array(), (int)(in.arrayOffset() + in.position()), (int)in.remaining(), (byte[])out.array(), (int)out.arrayOffset(), (BufferRecycler)bufferRecycler.get());
                out.clear();
                out.limit(encodedLen);
                ByteBuffer byteBuffer = out;
                return byteBuffer;
            }
        }
    }

    public static class LZFDecompressor
    implements Decompressor {
        private static final LZFDecompressor defaultDecompressor = new LZFDecompressor();

        @Override
        public void decompress(ByteBuffer in, int numBytes, ByteBuffer out) {
            byte[] bytes = new byte[numBytes];
            in.get(bytes);
            try (ResourceHolder<byte[]> outputBytesHolder = CompressedPools.getOutputBytes();){
                byte[] outputBytes = outputBytesHolder.get();
                int numDecompressedBytes = LZFDecoder.decode((byte[])bytes, (byte[])outputBytes);
                out.put(outputBytes, 0, numDecompressedBytes);
                out.flip();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class UncompressedDecompressor
    implements Decompressor {
        private static final UncompressedDecompressor defaultDecompressor = new UncompressedDecompressor();

        @Override
        public void decompress(ByteBuffer in, int numBytes, ByteBuffer out) {
            ByteBuffer copyBuffer = in.duplicate();
            copyBuffer.limit(copyBuffer.position() + numBytes);
            out.put(copyBuffer).flip();
            in.position(in.position() + numBytes);
        }
    }

    public static class UncompressedCompressor
    extends Compressor {
        private static final UncompressedCompressor defaultCompressor = new UncompressedCompressor();

        @Override
        ByteBuffer allocateOutBuffer(int inputSize, Closer closer) {
            return ByteBuffer.allocate(inputSize);
        }

        @Override
        public ByteBuffer compress(ByteBuffer in, ByteBuffer out) {
            return in;
        }
    }

    public static abstract class Compressor {
        ByteBuffer allocateInBuffer(int inputSize, Closer closer) {
            return ByteBuffer.allocate(inputSize);
        }

        abstract ByteBuffer allocateOutBuffer(int var1, Closer var2);

        public abstract ByteBuffer compress(ByteBuffer var1, ByteBuffer var2);
    }

    public static interface Decompressor {
        public void decompress(ByteBuffer var1, int var2, ByteBuffer var3);
    }
}

