/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.data;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.io.druid.java.util.common.IAE;
import org.apache.hive.druid.io.druid.segment.data.ColumnarDoubles;
import org.apache.hive.druid.io.druid.segment.data.CompressionFactory;
import org.apache.hive.druid.io.druid.segment.data.CompressionStrategy;

public class CompressedColumnarDoublesSuppliers {
    public static final byte LZF_VERSION = 1;
    public static final byte VERSION = 2;

    private CompressedColumnarDoublesSuppliers() {
    }

    public static Supplier<ColumnarDoubles> fromByteBuffer(ByteBuffer buffer, ByteOrder order) {
        byte versionFromBuffer = buffer.get();
        if (versionFromBuffer == 1 || versionFromBuffer == 2) {
            int totalSize = buffer.getInt();
            int sizePer = buffer.getInt();
            CompressionStrategy compression = CompressionStrategy.LZF;
            if (versionFromBuffer == 2) {
                byte compressionId = buffer.get();
                compression = CompressionStrategy.forId(compressionId);
            }
            return CompressionFactory.getDoubleSupplier(totalSize, sizePer, buffer.asReadOnlyBuffer(), order, compression);
        }
        throw new IAE("Unknown version[%s]", versionFromBuffer);
    }
}

