/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment;

import org.apache.hive.druid.io.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.hive.druid.io.druid.segment.data.Offset;
import org.apache.hive.druid.io.druid.segment.data.ReadableOffset;

public class NoFilterOffset
extends Offset {
    private final int rowCount;
    private final boolean descending;
    private final int initialOffset;
    private int currentOffset;

    NoFilterOffset(int initialOffset, int rowCount, boolean descending) {
        this.initialOffset = initialOffset;
        this.currentOffset = initialOffset;
        this.rowCount = rowCount;
        this.descending = descending;
    }

    @Override
    public void increment() {
        ++this.currentOffset;
    }

    @Override
    public boolean withinBounds() {
        return this.currentOffset < this.rowCount;
    }

    @Override
    public void reset() {
        this.currentOffset = this.initialOffset;
    }

    @Override
    public ReadableOffset getBaseReadableOffset() {
        return this;
    }

    @Override
    public Offset clone() {
        return new NoFilterOffset(this.currentOffset, this.rowCount, this.descending);
    }

    @Override
    public int getOffset() {
        return this.descending ? this.rowCount - this.currentOffset - 1 : this.currentOffset;
    }

    public String toString() {
        return this.currentOffset + "/" + this.rowCount + (this.descending ? "(DSC)" : "");
    }

    @Override
    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        inspector.visit("descending", this.descending);
    }
}

