/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment;

import java.util.List;
import javax.annotation.Nullable;
import org.apache.hive.druid.io.druid.collections.bitmap.BitmapFactory;
import org.apache.hive.druid.io.druid.collections.bitmap.MutableBitmap;
import org.apache.hive.druid.io.druid.query.dimension.DimensionSpec;
import org.apache.hive.druid.io.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.hive.druid.io.druid.segment.ColumnValueSelector;
import org.apache.hive.druid.io.druid.segment.DimensionHandlerUtils;
import org.apache.hive.druid.io.druid.segment.DimensionIndexer;
import org.apache.hive.druid.io.druid.segment.DimensionSelector;
import org.apache.hive.druid.io.druid.segment.FloatColumnSelector;
import org.apache.hive.druid.io.druid.segment.FloatWrappingDimensionSelector;
import org.apache.hive.druid.io.druid.segment.data.Indexed;
import org.apache.hive.druid.io.druid.segment.incremental.IncrementalIndex;
import org.apache.hive.druid.io.druid.segment.incremental.TimeAndDimsHolder;

public class FloatDimensionIndexer
implements DimensionIndexer<Float, Float, Float> {
    @Override
    public Float processRowValsToUnsortedEncodedKeyComponent(Object dimValues, boolean reportParseExceptions) {
        if (dimValues instanceof List) {
            throw new UnsupportedOperationException("Numeric columns do not support multivalue rows.");
        }
        Float ret = DimensionHandlerUtils.convertObjectToFloat(dimValues, reportParseExceptions);
        return ret == null ? DimensionHandlerUtils.ZERO_FLOAT : ret;
    }

    @Override
    public Float getUnsortedEncodedValueFromSorted(Float sortedIntermediateValue) {
        return sortedIntermediateValue;
    }

    @Override
    public Indexed<Float> getSortedIndexedValues() {
        throw new UnsupportedOperationException("Numeric columns do not support value dictionaries.");
    }

    @Override
    public Float getMinValue() {
        return Float.valueOf(Float.NEGATIVE_INFINITY);
    }

    @Override
    public Float getMaxValue() {
        return Float.valueOf(Float.POSITIVE_INFINITY);
    }

    @Override
    public int getCardinality() {
        return -1;
    }

    @Override
    public DimensionSelector makeDimensionSelector(DimensionSpec spec, TimeAndDimsHolder currEntry, IncrementalIndex.DimensionDesc desc) {
        return new FloatWrappingDimensionSelector(this.makeColumnValueSelector(currEntry, desc), spec.getExtractionFn());
    }

    @Override
    public ColumnValueSelector<?> makeColumnValueSelector(final TimeAndDimsHolder currEntry, IncrementalIndex.DimensionDesc desc) {
        final int dimIndex = desc.getIndex();
        class IndexerFloatColumnSelector
        implements FloatColumnSelector {
            IndexerFloatColumnSelector() {
            }

            @Override
            public float getFloat() {
                Object[] dims = currEntry.get().getDims();
                if (dimIndex >= dims.length) {
                    return 0.0f;
                }
                return ((Float)dims[dimIndex]).floatValue();
            }

            @Override
            @Nullable
            public Float getObject() {
                Object[] dims = currEntry.get().getDims();
                if (dimIndex >= dims.length) {
                    return null;
                }
                return (Float)dims[dimIndex];
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
            }
        }
        return new IndexerFloatColumnSelector();
    }

    @Override
    public int compareUnsortedEncodedKeyComponents(@Nullable Float lhs, @Nullable Float rhs) {
        return DimensionHandlerUtils.nullToZero(lhs).compareTo(DimensionHandlerUtils.nullToZero(rhs));
    }

    @Override
    public boolean checkUnsortedEncodedKeyComponentsEqual(@Nullable Float lhs, @Nullable Float rhs) {
        return DimensionHandlerUtils.nullToZero(lhs).equals(DimensionHandlerUtils.nullToZero(rhs));
    }

    @Override
    public int getUnsortedEncodedKeyComponentHashCode(@Nullable Float key) {
        return DimensionHandlerUtils.nullToZero(key).hashCode();
    }

    @Override
    public Object convertUnsortedEncodedKeyComponentToActualArrayOrList(Float key, boolean asList) {
        return key;
    }

    @Override
    public Float convertUnsortedEncodedKeyComponentToSortedEncodedKeyComponent(Float key) {
        return key;
    }

    @Override
    public void fillBitmapsFromUnsortedEncodedKeyComponent(Float key, int rowNum, MutableBitmap[] bitmapIndexes, BitmapFactory factory) {
        throw new UnsupportedOperationException("Numeric columns do not support bitmaps.");
    }
}

