/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment;

import com.ning.compress.BufferRecycler;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.io.druid.collections.NonBlockingPool;
import org.apache.hive.druid.io.druid.collections.ResourceHolder;
import org.apache.hive.druid.io.druid.collections.StupidPool;
import org.apache.hive.druid.io.druid.java.util.common.logger.Logger;

public class CompressedPools {
    private static final Logger log = new Logger(CompressedPools.class);
    public static final int BUFFER_SIZE = 65536;
    private static final NonBlockingPool<BufferRecycler> bufferRecyclerPool = new StupidPool<BufferRecycler>("bufferRecyclerPool", new Supplier<BufferRecycler>(){
        private final AtomicLong counter = new AtomicLong(0L);

        @Override
        public BufferRecycler get() {
            log.info("Allocating new bufferRecycler[%,d]", this.counter.incrementAndGet());
            return new BufferRecycler();
        }
    });
    private static final NonBlockingPool<byte[]> outputBytesPool = new StupidPool<byte[]>("outputBytesPool", new Supplier<byte[]>(){
        private final AtomicLong counter = new AtomicLong(0L);

        @Override
        public byte[] get() {
            log.info("Allocating new outputBytesPool[%,d]", this.counter.incrementAndGet());
            return new byte[65536];
        }
    });
    private static final NonBlockingPool<ByteBuffer> bigEndByteBufPool = new StupidPool<ByteBuffer>("bigEndByteBufPool", new Supplier<ByteBuffer>(){
        private final AtomicLong counter = new AtomicLong(0L);

        @Override
        public ByteBuffer get() {
            log.info("Allocating new bigEndByteBuf[%,d]", this.counter.incrementAndGet());
            return ByteBuffer.allocateDirect(65536).order(ByteOrder.BIG_ENDIAN);
        }
    });
    private static final NonBlockingPool<ByteBuffer> littleEndByteBufPool = new StupidPool<ByteBuffer>("littleEndByteBufPool", new Supplier<ByteBuffer>(){
        private final AtomicLong counter = new AtomicLong(0L);

        @Override
        public ByteBuffer get() {
            log.info("Allocating new littleEndByteBuf[%,d]", this.counter.incrementAndGet());
            return ByteBuffer.allocateDirect(65536).order(ByteOrder.LITTLE_ENDIAN);
        }
    });

    public static ResourceHolder<BufferRecycler> getBufferRecycler() {
        return bufferRecyclerPool.take();
    }

    public static ResourceHolder<byte[]> getOutputBytes() {
        return outputBytesPool.take();
    }

    public static ResourceHolder<ByteBuffer> getByteBuf(ByteOrder order) {
        if (order == ByteOrder.LITTLE_ENDIAN) {
            return littleEndByteBufPool.take();
        }
        return bigEndByteBufPool.take();
    }
}

