/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.topn;

import com.google.inject.Inject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.hive.druid.com.google.common.annotations.VisibleForTesting;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.com.google.common.collect.Ordering;
import org.apache.hive.druid.io.druid.java.util.common.ISE;
import org.apache.hive.druid.io.druid.java.util.common.granularity.Granularity;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequences;
import org.apache.hive.druid.io.druid.java.util.common.guava.nary.BinaryFn;
import org.apache.hive.druid.io.druid.query.BySegmentResultValue;
import org.apache.hive.druid.io.druid.query.CacheStrategy;
import org.apache.hive.druid.io.druid.query.IntervalChunkingQueryRunnerDecorator;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.query.QueryContexts;
import org.apache.hive.druid.io.druid.query.QueryPlus;
import org.apache.hive.druid.io.druid.query.QueryRunner;
import org.apache.hive.druid.io.druid.query.QueryToolChest;
import org.apache.hive.druid.io.druid.query.Result;
import org.apache.hive.druid.io.druid.query.ResultGranularTimestampComparator;
import org.apache.hive.druid.io.druid.query.ResultMergeQueryRunner;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorUtil;
import org.apache.hive.druid.io.druid.query.aggregation.MetricManipulationFn;
import org.apache.hive.druid.io.druid.query.aggregation.PostAggregator;
import org.apache.hive.druid.io.druid.query.cache.CacheKeyBuilder;
import org.apache.hive.druid.io.druid.query.dimension.DefaultDimensionSpec;
import org.apache.hive.druid.io.druid.query.dimension.DimensionSpec;
import org.apache.hive.druid.io.druid.query.topn.BySegmentTopNResultValue;
import org.apache.hive.druid.io.druid.query.topn.DefaultTopNQueryMetricsFactory;
import org.apache.hive.druid.io.druid.query.topn.DimensionAndMetricValueExtractor;
import org.apache.hive.druid.io.druid.query.topn.TopNBinaryFn;
import org.apache.hive.druid.io.druid.query.topn.TopNQuery;
import org.apache.hive.druid.io.druid.query.topn.TopNQueryConfig;
import org.apache.hive.druid.io.druid.query.topn.TopNQueryEngine;
import org.apache.hive.druid.io.druid.query.topn.TopNQueryMetrics;
import org.apache.hive.druid.io.druid.query.topn.TopNQueryMetricsFactory;
import org.apache.hive.druid.io.druid.query.topn.TopNResultValue;
import org.joda.time.DateTime;

public class TopNQueryQueryToolChest
extends QueryToolChest<Result<TopNResultValue>, TopNQuery> {
    private static final byte TOPN_QUERY = 1;
    private static final TypeReference<Result<TopNResultValue>> TYPE_REFERENCE = new TypeReference<Result<TopNResultValue>>(){};
    private static final TypeReference<Object> OBJECT_TYPE_REFERENCE = new TypeReference<Object>(){};
    private final TopNQueryConfig config;
    private final IntervalChunkingQueryRunnerDecorator intervalChunkingQueryRunnerDecorator;
    private final TopNQueryMetricsFactory queryMetricsFactory;

    @VisibleForTesting
    public TopNQueryQueryToolChest(TopNQueryConfig config, IntervalChunkingQueryRunnerDecorator intervalChunkingQueryRunnerDecorator) {
        this(config, intervalChunkingQueryRunnerDecorator, DefaultTopNQueryMetricsFactory.instance());
    }

    @Inject
    public TopNQueryQueryToolChest(TopNQueryConfig config, IntervalChunkingQueryRunnerDecorator intervalChunkingQueryRunnerDecorator, TopNQueryMetricsFactory queryMetricsFactory) {
        this.config = config;
        this.intervalChunkingQueryRunnerDecorator = intervalChunkingQueryRunnerDecorator;
        this.queryMetricsFactory = queryMetricsFactory;
    }

    protected static String[] extractFactoryName(List<AggregatorFactory> aggregatorFactories) {
        return Lists.transform(aggregatorFactories, new Function<AggregatorFactory, String>(){

            @Override
            @Nullable
            public String apply(@Nullable AggregatorFactory input) {
                return input.getName();
            }
        }).toArray(new String[0]);
    }

    private static List<PostAggregator> prunePostAggregators(TopNQuery query) {
        return AggregatorUtil.pruneDependentPostAgg(query.getPostAggregatorSpecs(), query.getTopNMetricSpec().getMetricName(query.getDimensionSpec()));
    }

    @Override
    public QueryRunner<Result<TopNResultValue>> mergeResults(QueryRunner<Result<TopNResultValue>> runner) {
        return new ResultMergeQueryRunner<Result<TopNResultValue>>(runner){

            @Override
            protected Ordering<Result<TopNResultValue>> makeOrdering(Query<Result<TopNResultValue>> query) {
                return ResultGranularTimestampComparator.create(((TopNQuery)query).getGranularity(), query.isDescending());
            }

            @Override
            protected BinaryFn<Result<TopNResultValue>, Result<TopNResultValue>, Result<TopNResultValue>> createMergeFn(Query<Result<TopNResultValue>> input) {
                TopNQuery query = (TopNQuery)input;
                return new TopNBinaryFn(query.getGranularity(), query.getDimensionSpec(), query.getTopNMetricSpec(), query.getThreshold(), query.getAggregatorSpecs(), query.getPostAggregatorSpecs());
            }
        };
    }

    public TopNQueryMetrics makeMetrics(TopNQuery query) {
        TopNQueryMetrics queryMetrics = this.queryMetricsFactory.makeMetrics();
        queryMetrics.query(query);
        return queryMetrics;
    }

    @Override
    public Function<Result<TopNResultValue>, Result<TopNResultValue>> makePreComputeManipulatorFn(final TopNQuery query, final MetricManipulationFn fn) {
        return new Function<Result<TopNResultValue>, Result<TopNResultValue>>(){
            private String dimension;
            private final List<PostAggregator> prunedAggs;
            private final AggregatorFactory[] aggregatorFactories;
            private final String[] aggFactoryNames;
            {
                this.dimension = query.getDimensionSpec().getOutputName();
                this.prunedAggs = TopNQueryQueryToolChest.prunePostAggregators(query);
                this.aggregatorFactories = query.getAggregatorSpecs().toArray(new AggregatorFactory[0]);
                this.aggFactoryNames = TopNQueryQueryToolChest.extractFactoryName(query.getAggregatorSpecs());
            }

            @Override
            public Result<TopNResultValue> apply(Result<TopNResultValue> result) {
                ArrayList<Map<String, Object>> serializedValues = Lists.newArrayList(Iterables.transform(result.getValue(), new Function<DimensionAndMetricValueExtractor, Map<String, Object>>(){

                    @Override
                    public Map<String, Object> apply(DimensionAndMetricValueExtractor input) {
                        HashMap<String, Object> values = Maps.newHashMapWithExpectedSize(aggregatorFactories.length + prunedAggs.size() + 1);
                        for (int i = 0; i < aggregatorFactories.length; ++i) {
                            String aggName = aggFactoryNames[i];
                            values.put(aggName, fn.manipulate(aggregatorFactories[i], input.getMetric(aggName)));
                        }
                        for (PostAggregator postAgg : prunedAggs) {
                            String name = postAgg.getName();
                            Object calculatedPostAgg = input.getMetric(name);
                            if (calculatedPostAgg != null) {
                                values.put(name, calculatedPostAgg);
                                continue;
                            }
                            values.put(name, postAgg.compute(values));
                        }
                        values.put(dimension, input.getDimensionValue(dimension));
                        return values;
                    }
                }));
                return new Result<TopNResultValue>(result.getTimestamp(), new TopNResultValue(serializedValues));
            }
        };
    }

    @Override
    public Function<Result<TopNResultValue>, Result<TopNResultValue>> makePostComputeManipulatorFn(final TopNQuery query, final MetricManipulationFn fn) {
        return new Function<Result<TopNResultValue>, Result<TopNResultValue>>(){
            private String dimension;
            private final AggregatorFactory[] aggregatorFactories;
            private final String[] aggFactoryNames;
            private final PostAggregator[] postAggregators;
            {
                this.dimension = query.getDimensionSpec().getOutputName();
                this.aggregatorFactories = query.getAggregatorSpecs().toArray(new AggregatorFactory[0]);
                this.aggFactoryNames = TopNQueryQueryToolChest.extractFactoryName(query.getAggregatorSpecs());
                this.postAggregators = query.getPostAggregatorSpecs().toArray(new PostAggregator[0]);
            }

            @Override
            public Result<TopNResultValue> apply(Result<TopNResultValue> result) {
                ArrayList<Map<String, Object>> serializedValues = Lists.newArrayList(Iterables.transform(result.getValue(), new Function<DimensionAndMetricValueExtractor, Map<String, Object>>(){

                    @Override
                    public Map<String, Object> apply(DimensionAndMetricValueExtractor input) {
                        HashMap<String, Object> values = Maps.newHashMapWithExpectedSize(aggregatorFactories.length + query.getPostAggregatorSpecs().size() + 1);
                        for (String name : aggFactoryNames) {
                            values.put(name, input.getMetric(name));
                        }
                        values.put(dimension, input.getDimensionValue(dimension));
                        for (PostAggregator postAgg : postAggregators) {
                            Object calculatedPostAgg = input.getMetric(postAgg.getName());
                            if (calculatedPostAgg != null) {
                                values.put(postAgg.getName(), calculatedPostAgg);
                                continue;
                            }
                            values.put(postAgg.getName(), postAgg.compute(values));
                        }
                        for (int i = 0; i < aggFactoryNames.length; ++i) {
                            String name = aggFactoryNames[i];
                            values.put(name, fn.manipulate(aggregatorFactories[i], input.getMetric(name)));
                        }
                        return values;
                    }
                }));
                return new Result<TopNResultValue>(result.getTimestamp(), new TopNResultValue(serializedValues));
            }
        };
    }

    @Override
    public TypeReference<Result<TopNResultValue>> getResultTypeReference() {
        return TYPE_REFERENCE;
    }

    @Override
    public CacheStrategy<Result<TopNResultValue>, Object, TopNQuery> getCacheStrategy(final TopNQuery query) {
        return new CacheStrategy<Result<TopNResultValue>, Object, TopNQuery>(){
            private final List<AggregatorFactory> aggs;
            private final List<PostAggregator> postAggs;
            {
                this.aggs = Lists.newArrayList(query.getAggregatorSpecs());
                this.postAggs = AggregatorUtil.pruneDependentPostAgg(query.getPostAggregatorSpecs(), query.getTopNMetricSpec().getMetricName(query.getDimensionSpec()));
            }

            @Override
            public boolean isCacheable(TopNQuery query2, boolean willMergeRunners) {
                return true;
            }

            @Override
            public byte[] computeCacheKey(TopNQuery query2) {
                CacheKeyBuilder builder = new CacheKeyBuilder(1).appendCacheable(query2.getDimensionSpec()).appendCacheable(query2.getTopNMetricSpec()).appendInt(query2.getThreshold()).appendCacheable(query2.getGranularity()).appendCacheable(query2.getDimensionsFilter()).appendCacheables(query2.getAggregatorSpecs()).appendCacheable(query2.getVirtualColumns());
                List postAggregators = TopNQueryQueryToolChest.prunePostAggregators(query2);
                if (!postAggregators.isEmpty()) {
                    builder.appendCacheablesIgnoringOrder(postAggregators);
                }
                return builder.build();
            }

            @Override
            public TypeReference<Object> getCacheObjectClazz() {
                return OBJECT_TYPE_REFERENCE;
            }

            @Override
            public Function<Result<TopNResultValue>, Object> prepareForCache() {
                return new Function<Result<TopNResultValue>, Object>(){
                    private final String[] aggFactoryNames;
                    {
                        this.aggFactoryNames = TopNQueryQueryToolChest.extractFactoryName(query.getAggregatorSpecs());
                    }

                    @Override
                    public Object apply(Result<TopNResultValue> input) {
                        ArrayList<DimensionAndMetricValueExtractor> results = Lists.newArrayList(input.getValue());
                        ArrayList<Serializable> retVal = Lists.newArrayListWithCapacity(results.size() + 1);
                        retVal.add(Long.valueOf(input.getTimestamp().getMillis()));
                        for (DimensionAndMetricValueExtractor result : results) {
                            ArrayList<Object> vals = Lists.newArrayListWithCapacity(this.aggFactoryNames.length + 2);
                            vals.add(result.getDimensionValue(query.getDimensionSpec().getOutputName()));
                            for (String aggName : this.aggFactoryNames) {
                                vals.add(result.getMetric(aggName));
                            }
                            retVal.add(vals);
                        }
                        return retVal;
                    }
                };
            }

            @Override
            public Function<Object, Result<TopNResultValue>> pullFromCache() {
                return new Function<Object, Result<TopNResultValue>>(){
                    private final Granularity granularity;
                    {
                        this.granularity = query.getGranularity();
                    }

                    @Override
                    public Result<TopNResultValue> apply(Object input) {
                        List results = (List)input;
                        ArrayList<LinkedHashMap<String, Object>> retVal = Lists.newArrayListWithCapacity(results.size());
                        Iterator inputIter = results.iterator();
                        DateTime timestamp = this.granularity.toDateTime(((Number)inputIter.next()).longValue());
                        while (inputIter.hasNext()) {
                            List result = (List)inputIter.next();
                            LinkedHashMap<String, Object> vals = Maps.newLinkedHashMap();
                            Iterator aggIter = aggs.iterator();
                            Iterator resultIter = result.iterator();
                            vals.put(query.getDimensionSpec().getOutputName(), resultIter.next());
                            while (aggIter.hasNext() && resultIter.hasNext()) {
                                AggregatorFactory factory = (AggregatorFactory)aggIter.next();
                                vals.put(factory.getName(), factory.deserialize(resultIter.next()));
                            }
                            for (PostAggregator postAgg : postAggs) {
                                vals.put(postAgg.getName(), postAgg.compute(vals));
                            }
                            retVal.add(vals);
                        }
                        return new Result<TopNResultValue>(timestamp, new TopNResultValue(retVal));
                    }
                };
            }
        };
    }

    @Override
    public QueryRunner<Result<TopNResultValue>> preMergeQueryDecoration(final QueryRunner<Result<TopNResultValue>> runner) {
        return this.intervalChunkingQueryRunnerDecorator.decorate(new QueryRunner<Result<TopNResultValue>>(){

            @Override
            public Sequence<Result<TopNResultValue>> run(QueryPlus<Result<TopNResultValue>> queryPlus, Map<String, Object> responseContext) {
                TopNQuery delegateTopNQuery;
                TopNQuery topNQuery = (TopNQuery)queryPlus.getQuery();
                if (topNQuery.getDimensionsFilter() != null) {
                    topNQuery = topNQuery.withDimFilter(topNQuery.getDimensionsFilter().optimize());
                }
                if (TopNQueryEngine.canApplyExtractionInPost(delegateTopNQuery = topNQuery)) {
                    DimensionSpec dimensionSpec = delegateTopNQuery.getDimensionSpec();
                    QueryPlus<Result<TopNResultValue>> delegateQueryPlus = queryPlus.withQuery(delegateTopNQuery.withDimensionSpec(new DefaultDimensionSpec(dimensionSpec.getDimension(), dimensionSpec.getOutputName())));
                    return runner.run(delegateQueryPlus, responseContext);
                }
                return runner.run(queryPlus.withQuery(delegateTopNQuery), responseContext);
            }
        }, this);
    }

    @Override
    public QueryRunner<Result<TopNResultValue>> postMergeQueryDecoration(QueryRunner<Result<TopNResultValue>> runner) {
        final ThresholdAdjustingQueryRunner thresholdRunner = new ThresholdAdjustingQueryRunner(runner, this.config);
        return new QueryRunner<Result<TopNResultValue>>(){

            @Override
            public Sequence<Result<TopNResultValue>> run(QueryPlus<Result<TopNResultValue>> queryPlus, Map<String, Object> responseContext) {
                Sequence<Result<TopNResultValue>> resultSequence = thresholdRunner.run(queryPlus, responseContext);
                final TopNQuery topNQuery = (TopNQuery)queryPlus.getQuery();
                if (!TopNQueryEngine.canApplyExtractionInPost(topNQuery)) {
                    return resultSequence;
                }
                return Sequences.map(resultSequence, new Function<Result<TopNResultValue>, Result<TopNResultValue>>(){

                    @Override
                    public Result<TopNResultValue> apply(Result<TopNResultValue> input) {
                        TopNResultValue resultValue = input.getValue();
                        return new Result<TopNResultValue>(input.getTimestamp(), new TopNResultValue(Lists.transform(resultValue.getValue(), new Function<DimensionAndMetricValueExtractor, DimensionAndMetricValueExtractor>(){

                            @Override
                            public DimensionAndMetricValueExtractor apply(DimensionAndMetricValueExtractor input) {
                                String dimOutputName = topNQuery.getDimensionSpec().getOutputName();
                                Object dimValue = input.getDimensionValue(dimOutputName);
                                Map<String, Object> map = input.getBaseObject();
                                map.put(dimOutputName, topNQuery.getDimensionSpec().getExtractionFn().apply(dimValue));
                                return input;
                            }
                        })));
                    }
                });
            }
        };
    }

    static class ThresholdAdjustingQueryRunner
    implements QueryRunner<Result<TopNResultValue>> {
        private final QueryRunner<Result<TopNResultValue>> runner;
        private final TopNQueryConfig config;

        public ThresholdAdjustingQueryRunner(QueryRunner<Result<TopNResultValue>> runner, TopNQueryConfig config) {
            this.runner = runner;
            this.config = config;
        }

        @Override
        public Sequence<Result<TopNResultValue>> run(QueryPlus<Result<TopNResultValue>> queryPlus, Map<String, Object> responseContext) {
            Query<Result<TopNResultValue>> input = queryPlus.getQuery();
            if (!(input instanceof TopNQuery)) {
                throw new ISE("Can only handle [%s], got [%s]", TopNQuery.class, input.getClass());
            }
            final TopNQuery query = (TopNQuery)input;
            int minTopNThreshold = query.getContextValue("minTopNThreshold", this.config.getMinTopNThreshold());
            if (query.getThreshold() > minTopNThreshold) {
                return this.runner.run(queryPlus, responseContext);
            }
            final boolean isBySegment = QueryContexts.isBySegment(query);
            return Sequences.map(this.runner.run(queryPlus.withQuery(query.withThreshold(minTopNThreshold)), responseContext), new Function<Result<TopNResultValue>, Result<TopNResultValue>>(){

                @Override
                public Result<TopNResultValue> apply(Result<TopNResultValue> input) {
                    if (isBySegment) {
                        BySegmentResultValue value = (BySegmentResultValue)((Object)input.getValue());
                        return new Result<TopNResultValue>(input.getTimestamp(), new BySegmentTopNResultValue(Lists.transform(value.getResults(), new Function<Result<TopNResultValue>, Result<TopNResultValue>>(){

                            @Override
                            public Result<TopNResultValue> apply(Result<TopNResultValue> input) {
                                return new Result<TopNResultValue>(input.getTimestamp(), new TopNResultValue(Lists.newArrayList(Iterables.limit(input.getValue(), query.getThreshold()))));
                            }
                        }), value.getSegmentId(), value.getInterval()));
                    }
                    return new Result<TopNResultValue>(input.getTimestamp(), new TopNResultValue(Lists.newArrayList(Iterables.limit(input.getValue(), query.getThreshold()))));
                }
            });
        }
    }
}

