/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.topn;

import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.io.druid.query.DefaultQueryMetrics;
import org.apache.hive.druid.io.druid.query.DruidMetrics;
import org.apache.hive.druid.io.druid.query.topn.TopNAlgorithm;
import org.apache.hive.druid.io.druid.query.topn.TopNParams;
import org.apache.hive.druid.io.druid.query.topn.TopNQuery;
import org.apache.hive.druid.io.druid.query.topn.TopNQueryMetrics;
import org.apache.hive.druid.io.druid.segment.ColumnValueSelector;
import org.apache.hive.druid.io.druid.segment.Cursor;

public class DefaultTopNQueryMetrics
extends DefaultQueryMetrics<TopNQuery>
implements TopNQueryMetrics {
    public DefaultTopNQueryMetrics(ObjectMapper jsonMapper) {
        super(jsonMapper);
    }

    @Override
    public void query(TopNQuery query) {
        super.query(query);
        this.threshold(query);
        this.dimension(query);
        this.numMetrics(query);
        this.numComplexMetrics(query);
        this.granularity(query);
    }

    @Override
    public void threshold(TopNQuery query) {
        this.setDimension("threshold", String.valueOf(query.getThreshold()));
    }

    @Override
    public void dimension(TopNQuery query) {
        this.setDimension("dimension", query.getDimensionSpec().getDimension());
    }

    @Override
    public void numMetrics(TopNQuery query) {
        this.setDimension("numMetrics", String.valueOf(query.getAggregatorSpecs().size()));
    }

    @Override
    public void numComplexMetrics(TopNQuery query) {
        int numComplexAggs = DruidMetrics.findNumComplexAggs(query.getAggregatorSpecs());
        this.setDimension("numComplexMetrics", String.valueOf(numComplexAggs));
    }

    @Override
    public void granularity(TopNQuery query) {
    }

    @Override
    public void dimensionCardinality(int cardinality) {
    }

    @Override
    public void algorithm(TopNAlgorithm algorithm) {
    }

    @Override
    public void cursor(Cursor cursor) {
    }

    @Override
    public void columnValueSelector(ColumnValueSelector columnValueSelector) {
    }

    @Override
    public void numValuesPerPass(TopNParams params) {
    }

    @Override
    public TopNQueryMetrics addProcessedRows(long numRows) {
        return this;
    }

    @Override
    public void startRecordingScanTime() {
    }

    @Override
    public TopNQueryMetrics stopRecordingScanTime() {
        return this;
    }
}

