/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.timeseries;

import com.google.inject.Inject;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.hive.druid.io.druid.java.util.common.ISE;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.io.druid.query.ChainedExecutionQueryRunner;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.query.QueryPlus;
import org.apache.hive.druid.io.druid.query.QueryRunner;
import org.apache.hive.druid.io.druid.query.QueryRunnerFactory;
import org.apache.hive.druid.io.druid.query.QueryToolChest;
import org.apache.hive.druid.io.druid.query.QueryWatcher;
import org.apache.hive.druid.io.druid.query.Result;
import org.apache.hive.druid.io.druid.query.timeseries.TimeseriesQuery;
import org.apache.hive.druid.io.druid.query.timeseries.TimeseriesQueryEngine;
import org.apache.hive.druid.io.druid.query.timeseries.TimeseriesQueryQueryToolChest;
import org.apache.hive.druid.io.druid.query.timeseries.TimeseriesResultValue;
import org.apache.hive.druid.io.druid.segment.Segment;
import org.apache.hive.druid.io.druid.segment.StorageAdapter;

public class TimeseriesQueryRunnerFactory
implements QueryRunnerFactory<Result<TimeseriesResultValue>, TimeseriesQuery> {
    private final TimeseriesQueryQueryToolChest toolChest;
    private final TimeseriesQueryEngine engine;
    private final QueryWatcher queryWatcher;

    @Inject
    public TimeseriesQueryRunnerFactory(TimeseriesQueryQueryToolChest toolChest, TimeseriesQueryEngine engine, QueryWatcher queryWatcher) {
        this.toolChest = toolChest;
        this.engine = engine;
        this.queryWatcher = queryWatcher;
    }

    @Override
    public QueryRunner<Result<TimeseriesResultValue>> createRunner(Segment segment) {
        return new TimeseriesQueryRunner(this.engine, segment.asStorageAdapter());
    }

    @Override
    public QueryRunner<Result<TimeseriesResultValue>> mergeRunners(ExecutorService queryExecutor, Iterable<QueryRunner<Result<TimeseriesResultValue>>> queryRunners) {
        return new ChainedExecutionQueryRunner<Result<TimeseriesResultValue>>(queryExecutor, this.queryWatcher, queryRunners);
    }

    @Override
    public QueryToolChest<Result<TimeseriesResultValue>, TimeseriesQuery> getToolchest() {
        return this.toolChest;
    }

    private static class TimeseriesQueryRunner
    implements QueryRunner<Result<TimeseriesResultValue>> {
        private final TimeseriesQueryEngine engine;
        private final StorageAdapter adapter;

        private TimeseriesQueryRunner(TimeseriesQueryEngine engine, StorageAdapter adapter) {
            this.engine = engine;
            this.adapter = adapter;
        }

        @Override
        public Sequence<Result<TimeseriesResultValue>> run(QueryPlus<Result<TimeseriesResultValue>> queryPlus, Map<String, Object> responseContext) {
            Query<Result<TimeseriesResultValue>> input = queryPlus.getQuery();
            if (!(input instanceof TimeseriesQuery)) {
                throw new ISE("Got a [%s] which isn't a %s", input.getClass(), TimeseriesQuery.class);
            }
            return this.engine.process((TimeseriesQuery)input, this.adapter);
        }
    }
}

