/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.timeseries;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.hive.druid.com.google.common.annotations.VisibleForTesting;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.com.google.common.collect.Ordering;
import org.apache.hive.druid.io.druid.java.util.common.granularity.Granularity;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.io.druid.java.util.common.guava.nary.BinaryFn;
import org.apache.hive.druid.io.druid.query.CacheStrategy;
import org.apache.hive.druid.io.druid.query.IntervalChunkingQueryRunnerDecorator;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.query.QueryPlus;
import org.apache.hive.druid.io.druid.query.QueryRunner;
import org.apache.hive.druid.io.druid.query.QueryToolChest;
import org.apache.hive.druid.io.druid.query.Result;
import org.apache.hive.druid.io.druid.query.ResultGranularTimestampComparator;
import org.apache.hive.druid.io.druid.query.ResultMergeQueryRunner;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.MetricManipulationFn;
import org.apache.hive.druid.io.druid.query.aggregation.PostAggregator;
import org.apache.hive.druid.io.druid.query.cache.CacheKeyBuilder;
import org.apache.hive.druid.io.druid.query.timeseries.DefaultTimeseriesQueryMetricsFactory;
import org.apache.hive.druid.io.druid.query.timeseries.TimeseriesBinaryFn;
import org.apache.hive.druid.io.druid.query.timeseries.TimeseriesQuery;
import org.apache.hive.druid.io.druid.query.timeseries.TimeseriesQueryMetrics;
import org.apache.hive.druid.io.druid.query.timeseries.TimeseriesQueryMetricsFactory;
import org.apache.hive.druid.io.druid.query.timeseries.TimeseriesResultValue;
import org.joda.time.DateTime;

public class TimeseriesQueryQueryToolChest
extends QueryToolChest<Result<TimeseriesResultValue>, TimeseriesQuery> {
    private static final byte TIMESERIES_QUERY = 0;
    private static final TypeReference<Object> OBJECT_TYPE_REFERENCE = new TypeReference<Object>(){};
    private static final TypeReference<Result<TimeseriesResultValue>> TYPE_REFERENCE = new TypeReference<Result<TimeseriesResultValue>>(){};
    private final IntervalChunkingQueryRunnerDecorator intervalChunkingQueryRunnerDecorator;
    private final TimeseriesQueryMetricsFactory queryMetricsFactory;

    @VisibleForTesting
    public TimeseriesQueryQueryToolChest(IntervalChunkingQueryRunnerDecorator intervalChunkingQueryRunnerDecorator) {
        this(intervalChunkingQueryRunnerDecorator, DefaultTimeseriesQueryMetricsFactory.instance());
    }

    @Inject
    public TimeseriesQueryQueryToolChest(IntervalChunkingQueryRunnerDecorator intervalChunkingQueryRunnerDecorator, TimeseriesQueryMetricsFactory queryMetricsFactory) {
        this.intervalChunkingQueryRunnerDecorator = intervalChunkingQueryRunnerDecorator;
        this.queryMetricsFactory = queryMetricsFactory;
    }

    @Override
    public QueryRunner<Result<TimeseriesResultValue>> mergeResults(QueryRunner<Result<TimeseriesResultValue>> queryRunner) {
        return new ResultMergeQueryRunner<Result<TimeseriesResultValue>>(queryRunner){

            @Override
            public Sequence<Result<TimeseriesResultValue>> doRun(QueryRunner<Result<TimeseriesResultValue>> baseRunner, QueryPlus<Result<TimeseriesResultValue>> queryPlus, Map<String, Object> context) {
                return super.doRun(baseRunner, queryPlus.withQuery(((TimeseriesQuery)queryPlus.getQuery()).withPostAggregatorSpecs(ImmutableList.of())), context);
            }

            @Override
            protected Ordering<Result<TimeseriesResultValue>> makeOrdering(Query<Result<TimeseriesResultValue>> query) {
                return ResultGranularTimestampComparator.create(((TimeseriesQuery)query).getGranularity(), query.isDescending());
            }

            @Override
            protected BinaryFn<Result<TimeseriesResultValue>, Result<TimeseriesResultValue>, Result<TimeseriesResultValue>> createMergeFn(Query<Result<TimeseriesResultValue>> input) {
                TimeseriesQuery query = (TimeseriesQuery)input;
                return new TimeseriesBinaryFn(query.getGranularity(), query.getAggregatorSpecs());
            }
        };
    }

    public TimeseriesQueryMetrics makeMetrics(TimeseriesQuery query) {
        TimeseriesQueryMetrics queryMetrics = this.queryMetricsFactory.makeMetrics();
        queryMetrics.query(query);
        return queryMetrics;
    }

    @Override
    public TypeReference<Result<TimeseriesResultValue>> getResultTypeReference() {
        return TYPE_REFERENCE;
    }

    @Override
    public CacheStrategy<Result<TimeseriesResultValue>, Object, TimeseriesQuery> getCacheStrategy(final TimeseriesQuery query) {
        return new CacheStrategy<Result<TimeseriesResultValue>, Object, TimeseriesQuery>(){
            private final List<AggregatorFactory> aggs;
            {
                this.aggs = query.getAggregatorSpecs();
            }

            @Override
            public boolean isCacheable(TimeseriesQuery query2, boolean willMergeRunners) {
                return true;
            }

            @Override
            public byte[] computeCacheKey(TimeseriesQuery query2) {
                return new CacheKeyBuilder(0).appendBoolean(query2.isDescending()).appendBoolean(query2.isSkipEmptyBuckets()).appendCacheable(query2.getGranularity()).appendCacheable(query2.getDimensionsFilter()).appendCacheables(query2.getAggregatorSpecs()).appendCacheable(query2.getVirtualColumns()).build();
            }

            @Override
            public TypeReference<Object> getCacheObjectClazz() {
                return OBJECT_TYPE_REFERENCE;
            }

            @Override
            public Function<Result<TimeseriesResultValue>, Object> prepareForCache() {
                return new Function<Result<TimeseriesResultValue>, Object>(){

                    @Override
                    public Object apply(Result<TimeseriesResultValue> input) {
                        TimeseriesResultValue results = input.getValue();
                        ArrayList<Object> retVal = Lists.newArrayListWithCapacity(1 + aggs.size());
                        retVal.add(input.getTimestamp().getMillis());
                        for (AggregatorFactory agg : aggs) {
                            retVal.add(results.getMetric(agg.getName()));
                        }
                        return retVal;
                    }
                };
            }

            @Override
            public Function<Object, Result<TimeseriesResultValue>> pullFromCache() {
                return new Function<Object, Result<TimeseriesResultValue>>(){
                    private final Granularity granularity;
                    {
                        this.granularity = query.getGranularity();
                    }

                    @Override
                    public Result<TimeseriesResultValue> apply(@Nullable Object input) {
                        List results = (List)input;
                        LinkedHashMap<String, Object> retVal = Maps.newLinkedHashMap();
                        Iterator aggsIter = aggs.iterator();
                        Iterator resultIter = results.iterator();
                        DateTime timestamp = this.granularity.toDateTime(((Number)resultIter.next()).longValue());
                        while (aggsIter.hasNext() && resultIter.hasNext()) {
                            AggregatorFactory factory = (AggregatorFactory)aggsIter.next();
                            retVal.put(factory.getName(), factory.deserialize(resultIter.next()));
                        }
                        return new Result<TimeseriesResultValue>(timestamp, new TimeseriesResultValue(retVal));
                    }
                };
            }
        };
    }

    @Override
    public QueryRunner<Result<TimeseriesResultValue>> preMergeQueryDecoration(final QueryRunner<Result<TimeseriesResultValue>> runner) {
        return this.intervalChunkingQueryRunnerDecorator.decorate(new QueryRunner<Result<TimeseriesResultValue>>(){

            @Override
            public Sequence<Result<TimeseriesResultValue>> run(QueryPlus<Result<TimeseriesResultValue>> queryPlus, Map<String, Object> responseContext) {
                TimeseriesQuery timeseriesQuery = (TimeseriesQuery)queryPlus.getQuery();
                if (timeseriesQuery.getDimensionsFilter() != null) {
                    timeseriesQuery = timeseriesQuery.withDimFilter(timeseriesQuery.getDimensionsFilter().optimize());
                    queryPlus = queryPlus.withQuery(timeseriesQuery);
                }
                return runner.run(queryPlus, responseContext);
            }
        }, this);
    }

    @Override
    public Function<Result<TimeseriesResultValue>, Result<TimeseriesResultValue>> makePreComputeManipulatorFn(TimeseriesQuery query, MetricManipulationFn fn) {
        return this.makeComputeManipulatorFn(query, fn, false);
    }

    @Override
    public Function<Result<TimeseriesResultValue>, Result<TimeseriesResultValue>> makePostComputeManipulatorFn(TimeseriesQuery query, MetricManipulationFn fn) {
        return this.makeComputeManipulatorFn(query, fn, true);
    }

    private Function<Result<TimeseriesResultValue>, Result<TimeseriesResultValue>> makeComputeManipulatorFn(final TimeseriesQuery query, final MetricManipulationFn fn, final boolean calculatePostAggs) {
        return new Function<Result<TimeseriesResultValue>, Result<TimeseriesResultValue>>(){

            @Override
            public Result<TimeseriesResultValue> apply(Result<TimeseriesResultValue> result) {
                TimeseriesResultValue holder = result.getValue();
                HashMap<String, Object> values = Maps.newHashMap(holder.getBaseObject());
                if (calculatePostAggs && !query.getPostAggregatorSpecs().isEmpty()) {
                    for (AggregatorFactory agg : query.getAggregatorSpecs()) {
                        values.put(agg.getName(), holder.getMetric(agg.getName()));
                    }
                    for (PostAggregator postAgg : query.getPostAggregatorSpecs()) {
                        values.put(postAgg.getName(), postAgg.compute(values));
                    }
                }
                for (AggregatorFactory agg : query.getAggregatorSpecs()) {
                    values.put(agg.getName(), fn.manipulate(agg, holder.getMetric(agg.getName())));
                }
                return new Result<TimeseriesResultValue>(result.getTimestamp(), new TimeseriesResultValue(values));
            }
        };
    }
}

