/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.select;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.io.druid.java.util.common.DateTimes;
import org.apache.hive.druid.io.druid.java.util.common.IAE;
import org.apache.hive.druid.io.druid.java.util.common.ISE;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.io.druid.query.ColumnSelectorPlus;
import org.apache.hive.druid.io.druid.query.QueryRunnerHelper;
import org.apache.hive.druid.io.druid.query.Result;
import org.apache.hive.druid.io.druid.query.dimension.ColumnSelectorStrategy;
import org.apache.hive.druid.io.druid.query.dimension.ColumnSelectorStrategyFactory;
import org.apache.hive.druid.io.druid.query.dimension.DefaultDimensionSpec;
import org.apache.hive.druid.io.druid.query.dimension.DimensionSpec;
import org.apache.hive.druid.io.druid.query.filter.Filter;
import org.apache.hive.druid.io.druid.query.select.EventHolder;
import org.apache.hive.druid.io.druid.query.select.PagingOffset;
import org.apache.hive.druid.io.druid.query.select.SelectQuery;
import org.apache.hive.druid.io.druid.query.select.SelectResultValue;
import org.apache.hive.druid.io.druid.query.select.SelectResultValueBuilder;
import org.apache.hive.druid.io.druid.segment.BaseDoubleColumnValueSelector;
import org.apache.hive.druid.io.druid.segment.BaseFloatColumnValueSelector;
import org.apache.hive.druid.io.druid.segment.BaseLongColumnValueSelector;
import org.apache.hive.druid.io.druid.segment.BaseObjectColumnValueSelector;
import org.apache.hive.druid.io.druid.segment.ColumnValueSelector;
import org.apache.hive.druid.io.druid.segment.Cursor;
import org.apache.hive.druid.io.druid.segment.DimensionHandlerUtils;
import org.apache.hive.druid.io.druid.segment.DimensionSelector;
import org.apache.hive.druid.io.druid.segment.Segment;
import org.apache.hive.druid.io.druid.segment.StorageAdapter;
import org.apache.hive.druid.io.druid.segment.column.ColumnCapabilities;
import org.apache.hive.druid.io.druid.segment.column.ValueType;
import org.apache.hive.druid.io.druid.segment.data.IndexedInts;
import org.apache.hive.druid.io.druid.segment.filter.Filters;
import org.apache.hive.druid.io.druid.timeline.DataSegmentUtils;
import org.joda.time.Interval;

public class SelectQueryEngine {
    private static final SelectStrategyFactory STRATEGY_FACTORY = new SelectStrategyFactory();

    public Sequence<Result<SelectResultValue>> process(final SelectQuery query, Segment segment) {
        StorageAdapter adapter = segment.asStorageAdapter();
        if (adapter == null) {
            throw new ISE("Null storage adapter found. Probably trying to issue a query against a segment being memory unmapped.", new Object[0]);
        }
        String dataSource = Iterables.getOnlyElement(query.getDataSource().getNames());
        final List<DimensionSpec> dims = query.getDimensions() == null || query.getDimensions().isEmpty() ? DefaultDimensionSpec.toSpec(adapter.getAvailableDimensions()) : query.getDimensions();
        final Iterable<String> metrics = query.getMetrics() == null || query.getMetrics().isEmpty() ? adapter.getAvailableMetrics() : query.getMetrics();
        List<Interval> intervals = query.getQuerySegmentSpec().getIntervals();
        Preconditions.checkArgument(intervals.size() == 1, "Can only handle a single interval, got[%s]", new Object[]{intervals});
        final String segmentId = DataSegmentUtils.withInterval(dataSource, segment.getIdentifier(), intervals.get(0));
        Filter filter = Filters.convertToCNFFromQueryContext(query, Filters.toFilter(query.getDimensionsFilter()));
        return QueryRunnerHelper.makeCursorBasedQuery(adapter, query.getQuerySegmentSpec().getIntervals(), filter, query.getVirtualColumns(), query.isDescending(), query.getGranularity(), new Function<Cursor, Result<SelectResultValue>>(){

            @Override
            public Result<SelectResultValue> apply(Cursor cursor) {
                SelectResultValueBuilder builder = new SelectResultValueBuilder(cursor.getTime(), query.getPagingSpec(), query.isDescending());
                ColumnValueSelector timestampColumnSelector = cursor.getColumnSelectorFactory().makeColumnValueSelector("__time");
                List<ColumnSelectorPlus<SelectColumnSelectorStrategy>> selectorPlusList = Arrays.asList(DimensionHandlerUtils.createColumnSelectorPluses(STRATEGY_FACTORY, Lists.newArrayList(dims), cursor.getColumnSelectorFactory()));
                for (Object dimSpec : dims) {
                    builder.addDimension(dimSpec.getOutputName());
                }
                HashMap<String, BaseObjectColumnValueSelector<?>> metSelectors = Maps.newHashMap();
                for (String metric : metrics) {
                    ColumnValueSelector metricSelector = cursor.getColumnSelectorFactory().makeColumnValueSelector(metric);
                    metSelectors.put(metric, metricSelector);
                    builder.addMetric(metric);
                }
                PagingOffset offset = query.getPagingOffset(segmentId);
                cursor.advanceTo(offset.startDelta());
                int lastOffset = offset.startOffset();
                while (!cursor.isDone() && offset.hasNext()) {
                    Map<String, Object> theEvent = SelectQueryEngine.singleEvent("timestamp", timestampColumnSelector, selectorPlusList, metSelectors);
                    lastOffset = offset.current();
                    builder.addEntry(new EventHolder(segmentId, lastOffset, theEvent));
                    cursor.advance();
                    offset.next();
                }
                builder.finished(segmentId, lastOffset);
                return builder.build();
            }
        });
    }

    public static Map<String, Object> singleEvent(String timestampKey, BaseLongColumnValueSelector timestampColumnSelector, List<ColumnSelectorPlus<SelectColumnSelectorStrategy>> selectorPlusList, Map<String, BaseObjectColumnValueSelector<?>> metSelectors) {
        LinkedHashMap<String, Object> theEvent = Maps.newLinkedHashMap();
        theEvent.put(timestampKey, DateTimes.utc(timestampColumnSelector.getLong()));
        for (ColumnSelectorPlus<SelectColumnSelectorStrategy> columnSelectorPlus : selectorPlusList) {
            columnSelectorPlus.getColumnSelectorStrategy().addRowValuesToSelectResult(columnSelectorPlus.getOutputName(), columnSelectorPlus.getSelector(), theEvent);
        }
        for (Map.Entry entry : metSelectors.entrySet()) {
            String metric = (String)entry.getKey();
            BaseObjectColumnValueSelector selector = (BaseObjectColumnValueSelector)entry.getValue();
            if (selector == null) {
                theEvent.put(metric, null);
                continue;
            }
            theEvent.put(metric, selector.getObject());
        }
        return theEvent;
    }

    public static class DoubleSelectColumnSelectorStrategy
    implements SelectColumnSelectorStrategy<BaseDoubleColumnValueSelector> {
        @Override
        public void addRowValuesToSelectResult(String outputName, BaseDoubleColumnValueSelector selector, Map<String, Object> resultMap) {
            if (selector == null) {
                resultMap.put(outputName, null);
            } else {
                resultMap.put(outputName, selector.getDouble());
            }
        }
    }

    public static class FloatSelectColumnSelectorStrategy
    implements SelectColumnSelectorStrategy<BaseFloatColumnValueSelector> {
        @Override
        public void addRowValuesToSelectResult(String outputName, BaseFloatColumnValueSelector selector, Map<String, Object> resultMap) {
            if (selector == null) {
                resultMap.put(outputName, null);
            } else {
                resultMap.put(outputName, Float.valueOf(selector.getFloat()));
            }
        }
    }

    public static class LongSelectColumnSelectorStrategy
    implements SelectColumnSelectorStrategy<BaseLongColumnValueSelector> {
        @Override
        public void addRowValuesToSelectResult(String outputName, BaseLongColumnValueSelector selector, Map<String, Object> resultMap) {
            if (selector == null) {
                resultMap.put(outputName, null);
            } else {
                resultMap.put(outputName, selector.getLong());
            }
        }
    }

    public static class StringSelectColumnSelectorStrategy
    implements SelectColumnSelectorStrategy<DimensionSelector> {
        @Override
        public void addRowValuesToSelectResult(String outputName, DimensionSelector selector, Map<String, Object> resultMap) {
            if (selector == null) {
                resultMap.put(outputName, null);
            } else {
                IndexedInts vals = selector.getRow();
                if (vals.size() == 1) {
                    String dimVal = selector.lookupName(vals.get(0));
                    resultMap.put(outputName, dimVal);
                } else {
                    ArrayList<String> dimVals = new ArrayList<String>(vals.size());
                    for (int i = 0; i < vals.size(); ++i) {
                        dimVals.add(selector.lookupName(vals.get(i)));
                    }
                    resultMap.put(outputName, dimVals);
                }
            }
        }
    }

    public static interface SelectColumnSelectorStrategy<ValueSelectorType>
    extends ColumnSelectorStrategy {
        public void addRowValuesToSelectResult(String var1, ValueSelectorType var2, Map<String, Object> var3);
    }

    public static class SelectStrategyFactory
    implements ColumnSelectorStrategyFactory<SelectColumnSelectorStrategy> {
        @Override
        public SelectColumnSelectorStrategy makeColumnSelectorStrategy(ColumnCapabilities capabilities, ColumnValueSelector selector) {
            ValueType type = capabilities.getType();
            switch (type) {
                case STRING: {
                    return new StringSelectColumnSelectorStrategy();
                }
                case LONG: {
                    return new LongSelectColumnSelectorStrategy();
                }
                case FLOAT: {
                    return new FloatSelectColumnSelectorStrategy();
                }
                case DOUBLE: {
                    return new DoubleSelectColumnSelectorStrategy();
                }
            }
            throw new IAE("Cannot create query type helper from invalid type [%s]", new Object[]{type});
        }
    }
}

