/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.search;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Objects;
import org.apache.hive.druid.io.druid.query.search.SearchQuerySpec;

public class ContainsSearchQuerySpec
implements SearchQuerySpec {
    private static final byte CACHE_TYPE_ID = 1;
    private final String value;
    private final boolean caseSensitive;

    @JsonCreator
    public ContainsSearchQuerySpec(@JsonProperty(value="value") String value, @JsonProperty(value="caseSensitive") boolean caseSensitive) {
        this.value = value;
        this.caseSensitive = caseSensitive;
    }

    @JsonProperty
    public String getValue() {
        return this.value;
    }

    @JsonProperty
    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    @Override
    public boolean accept(@Nullable String dimVal) {
        if (dimVal == null || this.value == null) {
            return false;
        }
        if (this.caseSensitive) {
            return dimVal.contains(this.value);
        }
        return StringUtils.containsIgnoreCase((String)dimVal, (String)this.value);
    }

    @Override
    public byte[] getCacheKey() {
        if (this.value == null) {
            return ByteBuffer.allocate(2).put((byte)1).put(this.caseSensitive ? (byte)1 : 0).array();
        }
        byte[] valueBytes = org.apache.hive.druid.io.druid.java.util.common.StringUtils.toUtf8(this.value);
        return ByteBuffer.allocate(2 + valueBytes.length).put((byte)1).put(this.caseSensitive ? (byte)1 : 0).put(valueBytes).array();
    }

    public String toString() {
        return "ContainsSearchQuerySpec{value=" + this.value + ", caseSensitive=" + this.caseSensitive + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContainsSearchQuerySpec that = (ContainsSearchQuerySpec)o;
        if (this.caseSensitive ^ that.caseSensitive) {
            return false;
        }
        if (this.value == null && that.value == null) {
            return true;
        }
        return this.value != null && this.value.equals(that.value);
    }

    public int hashCode() {
        return Objects.hashCode(this.value) + (this.caseSensitive ? 1 : 0);
    }
}

