/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.metadata;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.com.google.common.util.concurrent.ListenableFuture;
import org.apache.hive.druid.com.google.common.util.concurrent.ListeningExecutorService;
import org.apache.hive.druid.com.google.common.util.concurrent.MoreExecutors;
import org.apache.hive.druid.io.druid.data.input.impl.TimestampSpec;
import org.apache.hive.druid.io.druid.java.util.common.granularity.Granularity;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequences;
import org.apache.hive.druid.io.druid.java.util.common.logger.Logger;
import org.apache.hive.druid.io.druid.query.AbstractPrioritizedCallable;
import org.apache.hive.druid.io.druid.query.ConcatQueryRunner;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.query.QueryContexts;
import org.apache.hive.druid.io.druid.query.QueryInterruptedException;
import org.apache.hive.druid.io.druid.query.QueryPlus;
import org.apache.hive.druid.io.druid.query.QueryRunner;
import org.apache.hive.druid.io.druid.query.QueryRunnerFactory;
import org.apache.hive.druid.io.druid.query.QueryToolChest;
import org.apache.hive.druid.io.druid.query.QueryWatcher;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.query.metadata.SegmentAnalyzer;
import org.apache.hive.druid.io.druid.query.metadata.SegmentMetadataQueryQueryToolChest;
import org.apache.hive.druid.io.druid.query.metadata.metadata.ColumnAnalysis;
import org.apache.hive.druid.io.druid.query.metadata.metadata.ColumnIncluderator;
import org.apache.hive.druid.io.druid.query.metadata.metadata.SegmentAnalysis;
import org.apache.hive.druid.io.druid.query.metadata.metadata.SegmentMetadataQuery;
import org.apache.hive.druid.io.druid.segment.Metadata;
import org.apache.hive.druid.io.druid.segment.Segment;
import org.joda.time.Interval;

public class SegmentMetadataQueryRunnerFactory
implements QueryRunnerFactory<SegmentAnalysis, SegmentMetadataQuery> {
    private static final Logger log = new Logger(SegmentMetadataQueryRunnerFactory.class);
    private final SegmentMetadataQueryQueryToolChest toolChest;
    private final QueryWatcher queryWatcher;

    @Inject
    public SegmentMetadataQueryRunnerFactory(SegmentMetadataQueryQueryToolChest toolChest, QueryWatcher queryWatcher) {
        this.toolChest = toolChest;
        this.queryWatcher = queryWatcher;
    }

    @Override
    public QueryRunner<SegmentAnalysis> createRunner(final Segment segment) {
        return new QueryRunner<SegmentAnalysis>(){

            @Override
            public Sequence<SegmentAnalysis> run(QueryPlus<SegmentAnalysis> inQ, Map<String, Object> responseContext) {
                Granularity queryGranularity;
                TimestampSpec timestampSpec;
                HashMap<String, AggregatorFactory> aggregators;
                SegmentMetadataQuery updatedQuery = ((SegmentMetadataQuery)inQ.getQuery()).withFinalizedAnalysisTypes(SegmentMetadataQueryRunnerFactory.this.toolChest.getConfig());
                SegmentAnalyzer analyzer = new SegmentAnalyzer(updatedQuery.getAnalysisTypes());
                Map<String, ColumnAnalysis> analyzedColumns = analyzer.analyze(segment);
                long numRows = analyzer.numRows(segment);
                long totalSize = 0L;
                if (analyzer.analyzingSize()) {
                    totalSize = (long)analyzedColumns.size() * numRows;
                }
                TreeMap<String, ColumnAnalysis> columns = Maps.newTreeMap();
                ColumnIncluderator includerator = updatedQuery.getToInclude();
                for (Map.Entry<String, ColumnAnalysis> entry : analyzedColumns.entrySet()) {
                    String columnName = entry.getKey();
                    AggregatorFactory[] column = entry.getValue();
                    if (!column.isError()) {
                        totalSize += column.getSize();
                    }
                    if (!includerator.include(columnName)) continue;
                    columns.put(columnName, (ColumnAnalysis)column);
                }
                List<Interval> retIntervals = updatedQuery.analyzingInterval() ? Collections.singletonList(segment.getDataInterval()) : null;
                Metadata metadata = null;
                if (updatedQuery.hasAggregators()) {
                    metadata = segment.asStorageAdapter().getMetadata();
                    if (metadata != null && metadata.getAggregators() != null) {
                        aggregators = Maps.newHashMap();
                        for (AggregatorFactory aggregator : metadata.getAggregators()) {
                            aggregators.put(aggregator.getName(), aggregator);
                        }
                    } else {
                        aggregators = null;
                    }
                } else {
                    aggregators = null;
                }
                if (updatedQuery.hasTimestampSpec()) {
                    if (metadata == null) {
                        metadata = segment.asStorageAdapter().getMetadata();
                    }
                    timestampSpec = metadata != null ? metadata.getTimestampSpec() : null;
                } else {
                    timestampSpec = null;
                }
                if (updatedQuery.hasQueryGranularity()) {
                    if (metadata == null) {
                        metadata = segment.asStorageAdapter().getMetadata();
                    }
                    queryGranularity = metadata != null ? metadata.getQueryGranularity() : null;
                } else {
                    queryGranularity = null;
                }
                Boolean rollup = null;
                if (updatedQuery.hasRollup()) {
                    if (metadata == null) {
                        metadata = segment.asStorageAdapter().getMetadata();
                    }
                    Boolean bl = rollup = metadata != null ? metadata.isRollup() : null;
                    if (rollup == null) {
                        rollup = Boolean.TRUE;
                    }
                }
                return Sequences.simple(Collections.singletonList(new SegmentAnalysis(segment.getIdentifier(), retIntervals, columns, totalSize, numRows, aggregators, timestampSpec, queryGranularity, rollup)));
            }
        };
    }

    @Override
    public QueryRunner<SegmentAnalysis> mergeRunners(ExecutorService exec, Iterable<QueryRunner<SegmentAnalysis>> queryRunners) {
        final ListeningExecutorService queryExecutor = MoreExecutors.listeningDecorator(exec);
        return new ConcatQueryRunner<SegmentAnalysis>(Sequences.map(Sequences.simple(queryRunners), new Function<QueryRunner<SegmentAnalysis>, QueryRunner<SegmentAnalysis>>(){

            @Override
            public QueryRunner<SegmentAnalysis> apply(final QueryRunner<SegmentAnalysis> input) {
                return new QueryRunner<SegmentAnalysis>(){

                    @Override
                    public Sequence<SegmentAnalysis> run(QueryPlus<SegmentAnalysis> queryPlus, final Map<String, Object> responseContext) {
                        Query<SegmentAnalysis> query = queryPlus.getQuery();
                        int priority = QueryContexts.getPriority(query);
                        final QueryPlus<SegmentAnalysis> threadSafeQueryPlus = queryPlus.withoutThreadUnsafeState();
                        Future future = queryExecutor.submit(new AbstractPrioritizedCallable<Sequence<SegmentAnalysis>>(priority){

                            @Override
                            public Sequence<SegmentAnalysis> call() throws Exception {
                                return Sequences.simple(Sequences.toList(input.run(threadSafeQueryPlus, responseContext), new ArrayList()));
                            }
                        });
                        try {
                            SegmentMetadataQueryRunnerFactory.this.queryWatcher.registerQuery(query, (ListenableFuture)future);
                            if (QueryContexts.hasTimeout(query)) {
                                return (Sequence)future.get(QueryContexts.getTimeout(query), TimeUnit.MILLISECONDS);
                            }
                            return (Sequence)future.get();
                        }
                        catch (InterruptedException e) {
                            log.warn(e, "Query interrupted, cancelling pending results, query id [%s]", query.getId());
                            future.cancel(true);
                            throw new QueryInterruptedException(e);
                        }
                        catch (CancellationException e) {
                            throw new QueryInterruptedException(e);
                        }
                        catch (TimeoutException e) {
                            log.info("Query timeout, cancelling pending results for query id [%s]", query.getId());
                            future.cancel(true);
                            throw new QueryInterruptedException(e);
                        }
                        catch (ExecutionException e) {
                            throw Throwables.propagate(e.getCause());
                        }
                    }
                };
            }
        }));
    }

    @Override
    public QueryToolChest<SegmentAnalysis, SegmentMetadataQuery> getToolchest() {
        return this.toolChest;
    }
}

