/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.metadata;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Strings;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.com.google.common.collect.Sets;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.apache.hive.druid.io.druid.java.util.common.granularity.Granularities;
import org.apache.hive.druid.io.druid.java.util.common.guava.Accumulator;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.io.druid.java.util.common.logger.Logger;
import org.apache.hive.druid.io.druid.query.dimension.DefaultDimensionSpec;
import org.apache.hive.druid.io.druid.query.metadata.metadata.ColumnAnalysis;
import org.apache.hive.druid.io.druid.query.metadata.metadata.SegmentMetadataQuery;
import org.apache.hive.druid.io.druid.segment.Cursor;
import org.apache.hive.druid.io.druid.segment.DimensionSelector;
import org.apache.hive.druid.io.druid.segment.QueryableIndex;
import org.apache.hive.druid.io.druid.segment.Segment;
import org.apache.hive.druid.io.druid.segment.StorageAdapter;
import org.apache.hive.druid.io.druid.segment.VirtualColumns;
import org.apache.hive.druid.io.druid.segment.column.BitmapIndex;
import org.apache.hive.druid.io.druid.segment.column.Column;
import org.apache.hive.druid.io.druid.segment.column.ColumnCapabilities;
import org.apache.hive.druid.io.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.hive.druid.io.druid.segment.column.ComplexColumn;
import org.apache.hive.druid.io.druid.segment.column.ValueType;
import org.apache.hive.druid.io.druid.segment.data.IndexedInts;
import org.apache.hive.druid.io.druid.segment.serde.ComplexMetricSerde;
import org.apache.hive.druid.io.druid.segment.serde.ComplexMetrics;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

public class SegmentAnalyzer {
    private static final Logger log = new Logger(SegmentAnalyzer.class);
    private static final int NUM_BYTES_IN_TIMESTAMP = 10;
    private static final int NUM_BYTES_IN_TEXT_FLOAT = 8;
    private final EnumSet<SegmentMetadataQuery.AnalysisType> analysisTypes;

    public SegmentAnalyzer(EnumSet<SegmentMetadataQuery.AnalysisType> analysisTypes) {
        this.analysisTypes = analysisTypes;
    }

    public long numRows(Segment segment) {
        return Preconditions.checkNotNull(segment, "segment").asStorageAdapter().getNumRows();
    }

    public Map<String, ColumnAnalysis> analyze(Segment segment) {
        Preconditions.checkNotNull(segment, "segment");
        QueryableIndex index = segment.asQueryableIndex();
        StorageAdapter storageAdapter = segment.asStorageAdapter();
        int length = storageAdapter.getNumRows();
        HashSet<String> columnNames = Sets.newHashSet();
        Iterables.addAll(columnNames, storageAdapter.getAvailableDimensions());
        Iterables.addAll(columnNames, storageAdapter.getAvailableMetrics());
        TreeMap<String, ColumnAnalysis> columns = Maps.newTreeMap();
        for (String columnName : columnNames) {
            ColumnAnalysis analysis;
            Column column = index == null ? null : index.getColumn(columnName);
            ColumnCapabilities capabilities = column != null ? column.getCapabilities() : storageAdapter.getColumnCapabilities(columnName);
            ValueType type = capabilities.getType();
            switch (type) {
                case LONG: {
                    analysis = this.analyzeNumericColumn(capabilities, length, 8);
                    break;
                }
                case FLOAT: {
                    analysis = this.analyzeNumericColumn(capabilities, length, 8);
                    break;
                }
                case DOUBLE: {
                    analysis = this.analyzeNumericColumn(capabilities, length, 8);
                    break;
                }
                case STRING: {
                    if (index != null) {
                        analysis = this.analyzeStringColumn(capabilities, column);
                        break;
                    }
                    analysis = this.analyzeStringColumn(capabilities, storageAdapter, columnName);
                    break;
                }
                case COMPLEX: {
                    analysis = this.analyzeComplexColumn(capabilities, column, storageAdapter.getColumnTypeName(columnName));
                    break;
                }
                default: {
                    log.warn("Unknown column type[%s].", new Object[]{type});
                    analysis = ColumnAnalysis.error(StringUtils.format("unknown_type_%s", new Object[]{type}));
                }
            }
            columns.put(columnName, analysis);
        }
        ColumnCapabilities timeCapabilities = storageAdapter.getColumnCapabilities("__time");
        if (timeCapabilities == null) {
            timeCapabilities = new ColumnCapabilitiesImpl().setType(ValueType.LONG).setHasMultipleValues(false);
        }
        columns.put("__time", this.analyzeNumericColumn(timeCapabilities, length, 10));
        return columns;
    }

    public boolean analyzingSize() {
        return this.analysisTypes.contains((Object)SegmentMetadataQuery.AnalysisType.SIZE);
    }

    public boolean analyzingCardinality() {
        return this.analysisTypes.contains((Object)SegmentMetadataQuery.AnalysisType.CARDINALITY);
    }

    public boolean analyzingMinMax() {
        return this.analysisTypes.contains((Object)SegmentMetadataQuery.AnalysisType.MINMAX);
    }

    private ColumnAnalysis analyzeNumericColumn(ColumnCapabilities capabilities, int length, int sizePerRow) {
        long size = 0L;
        if (this.analyzingSize()) {
            if (capabilities.hasMultipleValues()) {
                return ColumnAnalysis.error("multi_value");
            }
            size = (long)length * (long)sizePerRow;
        }
        return new ColumnAnalysis(capabilities.getType().name(), capabilities.hasMultipleValues(), size, null, null, null, null);
    }

    private ColumnAnalysis analyzeStringColumn(ColumnCapabilities capabilities, Column column) {
        long size = 0L;
        String min = null;
        String max = null;
        if (!capabilities.hasBitmapIndexes()) {
            return ColumnAnalysis.error("string_no_bitmap");
        }
        BitmapIndex bitmapIndex = column.getBitmapIndex();
        int cardinality = bitmapIndex.getCardinality();
        if (this.analyzingSize()) {
            for (int i = 0; i < cardinality; ++i) {
                String value = bitmapIndex.getValue(i);
                if (value == null) continue;
                size += (long)(StringUtils.estimatedBinaryLengthAsUTF8(value) * bitmapIndex.getBitmap(bitmapIndex.getIndex(value)).size());
            }
        }
        if (this.analyzingMinMax() && cardinality > 0) {
            min = Strings.nullToEmpty(bitmapIndex.getValue(0));
            max = Strings.nullToEmpty(bitmapIndex.getValue(cardinality - 1));
        }
        return new ColumnAnalysis(capabilities.getType().name(), capabilities.hasMultipleValues(), size, this.analyzingCardinality() ? cardinality : 0, (Comparable)((Object)min), (Comparable)((Object)max), null);
    }

    private ColumnAnalysis analyzeStringColumn(ColumnCapabilities capabilities, StorageAdapter storageAdapter, final String columnName) {
        int cardinality = 0;
        long size = 0L;
        Comparable min = null;
        Comparable max = null;
        if (this.analyzingCardinality()) {
            cardinality = storageAdapter.getDimensionCardinality(columnName);
        }
        if (this.analyzingSize()) {
            DateTime start = storageAdapter.getMinTime();
            DateTime end = storageAdapter.getMaxTime();
            Sequence<Cursor> cursors = storageAdapter.makeCursors(null, new Interval((ReadableInstant)start, (ReadableInstant)end), VirtualColumns.EMPTY, Granularities.ALL, false, null);
            size = cursors.accumulate(0L, new Accumulator<Long, Cursor>(){

                @Override
                public Long accumulate(Long accumulated, Cursor cursor) {
                    DimensionSelector selector = cursor.getColumnSelectorFactory().makeDimensionSelector(new DefaultDimensionSpec(columnName, columnName));
                    if (selector == null) {
                        return accumulated;
                    }
                    long current = accumulated;
                    while (!cursor.isDone()) {
                        IndexedInts vals = selector.getRow();
                        for (int i = 0; i < vals.size(); ++i) {
                            String dimVal = selector.lookupName(vals.get(i));
                            if (dimVal == null || dimVal.isEmpty()) continue;
                            current += (long)StringUtils.estimatedBinaryLengthAsUTF8(dimVal);
                        }
                        cursor.advance();
                    }
                    return current;
                }
            });
        }
        if (this.analyzingMinMax()) {
            min = storageAdapter.getMinValue(columnName);
            max = storageAdapter.getMaxValue(columnName);
        }
        return new ColumnAnalysis(capabilities.getType().name(), capabilities.hasMultipleValues(), size, cardinality, min, max, null);
    }

    private ColumnAnalysis analyzeComplexColumn(@Nullable ColumnCapabilities capabilities, @Nullable Column column, String typeName) {
        try (ComplexColumn complexColumn = column != null ? column.getComplexColumn() : null;){
            boolean hasMultipleValues = capabilities != null && capabilities.hasMultipleValues();
            long size = 0L;
            if (this.analyzingSize() && complexColumn != null) {
                ComplexMetricSerde serde = ComplexMetrics.getSerdeForType(typeName);
                if (serde == null) {
                    ColumnAnalysis columnAnalysis = ColumnAnalysis.error(StringUtils.format("unknown_complex_%s", typeName));
                    return columnAnalysis;
                }
                Function<Object, Long> inputSizeFn = serde.inputSizeFn();
                if (inputSizeFn == null) {
                    ColumnAnalysis columnAnalysis = new ColumnAnalysis(typeName, hasMultipleValues, 0L, null, null, null, null);
                    return columnAnalysis;
                }
                int length = column.getLength();
                for (int i = 0; i < length; ++i) {
                    size += inputSizeFn.apply(complexColumn.getRowValue(i)).longValue();
                }
            }
            ColumnAnalysis columnAnalysis = new ColumnAnalysis(typeName, hasMultipleValues, size, null, null, null, null);
            return columnAnalysis;
        }
    }
}

