/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.lookup;

import java.util.Objects;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.io.druid.java.util.common.guava.Comparators;
import org.apache.hive.druid.io.druid.query.lookup.LookupExtractorFactory;

public class LookupExtractorFactoryContainer {
    private final String version;
    private final LookupExtractorFactory lookupExtractorFactory;

    @JsonCreator
    public LookupExtractorFactoryContainer(@JsonProperty(value="version") String version, @JsonProperty(value="lookupExtractorFactory") LookupExtractorFactory lookupExtractorFactory) {
        this.version = version;
        this.lookupExtractorFactory = Preconditions.checkNotNull(lookupExtractorFactory, "null factory");
    }

    @JsonProperty
    public String getVersion() {
        return this.version;
    }

    @JsonProperty
    public LookupExtractorFactory getLookupExtractorFactory() {
        return this.lookupExtractorFactory;
    }

    public boolean replaces(LookupExtractorFactoryContainer other) {
        if (this.version == null && other.getVersion() == null) {
            return this.lookupExtractorFactory.replaces(other.getLookupExtractorFactory());
        }
        return Comparators.naturalNullsFirst().compare(this.version, other.getVersion()) > 0;
    }

    public String toString() {
        return "LookupExtractorFactoryContainer{version='" + this.version + '\'' + ", lookupExtractorFactory=" + this.lookupExtractorFactory + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LookupExtractorFactoryContainer that = (LookupExtractorFactoryContainer)o;
        return Objects.equals(this.version, that.version) && Objects.equals(this.lookupExtractorFactory, that.lookupExtractorFactory);
    }

    public int hashCode() {
        return Objects.hash(this.version, this.lookupExtractorFactory);
    }
}

