/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.groupby.epinephelinae;

import java.nio.ByteBuffer;
import java.util.Comparator;
import org.apache.hive.druid.com.google.common.annotations.VisibleForTesting;
import org.apache.hive.druid.com.google.common.collect.Ordering;
import org.apache.hive.druid.io.druid.java.util.common.ISE;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.LimitedBufferHashGrouper;

public class ByteBufferMinMaxOffsetHeap {
    private static final int EVEN_POWERS_OF_TWO = 0x55555555;
    private static final int ODD_POWERS_OF_TWO = -1431655766;
    private final Comparator minComparator;
    private final Comparator maxComparator;
    private final ByteBuffer buf;
    private final int limit;
    private final LimitedBufferHashGrouper.BufferGrouperOffsetHeapIndexUpdater heapIndexUpdater;
    private int heapSize;

    public ByteBufferMinMaxOffsetHeap(ByteBuffer buf, int limit, Comparator<Integer> minComparator, LimitedBufferHashGrouper.BufferGrouperOffsetHeapIndexUpdater heapIndexUpdater) {
        this.buf = buf;
        this.limit = limit;
        this.heapSize = 0;
        this.minComparator = minComparator;
        this.maxComparator = Ordering.from(minComparator).reverse();
        this.heapIndexUpdater = heapIndexUpdater;
    }

    public void reset() {
        this.heapSize = 0;
    }

    public int addOffset(int offset) {
        int pos = this.heapSize++;
        this.buf.putInt(pos * 4, offset);
        if (this.heapIndexUpdater != null) {
            this.heapIndexUpdater.updateHeapIndexForOffset(offset, pos);
        }
        this.bubbleUp(pos);
        if (this.heapSize > this.limit) {
            return this.removeMax();
        }
        return -1;
    }

    public int removeMin() {
        if (this.heapSize < 1) {
            throw new ISE("Empty heap", new Object[0]);
        }
        int minOffset = this.buf.getInt(0);
        if (this.heapIndexUpdater != null) {
            this.heapIndexUpdater.updateHeapIndexForOffset(minOffset, -1);
        }
        if (this.heapSize == 1) {
            --this.heapSize;
            return minOffset;
        }
        int lastIndex = this.heapSize - 1;
        int lastOffset = this.buf.getInt(lastIndex * 4);
        --this.heapSize;
        this.buf.putInt(0, lastOffset);
        if (this.heapIndexUpdater != null) {
            this.heapIndexUpdater.updateHeapIndexForOffset(lastOffset, 0);
        }
        Comparator comparator = this.isEvenLevel(0) ? this.minComparator : this.maxComparator;
        this.siftDown(comparator, 0);
        return minOffset;
    }

    public int removeMax() {
        if (this.heapSize < 1) {
            throw new ISE("Empty heap", new Object[0]);
        }
        if (this.heapSize == 1) {
            --this.heapSize;
            int maxOffset = this.buf.getInt(0);
            if (this.heapIndexUpdater != null) {
                this.heapIndexUpdater.updateHeapIndexForOffset(maxOffset, -1);
            }
            return maxOffset;
        }
        if (this.heapSize == 2) {
            --this.heapSize;
            int maxOffset = this.buf.getInt(4);
            if (this.heapIndexUpdater != null) {
                this.heapIndexUpdater.updateHeapIndexForOffset(maxOffset, -1);
            }
            return maxOffset;
        }
        int maxIndex = this.findMaxElementIndex();
        int maxOffset = this.buf.getInt(maxIndex * 4);
        int lastIndex = this.heapSize - 1;
        int lastOffset = this.buf.getInt(lastIndex * 4);
        --this.heapSize;
        this.buf.putInt(maxIndex * 4, lastOffset);
        if (this.heapIndexUpdater != null) {
            this.heapIndexUpdater.updateHeapIndexForOffset(maxOffset, -1);
            this.heapIndexUpdater.updateHeapIndexForOffset(lastOffset, maxIndex);
        }
        Comparator comparator = this.isEvenLevel(maxIndex) ? this.minComparator : this.maxComparator;
        this.siftDown(comparator, maxIndex);
        return maxOffset;
    }

    public int removeAt(int deletedIndex) {
        if (this.heapSize < 1) {
            throw new ISE("Empty heap", new Object[0]);
        }
        int deletedOffset = this.buf.getInt(deletedIndex * 4);
        if (this.heapIndexUpdater != null) {
            this.heapIndexUpdater.updateHeapIndexForOffset(deletedOffset, -1);
        }
        int lastIndex = this.heapSize - 1;
        --this.heapSize;
        if (lastIndex == deletedIndex) {
            return deletedOffset;
        }
        int lastOffset = this.buf.getInt(lastIndex * 4);
        this.buf.putInt(deletedIndex * 4, lastOffset);
        if (this.heapIndexUpdater != null) {
            this.heapIndexUpdater.updateHeapIndexForOffset(lastOffset, deletedIndex);
        }
        Comparator comparator = this.isEvenLevel(deletedIndex) ? this.minComparator : this.maxComparator;
        this.bubbleUp(deletedIndex);
        this.siftDown(comparator, deletedIndex);
        return deletedOffset;
    }

    public void setAt(int index, int newVal) {
        this.buf.putInt(index * 4, newVal);
    }

    public int getAt(int index) {
        return this.buf.getInt(index * 4);
    }

    public int indexOf(int offset) {
        for (int i = 0; i < this.heapSize; ++i) {
            int curOffset = this.buf.getInt(i * 4);
            if (curOffset != offset) continue;
            return i;
        }
        return -1;
    }

    public void removeOffset(int offset) {
        int index = this.indexOf(offset);
        if (index > -1) {
            this.removeAt(index);
        }
    }

    public int getHeapSize() {
        return this.heapSize;
    }

    private void bubbleUp(int pos) {
        if (this.isEvenLevel(pos)) {
            int parentIndex = this.getParentIndex(pos);
            if (parentIndex > -1) {
                int parentOffset = this.buf.getInt(parentIndex * 4);
                int offset = this.buf.getInt(pos * 4);
                if (this.minComparator.compare(offset, parentOffset) > 0) {
                    this.buf.putInt(parentIndex * 4, offset);
                    this.buf.putInt(pos * 4, parentOffset);
                    if (this.heapIndexUpdater != null) {
                        this.heapIndexUpdater.updateHeapIndexForOffset(offset, parentIndex);
                        this.heapIndexUpdater.updateHeapIndexForOffset(parentOffset, pos);
                    }
                    this.bubbleUpDirectional(this.maxComparator, parentIndex);
                } else {
                    this.bubbleUpDirectional(this.minComparator, pos);
                }
            } else {
                this.bubbleUpDirectional(this.minComparator, pos);
            }
        } else {
            int parentIndex = this.getParentIndex(pos);
            if (parentIndex > -1) {
                int parentOffset = this.buf.getInt(parentIndex * 4);
                int offset = this.buf.getInt(pos * 4);
                if (this.minComparator.compare(offset, parentOffset) < 0) {
                    this.buf.putInt(parentIndex * 4, offset);
                    this.buf.putInt(pos * 4, parentOffset);
                    if (this.heapIndexUpdater != null) {
                        this.heapIndexUpdater.updateHeapIndexForOffset(offset, parentIndex);
                        this.heapIndexUpdater.updateHeapIndexForOffset(parentOffset, pos);
                    }
                    this.bubbleUpDirectional(this.minComparator, parentIndex);
                } else {
                    this.bubbleUpDirectional(this.maxComparator, pos);
                }
            } else {
                this.bubbleUpDirectional(this.maxComparator, pos);
            }
        }
    }

    private void bubbleUpDirectional(Comparator comparator, int pos) {
        int grandparent = this.getGrandparentIndex(pos);
        while (grandparent > -1) {
            int offset = this.buf.getInt(pos * 4);
            int gpOffset = this.buf.getInt(grandparent * 4);
            if (comparator.compare(offset, gpOffset) < 0) {
                this.buf.putInt(pos * 4, gpOffset);
                this.buf.putInt(grandparent * 4, offset);
                if (this.heapIndexUpdater != null) {
                    this.heapIndexUpdater.updateHeapIndexForOffset(gpOffset, pos);
                    this.heapIndexUpdater.updateHeapIndexForOffset(offset, grandparent);
                }
            }
            pos = grandparent;
            grandparent = this.getGrandparentIndex(pos);
        }
    }

    private void siftDown(Comparator comparator, int pos) {
        int minChild = this.findMinChild(comparator, pos);
        while (minChild > -1) {
            int minOffset;
            int offset;
            int minIndex;
            int minGrandchild = this.findMinGrandChild(comparator, pos);
            if (minGrandchild > -1) {
                int minChildOffset = this.buf.getInt(minChild * 4);
                int minGcOffset = this.buf.getInt(minGrandchild * 4);
                int cmp = comparator.compare(minChildOffset, minGcOffset);
                minIndex = cmp > 0 ? minGrandchild : minChild;
            } else {
                if (minChild <= -1) break;
                minIndex = minChild;
            }
            if (minIndex == minGrandchild) {
                offset = this.buf.getInt(pos * 4);
                minOffset = this.buf.getInt(minIndex * 4);
                if (comparator.compare(minOffset, offset) < 0) {
                    this.buf.putInt(pos * 4, minOffset);
                    this.buf.putInt(minIndex * 4, offset);
                    if (this.heapIndexUpdater != null) {
                        this.heapIndexUpdater.updateHeapIndexForOffset(minOffset, pos);
                        this.heapIndexUpdater.updateHeapIndexForOffset(offset, minIndex);
                    }
                    int parent = this.getParentIndex(minIndex);
                    int parentOffset = this.buf.getInt(parent * 4);
                    if (comparator.compare(offset, parentOffset) > 0) {
                        this.buf.putInt(minIndex * 4, parentOffset);
                        this.buf.putInt(parent * 4, offset);
                        if (this.heapIndexUpdater != null) {
                            this.heapIndexUpdater.updateHeapIndexForOffset(offset, parent);
                            this.heapIndexUpdater.updateHeapIndexForOffset(parentOffset, minIndex);
                        }
                    }
                    minChild = this.findMinChild(comparator, minIndex);
                }
                pos = minIndex;
                continue;
            }
            offset = this.buf.getInt(pos * 4);
            minOffset = this.buf.getInt(minIndex * 4);
            if (comparator.compare(minOffset, offset) >= 0) break;
            this.buf.putInt(pos * 4, minOffset);
            this.buf.putInt(minIndex * 4, offset);
            if (this.heapIndexUpdater == null) break;
            this.heapIndexUpdater.updateHeapIndexForOffset(offset, minIndex);
            this.heapIndexUpdater.updateHeapIndexForOffset(minOffset, pos);
            break;
        }
    }

    private boolean isEvenLevel(int index) {
        int oneBased = index + 1;
        return (oneBased & 0x55555555) > (oneBased & 0xAAAAAAAA);
    }

    private int findMin(Comparator comparator, int index, int len) {
        if (index >= this.heapSize) {
            return -1;
        }
        int limit = Math.min(index, this.heapSize - len) + len;
        int minIndex = index;
        for (int i = index + 1; i < limit; ++i) {
            if (comparator.compare(this.buf.getInt(i * 4), this.buf.getInt(minIndex * 4)) >= 0) continue;
            minIndex = i;
        }
        return minIndex;
    }

    private int findMinChild(Comparator comparator, int index) {
        return this.findMin(comparator, this.getLeftChildIndex(index), 2);
    }

    private int findMinGrandChild(Comparator comparator, int index) {
        int leftChildIndex = this.getLeftChildIndex(index);
        if (leftChildIndex < 0) {
            return -1;
        }
        return this.findMin(comparator, this.getLeftChildIndex(leftChildIndex), 4);
    }

    private int getLeftChildIndex(int i) {
        return i * 2 + 1;
    }

    private int getRightChildIndex(int i) {
        return i * 2 + 2;
    }

    private int getParentIndex(int i) {
        if (i == 0) {
            return -1;
        }
        return (i - 1) / 2;
    }

    private int getGrandparentIndex(int i) {
        if (i < 3) {
            return -1;
        }
        return (i - 3) / 4;
    }

    private int findMaxElementIndex() {
        switch (this.heapSize) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
        }
        int offset1 = this.buf.getInt(4);
        int offset2 = this.buf.getInt(8);
        return this.maxComparator.compare(offset1, offset2) <= 0 ? 1 : 2;
    }

    @VisibleForTesting
    boolean isIntact() {
        for (int i = 0; i < this.heapSize; ++i) {
            if (this.verifyIndex(i)) continue;
            return false;
        }
        return true;
    }

    private boolean verifyIndex(int i) {
        int gpIdx;
        int gpOffset;
        int rcIdx;
        Comparator comparator = this.isEvenLevel(i) ? this.minComparator : this.maxComparator;
        int offset = this.buf.getInt(i * 4);
        int lcIdx = this.getLeftChildIndex(i);
        if (lcIdx < this.heapSize) {
            int leftChildOffset = this.buf.getInt(lcIdx * 4);
            if (comparator.compare(offset, leftChildOffset) > 0) {
                throw new ISE("Left child val[%d] at idx[%d] is less than val[%d] at idx[%d]", leftChildOffset, lcIdx, offset, i);
            }
        }
        if ((rcIdx = this.getRightChildIndex(i)) < this.heapSize) {
            int rightChildOffset = this.buf.getInt(rcIdx * 4);
            if (comparator.compare(offset, rightChildOffset) > 0) {
                throw new ISE("Right child val[%d] at idx[%d] is less than val[%d] at idx[%d]", rightChildOffset, rcIdx, offset, i);
            }
        }
        if (i > 0) {
            int parentIdx = this.getParentIndex(i);
            int parentOffset = this.buf.getInt(parentIdx * 4);
            if (comparator.compare(offset, parentOffset) > 0) {
                throw new ISE("Parent val[%d] at idx[%d] is less than val[%d] at idx[%d]", parentOffset, parentIdx, offset, i);
            }
        }
        if (i > 2 && comparator.compare(gpOffset = this.buf.getInt((gpIdx = this.getGrandparentIndex(i)) * 4), offset) > 0) {
            throw new ISE("Grandparent val[%d] at idx[%d] is less than val[%d] at idx[%d]", gpOffset, gpIdx, offset, i);
        }
        return true;
    }

    public String toString() {
        if (this.heapSize == 0) {
            return "[]";
        }
        String ret = "[";
        for (int i = 0; i < this.heapSize; ++i) {
            ret = ret + this.buf.getInt(i * 4);
            if (i >= this.heapSize - 1) continue;
            ret = ret + ", ";
        }
        ret = ret + "]";
        return ret;
    }
}

