/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.groupby;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.io.druid.collections.NonBlockingPool;
import org.apache.hive.druid.io.druid.common.guava.GuavaUtils;
import org.apache.hive.druid.io.druid.data.input.MapBasedInputRow;
import org.apache.hive.druid.io.druid.data.input.MapBasedRow;
import org.apache.hive.druid.io.druid.data.input.Row;
import org.apache.hive.druid.io.druid.data.input.impl.DimensionSchema;
import org.apache.hive.druid.io.druid.data.input.impl.DimensionsSpec;
import org.apache.hive.druid.io.druid.data.input.impl.StringDimensionSchema;
import org.apache.hive.druid.io.druid.java.util.common.ISE;
import org.apache.hive.druid.io.druid.java.util.common.Pair;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.apache.hive.druid.io.druid.java.util.common.granularity.Granularities;
import org.apache.hive.druid.io.druid.java.util.common.granularity.Granularity;
import org.apache.hive.druid.io.druid.java.util.common.guava.Accumulator;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequences;
import org.apache.hive.druid.io.druid.query.ResourceLimitExceededException;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.query.dimension.DimensionSpec;
import org.apache.hive.druid.io.druid.query.groupby.GroupByQuery;
import org.apache.hive.druid.io.druid.query.groupby.GroupByQueryConfig;
import org.apache.hive.druid.io.druid.segment.column.ValueType;
import org.apache.hive.druid.io.druid.segment.incremental.IncrementalIndex;
import org.apache.hive.druid.io.druid.segment.incremental.IncrementalIndexSchema;
import org.apache.hive.druid.io.druid.segment.incremental.IndexSizeExceededException;
import org.joda.time.DateTime;

public class GroupByQueryHelper {
    public static final String CTX_KEY_SORT_RESULTS = "sortResults";

    public static <T> Pair<IncrementalIndex, Accumulator<IncrementalIndex, T>> createIndexAccumulatorPair(GroupByQuery query, GroupByQueryConfig config, NonBlockingPool<ByteBuffer> bufferPool, boolean combine) {
        DateTime timeStart;
        GroupByQueryConfig querySpecificConfig = config.withOverrides(query);
        Granularity gran = query.getGranularity();
        DateTime granTimeStart = timeStart = query.getIntervals().get(0).getStart();
        if (!Granularities.ALL.equals(gran)) {
            granTimeStart = gran.bucketStart(timeStart);
        }
        List<AggregatorFactory> aggs = combine ? Lists.transform(query.getAggregatorSpecs(), new Function<AggregatorFactory, AggregatorFactory>(){

            @Override
            public AggregatorFactory apply(AggregatorFactory input) {
                return input.getCombiningFactory();
            }
        }) : query.getAggregatorSpecs();
        final List<String> dimensions = Lists.transform(query.getDimensions(), new Function<DimensionSpec, String>(){

            @Override
            public String apply(DimensionSpec input) {
                return input.getOutputName();
            }
        });
        boolean sortResults = query.getContextValue(CTX_KEY_SORT_RESULTS, true);
        ArrayList<DimensionSchema> dimensionSchemas = Lists.newArrayList();
        for (DimensionSpec dimension : query.getDimensions()) {
            dimensionSchemas.add(new StringDimensionSchema(dimension.getOutputName()));
        }
        IncrementalIndexSchema indexSchema = new IncrementalIndexSchema.Builder().withDimensionsSpec(new DimensionsSpec(dimensionSchemas, null, null)).withMetrics(aggs.toArray(new AggregatorFactory[aggs.size()])).withQueryGranularity(gran).withMinTimestamp(granTimeStart.getMillis()).build();
        IncrementalIndex index = query.getContextValue("useOffheap", false) != false ? new IncrementalIndex.Builder().setIndexSchema(indexSchema).setDeserializeComplexMetrics(false).setConcurrentEventAdd(true).setSortFacts(sortResults).setMaxRowCount(querySpecificConfig.getMaxResults()).buildOffheap(bufferPool) : new IncrementalIndex.Builder().setIndexSchema(indexSchema).setDeserializeComplexMetrics(false).setConcurrentEventAdd(true).setSortFacts(sortResults).setMaxRowCount(querySpecificConfig.getMaxResults()).buildOnheap();
        Accumulator accumulator = new Accumulator<IncrementalIndex, T>(){

            @Override
            public IncrementalIndex accumulate(IncrementalIndex accumulated, T in) {
                if (in instanceof MapBasedRow) {
                    try {
                        MapBasedRow row = (MapBasedRow)in;
                        accumulated.add(new MapBasedInputRow(row.getTimestamp(), (List<String>)dimensions, row.getEvent()));
                    }
                    catch (IndexSizeExceededException e) {
                        throw new ResourceLimitExceededException(e.getMessage(), new Object[0]);
                    }
                } else {
                    throw new ISE("Unable to accumulate something of type [%s]", in.getClass());
                }
                return accumulated;
            }
        };
        return new Pair<IncrementalIndex, Accumulator<IncrementalIndex, T>>(index, accumulator);
    }

    public static <T> Pair<Queue, Accumulator<Queue, T>> createBySegmentAccumulatorPair() {
        ConcurrentLinkedQueue init = new ConcurrentLinkedQueue();
        Accumulator accumulator = new Accumulator<Queue, T>(){

            @Override
            public Queue accumulate(Queue accumulated, T in) {
                if (in == null) {
                    throw new ISE("Cannot have null result", new Object[0]);
                }
                accumulated.offer(in);
                return accumulated;
            }
        };
        return new Pair<Queue, Accumulator<Queue, T>>(init, accumulator);
    }

    public static IncrementalIndex makeIncrementalIndex(GroupByQuery query, GroupByQueryConfig config, NonBlockingPool<ByteBuffer> bufferPool, Sequence<Row> rows, boolean combine) {
        Pair indexAccumulatorPair = GroupByQueryHelper.createIndexAccumulatorPair(query, config, bufferPool, combine);
        return (IncrementalIndex)rows.accumulate(indexAccumulatorPair.lhs, (Accumulator)indexAccumulatorPair.rhs);
    }

    public static Sequence<Row> postAggregate(final GroupByQuery query, IncrementalIndex index) {
        return Sequences.map(Sequences.simple(index.iterableWithPostAggregations(query.getPostAggregatorSpecs(), query.isDescending())), new Function<Row, Row>(){

            @Override
            public Row apply(Row input) {
                MapBasedRow row = (MapBasedRow)input;
                return new MapBasedRow(query.getGranularity().toDateTime(row.getTimestampFromEpoch()), row.getEvent());
            }
        });
    }

    public static Map<String, ValueType> rowSignatureFor(GroupByQuery query) {
        ImmutableMap.Builder<String, ValueType> types = ImmutableMap.builder();
        for (DimensionSpec dimensionSpec : query.getDimensions()) {
            types.put(dimensionSpec.getOutputName(), dimensionSpec.getOutputType());
        }
        for (AggregatorFactory aggregatorFactory : query.getAggregatorSpecs()) {
            String typeName = aggregatorFactory.getTypeName();
            ValueType valueType = typeName != null ? GuavaUtils.getEnumIfPresent(ValueType.class, StringUtils.toUpperCase(typeName)) : null;
            if (valueType == null) continue;
            types.put(aggregatorFactory.getName(), valueType);
        }
        return types.build();
    }
}

