/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.expression;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.hive.druid.com.google.common.base.Strings;
import org.apache.hive.druid.io.druid.java.util.common.IAE;
import org.apache.hive.druid.io.druid.math.expr.Expr;
import org.apache.hive.druid.io.druid.math.expr.ExprEval;
import org.apache.hive.druid.io.druid.math.expr.ExprMacroTable;

public class RegexpExtractExprMacro
implements ExprMacroTable.ExprMacro {
    @Override
    public String name() {
        return "regexp_extract";
    }

    @Override
    public Expr apply(List<Expr> args) {
        Expr indexExpr;
        if (args.size() < 2 || args.size() > 3) {
            throw new IAE("Function[%s] must have 2 to 3 arguments", this.name());
        }
        final Expr arg = args.get(0);
        Expr patternExpr = args.get(1);
        Expr expr = indexExpr = args.size() > 2 ? args.get(2) : null;
        if (!patternExpr.isLiteral() || indexExpr != null && !indexExpr.isLiteral()) {
            throw new IAE("Function[%s] pattern and index must be literals", this.name());
        }
        final Pattern pattern = Pattern.compile(String.valueOf(patternExpr.getLiteralValue()));
        final int index = indexExpr == null ? 0 : ((Number)indexExpr.getLiteralValue()).intValue();
        class RegexpExtractExpr
        implements Expr {
            RegexpExtractExpr() {
            }

            @Override
            @Nonnull
            public ExprEval eval(Expr.ObjectBinding bindings) {
                Matcher matcher = pattern.matcher(Strings.nullToEmpty(arg.eval(bindings).asString()));
                String retVal = matcher.find() ? matcher.group(index) : null;
                return ExprEval.of(Strings.emptyToNull(retVal));
            }

            @Override
            public void visit(Expr.Visitor visitor) {
                arg.visit(visitor);
                visitor.visit(this);
            }
        }
        return new RegexpExtractExpr();
    }
}

