/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.expression;

import java.util.List;
import javax.annotation.Nonnull;
import org.apache.hive.druid.com.google.common.base.Strings;
import org.apache.hive.druid.io.druid.java.util.common.IAE;
import org.apache.hive.druid.io.druid.math.expr.Expr;
import org.apache.hive.druid.io.druid.math.expr.ExprEval;
import org.apache.hive.druid.io.druid.math.expr.ExprMacroTable;
import org.apache.hive.druid.io.druid.math.expr.ExprType;
import org.apache.hive.druid.io.druid.query.filter.LikeDimFilter;

public class LikeExprMacro
implements ExprMacroTable.ExprMacro {
    @Override
    public String name() {
        return "like";
    }

    @Override
    public Expr apply(List<Expr> args) {
        String escape;
        Expr escapeExpr;
        if (args.size() < 2 || args.size() > 3) {
            throw new IAE("Function[%s] must have 2 or 3 arguments", this.name());
        }
        final Expr arg = args.get(0);
        Expr patternExpr = args.get(1);
        Expr expr = escapeExpr = args.size() > 2 ? args.get(2) : null;
        if (!patternExpr.isLiteral() || escapeExpr != null && !escapeExpr.isLiteral()) {
            throw new IAE("pattern and escape must be literals", new Object[0]);
        }
        String string = escape = escapeExpr == null ? null : (String)escapeExpr.getLiteralValue();
        if (escape != null && escape.length() != 1) {
            throw new IllegalArgumentException("Escape must be null or a single character");
        }
        Character escapeChar = escape == null ? null : Character.valueOf(escape.charAt(0));
        final LikeDimFilter.LikeMatcher likeMatcher = LikeDimFilter.LikeMatcher.from(Strings.nullToEmpty((String)patternExpr.getLiteralValue()), escapeChar);
        class LikeExtractExpr
        implements Expr {
            LikeExtractExpr() {
            }

            @Override
            @Nonnull
            public ExprEval eval(Expr.ObjectBinding bindings) {
                return ExprEval.of(likeMatcher.matches(arg.eval(bindings).asString()), ExprType.LONG);
            }

            @Override
            public void visit(Expr.Visitor visitor) {
                arg.visit(visitor);
                visitor.visit(this);
            }
        }
        return new LikeExtractExpr();
    }
}

