/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.aggregation.first;

import java.nio.ByteBuffer;
import org.apache.hive.druid.io.druid.collections.SerializablePair;
import org.apache.hive.druid.io.druid.query.aggregation.BufferAggregator;
import org.apache.hive.druid.io.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.hive.druid.io.druid.segment.BaseDoubleColumnValueSelector;
import org.apache.hive.druid.io.druid.segment.BaseLongColumnValueSelector;

public class DoubleFirstBufferAggregator
implements BufferAggregator {
    private final BaseLongColumnValueSelector timeSelector;
    private final BaseDoubleColumnValueSelector valueSelector;

    public DoubleFirstBufferAggregator(BaseLongColumnValueSelector timeSelector, BaseDoubleColumnValueSelector valueSelector) {
        this.timeSelector = timeSelector;
        this.valueSelector = valueSelector;
    }

    @Override
    public void init(ByteBuffer buf, int position) {
        buf.putLong(position, Long.MAX_VALUE);
        buf.putDouble(position + 8, 0.0);
    }

    @Override
    public void aggregate(ByteBuffer buf, int position) {
        long firstTime;
        long time = this.timeSelector.getLong();
        if (time < (firstTime = buf.getLong(position))) {
            buf.putLong(position, time);
            buf.putDouble(position + 8, this.valueSelector.getDouble());
        }
    }

    @Override
    public Object get(ByteBuffer buf, int position) {
        return new SerializablePair<Long, Double>(buf.getLong(position), buf.getDouble(position + 8));
    }

    @Override
    public float getFloat(ByteBuffer buf, int position) {
        return (float)buf.getDouble(position + 8);
    }

    @Override
    public long getLong(ByteBuffer buf, int position) {
        return (long)buf.getDouble(position + 8);
    }

    @Override
    public double getDouble(ByteBuffer buf, int position) {
        return buf.getDouble(position + 8);
    }

    @Override
    public void close() {
    }

    @Override
    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        inspector.visit("timeSelector", this.timeSelector);
        inspector.visit("valueSelector", this.valueSelector);
    }
}

