/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.aggregation;

import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JacksonInject;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.annotations.VisibleForTesting;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Joiner;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.apache.hive.druid.io.druid.js.JavaScriptConfig;
import org.apache.hive.druid.io.druid.query.aggregation.AggregateCombiner;
import org.apache.hive.druid.io.druid.query.aggregation.Aggregator;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactoryNotMergeableException;
import org.apache.hive.druid.io.druid.query.aggregation.BufferAggregator;
import org.apache.hive.druid.io.druid.query.aggregation.DoubleAggregateCombiner;
import org.apache.hive.druid.io.druid.query.aggregation.DoubleSumAggregator;
import org.apache.hive.druid.io.druid.query.aggregation.JavaScriptAggregator;
import org.apache.hive.druid.io.druid.query.aggregation.JavaScriptBufferAggregator;
import org.apache.hive.druid.io.druid.segment.BaseObjectColumnValueSelector;
import org.apache.hive.druid.io.druid.segment.ColumnSelectorFactory;
import org.apache.hive.druid.io.druid.segment.ColumnValueSelector;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextAction;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class JavaScriptAggregatorFactory
extends AggregatorFactory {
    private final String name;
    private final List<String> fieldNames;
    private final String fnAggregate;
    private final String fnReset;
    private final String fnCombine;
    private final JavaScriptConfig config;
    private JavaScriptAggregator.ScriptAggregator compiledScript;

    @JsonCreator
    public JavaScriptAggregatorFactory(@JsonProperty(value="name") String name, @JsonProperty(value="fieldNames") List<String> fieldNames, @JsonProperty(value="fnAggregate") String fnAggregate, @JsonProperty(value="fnReset") String fnReset, @JsonProperty(value="fnCombine") String fnCombine, @JacksonInject JavaScriptConfig config) {
        Preconditions.checkNotNull(name, "Must have a valid, non-null aggregator name");
        Preconditions.checkNotNull(fieldNames, "Must have a valid, non-null fieldNames");
        Preconditions.checkNotNull(fnAggregate, "Must have a valid, non-null fnAggregate");
        Preconditions.checkNotNull(fnReset, "Must have a valid, non-null fnReset");
        Preconditions.checkNotNull(fnCombine, "Must have a valid, non-null fnCombine");
        this.name = name;
        this.fieldNames = fieldNames;
        this.fnAggregate = fnAggregate;
        this.fnReset = fnReset;
        this.fnCombine = fnCombine;
        this.config = config;
    }

    @Override
    public Aggregator factorize(ColumnSelectorFactory columnFactory) {
        this.checkAndCompileScript();
        return new JavaScriptAggregator(this.fieldNames.stream().map(columnFactory::makeColumnValueSelector).collect(Collectors.toList()), this.compiledScript);
    }

    @Override
    public BufferAggregator factorizeBuffered(ColumnSelectorFactory columnSelectorFactory) {
        this.checkAndCompileScript();
        return new JavaScriptBufferAggregator(this.fieldNames.stream().map(columnSelectorFactory::makeColumnValueSelector).collect(Collectors.toList()), this.compiledScript);
    }

    @Override
    public Comparator getComparator() {
        return DoubleSumAggregator.COMPARATOR;
    }

    @Override
    public Object combine(Object lhs, Object rhs) {
        this.checkAndCompileScript();
        return this.compiledScript.combine(((Number)lhs).doubleValue(), ((Number)rhs).doubleValue());
    }

    @Override
    public AggregateCombiner makeAggregateCombiner() {
        return new DoubleAggregateCombiner(){
            private double combined;

            @Override
            public void reset(ColumnValueSelector selector) {
                this.combined = selector.getDouble();
            }

            @Override
            public void fold(ColumnValueSelector selector) {
                JavaScriptAggregatorFactory.this.checkAndCompileScript();
                this.combined = JavaScriptAggregatorFactory.this.compiledScript.combine(this.combined, selector.getDouble());
            }

            @Override
            public double getDouble() {
                return this.combined;
            }
        };
    }

    @Override
    public AggregatorFactory getCombiningFactory() {
        return new JavaScriptAggregatorFactory(this.name, Lists.newArrayList(this.name), this.fnCombine, this.fnReset, this.fnCombine, this.config);
    }

    @Override
    public AggregatorFactory getMergingFactory(AggregatorFactory other) throws AggregatorFactoryNotMergeableException {
        if (other.getName().equals(this.getName()) && other.getClass() == this.getClass()) {
            JavaScriptAggregatorFactory castedOther = (JavaScriptAggregatorFactory)other;
            if (this.fnCombine.equals(castedOther.fnCombine) && this.fnReset.equals(castedOther.fnReset)) {
                return this.getCombiningFactory();
            }
        }
        throw new AggregatorFactoryNotMergeableException(this, other);
    }

    @Override
    public List<AggregatorFactory> getRequiredColumns() {
        return ImmutableList.copyOf(Lists.transform(this.fieldNames, new Function<String, AggregatorFactory>(){

            @Override
            public AggregatorFactory apply(String input) {
                return new JavaScriptAggregatorFactory(input, Lists.newArrayList(input), JavaScriptAggregatorFactory.this.fnCombine, JavaScriptAggregatorFactory.this.fnReset, JavaScriptAggregatorFactory.this.fnCombine, JavaScriptAggregatorFactory.this.config);
            }
        }));
    }

    @Override
    public Object deserialize(Object object) {
        if (object instanceof String) {
            return Double.parseDouble((String)object);
        }
        return object;
    }

    @Override
    public Object finalizeComputation(Object object) {
        return object;
    }

    @Override
    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public List<String> getFieldNames() {
        return this.fieldNames;
    }

    @JsonProperty
    public String getFnAggregate() {
        return this.fnAggregate;
    }

    @JsonProperty
    public String getFnReset() {
        return this.fnReset;
    }

    @JsonProperty
    public String getFnCombine() {
        return this.fnCombine;
    }

    @Override
    public List<String> requiredFields() {
        return this.fieldNames;
    }

    @Override
    public byte[] getCacheKey() {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            byte[] fieldNameBytes = StringUtils.toUtf8(Joiner.on(",").join(this.fieldNames));
            byte[] sha1 = md.digest(StringUtils.toUtf8(this.fnAggregate + this.fnReset + this.fnCombine));
            return ByteBuffer.allocate(1 + fieldNameBytes.length + sha1.length).put((byte)6).put(fieldNameBytes).put(sha1).array();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Unable to get SHA1 digest instance", e);
        }
    }

    @Override
    public String getTypeName() {
        return "float";
    }

    @Override
    public int getMaxIntermediateSize() {
        return 8;
    }

    public String toString() {
        return "JavaScriptAggregatorFactory{name='" + this.name + '\'' + ", fieldNames=" + this.fieldNames + ", fnAggregate='" + this.fnAggregate + '\'' + ", fnReset='" + this.fnReset + '\'' + ", fnCombine='" + this.fnCombine + '\'' + '}';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAndCompileScript() {
        if (this.compiledScript == null) {
            Preconditions.checkState(this.config.isEnabled(), "JavaScript is disabled");
            JavaScriptConfig javaScriptConfig = this.config;
            synchronized (javaScriptConfig) {
                if (this.compiledScript == null) {
                    this.compiledScript = JavaScriptAggregatorFactory.compileScript(this.fnAggregate, this.fnReset, this.fnCombine);
                }
            }
        }
    }

    @VisibleForTesting
    static JavaScriptAggregator.ScriptAggregator compileScript(String aggregate, String reset, String combine) {
        final ContextFactory contextFactory = ContextFactory.getGlobal();
        Context context = contextFactory.enterContext();
        context.setOptimizationLevel(9);
        final ScriptableObject scope = context.initStandardObjects();
        final org.mozilla.javascript.Function fnAggregate = context.compileFunction((Scriptable)scope, aggregate, "aggregate", 1, null);
        final org.mozilla.javascript.Function fnReset = context.compileFunction((Scriptable)scope, reset, "reset", 1, null);
        final org.mozilla.javascript.Function fnCombine = context.compileFunction((Scriptable)scope, combine, "combine", 1, null);
        Context.exit();
        return new JavaScriptAggregator.ScriptAggregator(){

            @Override
            public double aggregate(double current, BaseObjectColumnValueSelector[] selectorList) {
                Context cx = Context.getCurrentContext();
                if (cx == null) {
                    cx = contextFactory.enterContext();
                    cx.getWrapFactory().setJavaPrimitiveWrap(false);
                }
                int size = selectorList.length;
                Object[] args = new Object[size + 1];
                args[0] = current;
                for (int i = 0; i < size; ++i) {
                    BaseObjectColumnValueSelector selector = selectorList[i];
                    if (selector == null) continue;
                    Object arg = selector.getObject();
                    if (arg != null && arg.getClass().isArray()) {
                        Object[] arrayAsObjectArray = new Object[Array.getLength(arg)];
                        for (int j = 0; j < Array.getLength(arg); ++j) {
                            arrayAsObjectArray[j] = Array.get(arg, j);
                        }
                        args[i + 1] = cx.newArray((Scriptable)scope, arrayAsObjectArray);
                        continue;
                    }
                    args[i + 1] = Context.javaToJS(arg, (Scriptable)scope);
                }
                Object res = fnAggregate.call(cx, (Scriptable)scope, (Scriptable)scope, args);
                return Context.toNumber((Object)res);
            }

            @Override
            public double combine(final double a, final double b) {
                Object res = contextFactory.call(new ContextAction(){

                    public Object run(Context cx) {
                        return fnCombine.call(cx, (Scriptable)scope, (Scriptable)scope, new Object[]{a, b});
                    }
                });
                return Context.toNumber((Object)res);
            }

            @Override
            public double reset() {
                Object res = contextFactory.call(new ContextAction(){

                    public Object run(Context cx) {
                        return fnReset.call(cx, (Scriptable)scope, (Scriptable)scope, new Object[0]);
                    }
                });
                return Context.toNumber((Object)res);
            }

            @Override
            public void close() {
                if (Context.getCurrentContext() != null) {
                    Context.exit();
                }
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavaScriptAggregatorFactory that = (JavaScriptAggregatorFactory)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.fieldNames, that.fieldNames) && Objects.equals(this.fnAggregate, that.fnAggregate) && Objects.equals(this.fnReset, that.fnReset) && Objects.equals(this.fnCombine, that.fnCombine);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.fieldNames, this.fnAggregate, this.fnReset, this.fnCombine);
    }
}

