/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.aggregation;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JacksonInject;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.apache.hive.druid.io.druid.math.expr.ExprMacroTable;
import org.apache.hive.druid.io.druid.query.aggregation.AggregateCombiner;
import org.apache.hive.druid.io.druid.query.aggregation.Aggregator;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.BufferAggregator;
import org.apache.hive.druid.io.druid.query.aggregation.DoubleMaxAggregateCombiner;
import org.apache.hive.druid.io.druid.query.aggregation.FloatMaxAggregator;
import org.apache.hive.druid.io.druid.query.aggregation.FloatMaxBufferAggregator;
import org.apache.hive.druid.io.druid.query.aggregation.SimpleFloatAggregatorFactory;
import org.apache.hive.druid.io.druid.segment.ColumnSelectorFactory;

public class FloatMaxAggregatorFactory
extends SimpleFloatAggregatorFactory {
    @JsonCreator
    public FloatMaxAggregatorFactory(@JsonProperty(value="name") String name, @JsonProperty(value="fieldName") String fieldName, @JsonProperty(value="expression") String expression, @JacksonInject ExprMacroTable macroTable) {
        super(macroTable, name, fieldName, expression);
    }

    public FloatMaxAggregatorFactory(String name, String fieldName) {
        this(name, fieldName, null, ExprMacroTable.nil());
    }

    @Override
    public Aggregator factorize(ColumnSelectorFactory metricFactory) {
        return new FloatMaxAggregator(this.makeColumnValueSelectorWithFloatDefault(metricFactory, Float.NEGATIVE_INFINITY));
    }

    @Override
    public BufferAggregator factorizeBuffered(ColumnSelectorFactory metricFactory) {
        return new FloatMaxBufferAggregator(this.makeColumnValueSelectorWithFloatDefault(metricFactory, Float.NEGATIVE_INFINITY));
    }

    @Override
    public Object combine(Object lhs, Object rhs) {
        return FloatMaxAggregator.combineValues(this.finalizeComputation(lhs), this.finalizeComputation(rhs));
    }

    @Override
    public AggregateCombiner makeAggregateCombiner() {
        return new DoubleMaxAggregateCombiner();
    }

    @Override
    public AggregatorFactory getCombiningFactory() {
        return new FloatMaxAggregatorFactory(this.name, this.name, null, this.macroTable);
    }

    @Override
    public List<AggregatorFactory> getRequiredColumns() {
        return Collections.singletonList(new FloatMaxAggregatorFactory(this.fieldName, this.fieldName, this.expression, this.macroTable));
    }

    @JsonProperty
    public String getFieldName() {
        return this.fieldName;
    }

    @JsonProperty
    public String getExpression() {
        return this.expression;
    }

    @Override
    @JsonProperty
    public String getName() {
        return this.name;
    }

    @Override
    public byte[] getCacheKey() {
        byte[] fieldNameBytes = StringUtils.toUtf8WithNullToEmpty(this.fieldName);
        byte[] expressionBytes = StringUtils.toUtf8WithNullToEmpty(this.expression);
        return ByteBuffer.allocate(2 + fieldNameBytes.length + expressionBytes.length).put((byte)13).put(fieldNameBytes).put((byte)-1).put(expressionBytes).array();
    }

    public String toString() {
        return "FloatMaxAggregatorFactory{fieldName='" + this.fieldName + '\'' + ", expression='" + this.expression + '\'' + ", name='" + this.name + '\'' + '}';
    }
}

