/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.metadata;

import com.google.inject.Inject;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.base.Predicates;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.com.google.common.collect.Collections2;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Interner;
import org.apache.hive.druid.com.google.common.collect.Interners;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Ordering;
import org.apache.hive.druid.com.google.common.util.concurrent.ListenableFuture;
import org.apache.hive.druid.com.google.common.util.concurrent.ListeningScheduledExecutorService;
import org.apache.hive.druid.com.google.common.util.concurrent.MoreExecutors;
import org.apache.hive.druid.io.druid.client.DruidDataSource;
import org.apache.hive.druid.io.druid.client.ImmutableDruidDataSource;
import org.apache.hive.druid.io.druid.concurrent.LifecycleLock;
import org.apache.hive.druid.io.druid.guice.ManageLifecycle;
import org.apache.hive.druid.io.druid.java.util.common.DateTimes;
import org.apache.hive.druid.io.druid.java.util.common.Intervals;
import org.apache.hive.druid.io.druid.java.util.common.MapUtils;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.apache.hive.druid.io.druid.java.util.common.concurrent.Execs;
import org.apache.hive.druid.io.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.hive.druid.io.druid.java.util.common.lifecycle.LifecycleStop;
import org.apache.hive.druid.io.druid.java.util.emitter.EmittingLogger;
import org.apache.hive.druid.io.druid.metadata.MetadataSegmentManager;
import org.apache.hive.druid.io.druid.metadata.MetadataSegmentManagerConfig;
import org.apache.hive.druid.io.druid.metadata.MetadataStorageTablesConfig;
import org.apache.hive.druid.io.druid.metadata.SQLMetadataConnector;
import org.apache.hive.druid.io.druid.timeline.DataSegment;
import org.apache.hive.druid.io.druid.timeline.TimelineObjectHolder;
import org.apache.hive.druid.io.druid.timeline.VersionedIntervalTimeline;
import org.apache.hive.druid.io.druid.timeline.partition.PartitionChunk;
import org.joda.time.Duration;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.skife.jdbi.v2.BaseResultSetMapper;
import org.skife.jdbi.v2.Batch;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.FoldController;
import org.skife.jdbi.v2.Folder3;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.TransactionCallback;
import org.skife.jdbi.v2.TransactionStatus;
import org.skife.jdbi.v2.Update;
import org.skife.jdbi.v2.tweak.HandleCallback;
import org.skife.jdbi.v2.tweak.ResultSetMapper;
import org.skife.jdbi.v2.util.ByteArrayMapper;

@ManageLifecycle
public class SQLMetadataSegmentManager
implements MetadataSegmentManager {
    private static final Interner<DataSegment> DATA_SEGMENT_INTERNER = Interners.newWeakInterner();
    private static final EmittingLogger log = new EmittingLogger(SQLMetadataSegmentManager.class);
    private final LifecycleLock lifecycleLock = new LifecycleLock();
    private final ObjectMapper jsonMapper;
    private final Supplier<MetadataSegmentManagerConfig> config;
    private final Supplier<MetadataStorageTablesConfig> dbTables;
    private final AtomicReference<ConcurrentHashMap<String, DruidDataSource>> dataSourcesRef;
    private final SQLMetadataConnector connector;
    private volatile ListeningScheduledExecutorService exec = null;
    private volatile ListenableFuture<?> future = null;

    @Inject
    public SQLMetadataSegmentManager(ObjectMapper jsonMapper, Supplier<MetadataSegmentManagerConfig> config, Supplier<MetadataStorageTablesConfig> dbTables, SQLMetadataConnector connector) {
        this.jsonMapper = jsonMapper;
        this.config = config;
        this.dbTables = dbTables;
        this.dataSourcesRef = new AtomicReference(new ConcurrentHashMap());
        this.connector = connector;
    }

    @Override
    @LifecycleStart
    public void start() {
        if (!this.lifecycleLock.canStart()) {
            return;
        }
        try {
            this.exec = MoreExecutors.listeningDecorator(Execs.scheduledSingleThreaded("DatabaseSegmentManager-Exec--%d"));
            Duration delay = this.config.get().getPollDuration().toStandardDuration();
            this.future = this.exec.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    try {
                        SQLMetadataSegmentManager.this.poll();
                    }
                    catch (Exception e) {
                        log.makeAlert(e, "uncaught exception in segment manager polling thread", new Object[0]).emit();
                    }
                }
            }, 0L, delay.getMillis(), TimeUnit.MILLISECONDS);
            this.lifecycleLock.started();
        }
        finally {
            this.lifecycleLock.exitStart();
        }
    }

    @Override
    @LifecycleStop
    public void stop() {
        if (!this.lifecycleLock.canStop()) {
            return;
        }
        try {
            ConcurrentHashMap<String, DruidDataSource> current;
            ConcurrentHashMap emptyMap = new ConcurrentHashMap();
            while (!this.dataSourcesRef.compareAndSet(current = this.dataSourcesRef.get(), emptyMap)) {
            }
            this.future.cancel(false);
            this.future = null;
            this.exec.shutdownNow();
            this.exec = null;
        }
        finally {
            this.lifecycleLock.exitStop();
        }
    }

    @Override
    public boolean enableDatasource(final String ds) {
        try {
            DBI dbi = this.connector.getDBI();
            VersionedIntervalTimeline<String, DataSegment> segmentTimeline = this.connector.inReadOnlyTransaction(new TransactionCallback<VersionedIntervalTimeline<String, DataSegment>>(){

                @Override
                public VersionedIntervalTimeline<String, DataSegment> inTransaction(Handle handle, TransactionStatus status) throws Exception {
                    return ((Query)handle.createQuery(StringUtils.format("SELECT payload FROM %s WHERE dataSource = :dataSource", SQLMetadataSegmentManager.this.getSegmentsTable())).setFetchSize(SQLMetadataSegmentManager.this.connector.getStreamingFetchSize()).bind("dataSource", ds)).map(ByteArrayMapper.FIRST).fold(new VersionedIntervalTimeline(Ordering.natural()), new Folder3<VersionedIntervalTimeline<String, DataSegment>, byte[]>(){

                        @Override
                        public VersionedIntervalTimeline<String, DataSegment> fold(VersionedIntervalTimeline<String, DataSegment> timeline, byte[] payload, FoldController foldController, StatementContext statementContext) throws SQLException {
                            try {
                                DataSegment segment = DATA_SEGMENT_INTERNER.intern(SQLMetadataSegmentManager.this.jsonMapper.readValue(payload, DataSegment.class));
                                timeline.add(segment.getInterval(), segment.getVersion(), segment.getShardSpec().createChunk(segment));
                                return timeline;
                            }
                            catch (Exception e) {
                                throw new SQLException(e.toString());
                            }
                        }
                    });
                }
            });
            final ArrayList<DataSegment> segments = Lists.newArrayList();
            List<TimelineObjectHolder<String, DataSegment>> timelineObjectHolders = segmentTimeline.lookup(Intervals.of("0000-01-01/3000-01-01"));
            for (TimelineObjectHolder<String, DataSegment> objectHolder : timelineObjectHolders) {
                for (PartitionChunk<DataSegment> partitionChunk : objectHolder.getObject()) {
                    segments.add(partitionChunk.getObject());
                }
            }
            if (segments.isEmpty()) {
                log.warn("No segments found in the database!", new Object[0]);
                return false;
            }
            dbi.withHandle(new HandleCallback<Void>(){

                @Override
                public Void withHandle(Handle handle) throws Exception {
                    Batch batch = handle.createBatch();
                    for (DataSegment segment : segments) {
                        batch.add(StringUtils.format("UPDATE %s SET used=true WHERE id = '%s'", SQLMetadataSegmentManager.this.getSegmentsTable(), segment.getIdentifier()));
                    }
                    batch.execute();
                    return null;
                }
            });
        }
        catch (Exception e) {
            log.error(e, "Exception enabling datasource %s", ds);
            return false;
        }
        return true;
    }

    @Override
    public boolean enableSegment(final String segmentId) {
        try {
            this.connector.getDBI().withHandle(new HandleCallback<Void>(){

                @Override
                public Void withHandle(Handle handle) throws Exception {
                    ((Update)handle.createStatement(StringUtils.format("UPDATE %s SET used=true WHERE id = :id", SQLMetadataSegmentManager.this.getSegmentsTable())).bind("id", segmentId)).execute();
                    return null;
                }
            });
        }
        catch (Exception e) {
            log.error(e, "Exception enabling segment %s", segmentId);
            return false;
        }
        return true;
    }

    @Override
    public boolean removeDatasource(String ds) {
        try {
            int removed = this.connector.getDBI().withHandle(handle -> ((Update)handle.createStatement(StringUtils.format("UPDATE %s SET used=false WHERE dataSource = :dataSource", this.getSegmentsTable())).bind("dataSource", ds)).execute());
            this.dataSourcesRef.get().remove(ds);
            if (removed == 0) {
                return false;
            }
        }
        catch (Exception e) {
            log.error(e, "Error removing datasource %s", ds);
            return false;
        }
        return true;
    }

    @Override
    public boolean removeSegment(String ds, String segmentID) {
        try {
            int removed = this.connector.getDBI().withHandle(handle -> ((Update)handle.createStatement(StringUtils.format("UPDATE %s SET used=false WHERE id = :segmentID", this.getSegmentsTable())).bind("segmentID", segmentID)).execute());
            ConcurrentHashMap<String, DruidDataSource> dataSourceMap = this.dataSourcesRef.get();
            DruidDataSource dataSource = dataSourceMap.get(ds);
            if (dataSource != null) {
                dataSource.removePartition(segmentID);
                if (dataSource.isEmpty()) {
                    dataSourceMap.remove(ds);
                }
            }
            if (removed == 0) {
                return false;
            }
        }
        catch (Exception e) {
            log.error(e, e.toString(), new Object[0]);
            return false;
        }
        return true;
    }

    @Override
    public boolean isStarted() {
        return this.lifecycleLock.isStarted();
    }

    @Override
    @Nullable
    public ImmutableDruidDataSource getInventoryValue(String key) {
        DruidDataSource dataSource = this.dataSourcesRef.get().get(key);
        return dataSource == null ? null : dataSource.toImmutableDruidDataSource();
    }

    @Override
    public Collection<ImmutableDruidDataSource> getInventory() {
        return this.dataSourcesRef.get().values().stream().map(DruidDataSource::toImmutableDruidDataSource).collect(Collectors.toList());
    }

    @Override
    public Collection<String> getAllDatasourceNames() {
        return this.connector.getDBI().withHandle(handle -> handle.createQuery(StringUtils.format("SELECT DISTINCT(datasource) FROM %s", this.getSegmentsTable())).fold(new ArrayList(), new Folder3<List<String>, Map<String, Object>>(){

            @Override
            public List<String> fold(List<String> druidDataSources, Map<String, Object> stringObjectMap, FoldController foldController, StatementContext statementContext) throws SQLException {
                druidDataSources.add(MapUtils.getString(stringObjectMap, "datasource"));
                return druidDataSources;
            }
        }));
    }

    @Override
    public void poll() {
        try {
            ConcurrentHashMap<String, DruidDataSource> current;
            if (!this.lifecycleLock.isStarted()) {
                return;
            }
            ConcurrentHashMap<String, DruidDataSource> newDataSources = new ConcurrentHashMap<String, DruidDataSource>();
            log.debug("Starting polling of segment table", new Object[0]);
            List<DataSegment> segments = this.connector.inReadOnlyTransaction(new TransactionCallback<List<DataSegment>>(){

                @Override
                public List<DataSegment> inTransaction(Handle handle, TransactionStatus status) throws Exception {
                    return handle.createQuery(StringUtils.format("SELECT payload FROM %s WHERE used=true", SQLMetadataSegmentManager.this.getSegmentsTable())).setFetchSize(SQLMetadataSegmentManager.this.connector.getStreamingFetchSize()).map(new ResultSetMapper<DataSegment>(){

                        @Override
                        public DataSegment map(int index, ResultSet r, StatementContext ctx) throws SQLException {
                            try {
                                return DATA_SEGMENT_INTERNER.intern(SQLMetadataSegmentManager.this.jsonMapper.readValue(r.getBytes("payload"), DataSegment.class));
                            }
                            catch (IOException e) {
                                log.makeAlert(e, "Failed to read segment from db.", new Object[0]).emit();
                                return null;
                            }
                        }
                    }).list();
                }
            });
            if (segments == null || segments.isEmpty()) {
                log.warn("No segments found in the database!", new Object[0]);
                return;
            }
            Collection<DataSegment> segmentsFinal = Collections2.filter(segments, Predicates.notNull());
            log.info("Polled and found %,d segments in the database", segments.size());
            for (DataSegment segment : segmentsFinal) {
                DruidDataSource shouldBeNull;
                String datasourceName = segment.getDataSource();
                DruidDataSource dataSource = (DruidDataSource)newDataSources.get(datasourceName);
                if (dataSource == null && (shouldBeNull = newDataSources.put(datasourceName, dataSource = new DruidDataSource(datasourceName, ImmutableMap.of("created", DateTimes.nowUtc().toString())))) != null) {
                    log.warn("Just put key[%s] into dataSources and what was there wasn't null!?  It was[%s]", datasourceName, shouldBeNull);
                }
                if (dataSource.getSegments().contains(segment)) continue;
                dataSource.addSegment(segment);
            }
            while (!this.dataSourcesRef.compareAndSet(current = this.dataSourcesRef.get(), newDataSources)) {
            }
        }
        catch (Exception e) {
            log.makeAlert(e, "Problem polling DB.", new Object[0]).emit();
        }
    }

    private String getSegmentsTable() {
        return this.dbTables.get().getSegmentsTable();
    }

    @Override
    public List<Interval> getUnusedSegmentIntervals(final String dataSource, final Interval interval, final int limit) {
        return this.connector.inReadOnlyTransaction(new TransactionCallback<List<Interval>>(){

            @Override
            public List<Interval> inTransaction(Handle handle, TransactionStatus status) throws Exception {
                Iterator iter = ((Query)((Query)((Query)handle.createQuery(StringUtils.format("SELECT start, %2$send%2$s FROM %1$s WHERE dataSource = :dataSource and start >= :start and %2$send%2$s <= :end and used = false ORDER BY start, %2$send%2$s", SQLMetadataSegmentManager.this.getSegmentsTable(), SQLMetadataSegmentManager.this.connector.getQuoteString())).setFetchSize(SQLMetadataSegmentManager.this.connector.getStreamingFetchSize()).setMaxRows(limit).bind("dataSource", dataSource)).bind("start", interval.getStart().toString())).bind("end", interval.getEnd().toString())).map(new BaseResultSetMapper<Interval>(){

                    @Override
                    protected Interval mapInternal(int index, Map<String, Object> row) {
                        return new Interval((ReadableInstant)DateTimes.of((String)row.get("start")), (ReadableInstant)DateTimes.of((String)row.get("end")));
                    }
                }).iterator();
                ArrayList<Interval> result = Lists.newArrayListWithCapacity(limit);
                for (int i = 0; i < limit && iter.hasNext(); ++i) {
                    try {
                        result.add((Interval)iter.next());
                        continue;
                    }
                    catch (Exception e) {
                        throw Throwables.propagate(e);
                    }
                }
                return result;
            }
        });
    }
}

