/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.java.util.common.parsers;

import java.nio.charset.CharsetEncoder;
import java.util.List;
import java.util.Map;
import org.apache.hive.druid.com.fasterxml.jackson.databind.JsonNode;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.base.Charsets;
import org.apache.hive.druid.io.druid.java.util.common.parsers.JSONFlattenerMaker;
import org.apache.hive.druid.io.druid.java.util.common.parsers.JSONPathSpec;
import org.apache.hive.druid.io.druid.java.util.common.parsers.ObjectFlattener;
import org.apache.hive.druid.io.druid.java.util.common.parsers.ObjectFlatteners;
import org.apache.hive.druid.io.druid.java.util.common.parsers.ParseException;
import org.apache.hive.druid.io.druid.java.util.common.parsers.Parser;

public class JSONPathParser
implements Parser<String, Object> {
    private final ObjectMapper mapper;
    private final CharsetEncoder enc = Charsets.UTF_8.newEncoder();
    private final ObjectFlattener<JsonNode> flattener;

    public JSONPathParser(JSONPathSpec flattenSpec, ObjectMapper mapper) {
        this.mapper = mapper == null ? new ObjectMapper() : mapper;
        this.flattener = ObjectFlatteners.create(flattenSpec, new JSONFlattenerMaker());
    }

    @Override
    public List<String> getFieldNames() {
        return null;
    }

    @Override
    public void setFieldNames(Iterable<String> fieldNames) {
    }

    @Override
    public Map<String, Object> parseToMap(String input) {
        try {
            JsonNode document = this.mapper.readValue(input, JsonNode.class);
            return this.flattener.flatten(document);
        }
        catch (Exception e) {
            throw new ParseException(e, "Unable to parse row [%s]", input);
        }
    }
}

