/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.java.util.common.concurrent;

import java.util.AbstractQueue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Strings;
import org.apache.hive.druid.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.hive.druid.io.druid.java.util.common.concurrent.DummyExecutorService;

public class Execs {
    public static ExecutorService dummy() {
        return DummyExecutorService.INSTANCE;
    }

    public static ExecutorService singleThreaded(@NotNull String nameFormat) {
        return Execs.singleThreaded(nameFormat, null);
    }

    public static ExecutorService singleThreaded(@NotNull String nameFormat, @Nullable Integer priority) {
        return Executors.newSingleThreadExecutor(Execs.makeThreadFactory(nameFormat, priority));
    }

    public static ExecutorService multiThreaded(int threads, @NotNull String nameFormat) {
        return Execs.multiThreaded(threads, nameFormat, null);
    }

    public static ExecutorService multiThreaded(int threads, @NotNull String nameFormat, @Nullable Integer priority) {
        return Executors.newFixedThreadPool(threads, Execs.makeThreadFactory(nameFormat, priority));
    }

    public static ScheduledExecutorService scheduledSingleThreaded(@NotNull String nameFormat) {
        return Execs.scheduledSingleThreaded(nameFormat, null);
    }

    public static ScheduledExecutorService scheduledSingleThreaded(@NotNull String nameFormat, @Nullable Integer priority) {
        return Executors.newSingleThreadScheduledExecutor(Execs.makeThreadFactory(nameFormat, priority));
    }

    public static ThreadFactory makeThreadFactory(@NotNull String nameFormat) {
        return Execs.makeThreadFactory(nameFormat, null);
    }

    public static ThreadFactory makeThreadFactory(@NotNull String nameFormat, @Nullable Integer priority) {
        ThreadFactoryBuilder builder = new ThreadFactoryBuilder().setDaemon(true).setNameFormat(nameFormat);
        if (priority != null) {
            builder.setPriority(priority);
        }
        return builder.build();
    }

    public static Thread makeThread(String name, Runnable runnable, boolean isDaemon) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(name), "name null/empty");
        Preconditions.checkNotNull(runnable, "null runnable");
        Thread t = new Thread(runnable);
        t.setName(name);
        t.setDaemon(isDaemon);
        return t;
    }

    public static ExecutorService newBlockingSingleThreaded(String nameFormat, int capacity) {
        return Execs.newBlockingSingleThreaded(nameFormat, capacity, null);
    }

    public static ExecutorService newBlockingSingleThreaded(String nameFormat, int capacity, Integer priority) {
        AbstractQueue queue = capacity > 0 ? new ArrayBlockingQueue(capacity) : new SynchronousQueue();
        return new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, (BlockingQueue<Runnable>)((Object)queue), Execs.makeThreadFactory(nameFormat, priority), new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                try {
                    executor.getQueue().put(r);
                }
                catch (InterruptedException e) {
                    throw new RejectedExecutionException("Got Interrupted while adding to the Queue", e);
                }
            }
        });
    }
}

