/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.java.util.common;

import java.util.Comparator;
import org.apache.hive.druid.com.google.common.base.Function;

public class Pair<T1, T2> {
    public final T1 lhs;
    public final T2 rhs;

    public static <T1, T2> Pair<T1, T2> of(T1 lhs, T2 rhs) {
        return new Pair<T1, T2>(lhs, rhs);
    }

    public Pair(T1 lhs, T2 rhs) {
        this.lhs = lhs;
        this.rhs = rhs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pair pair = (Pair)o;
        if (this.lhs != null ? !this.lhs.equals(pair.lhs) : pair.lhs != null) {
            return false;
        }
        return !(this.rhs != null ? !this.rhs.equals(pair.rhs) : pair.rhs != null);
    }

    public int hashCode() {
        int result = this.lhs != null ? this.lhs.hashCode() : 0;
        result = 31 * result + (this.rhs != null ? this.rhs.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Pair{lhs=" + this.lhs + ", rhs=" + this.rhs + '}';
    }

    public static <T1, T2> Function<Pair<T1, T2>, T1> lhsFn() {
        return new Function<Pair<T1, T2>, T1>(){

            @Override
            public T1 apply(Pair<T1, T2> input) {
                return input.lhs;
            }
        };
    }

    public static <T1, T2> Function<Pair<T1, T2>, T2> rhsFn() {
        return new Function<Pair<T1, T2>, T2>(){

            @Override
            public T2 apply(Pair<T1, T2> input) {
                return input.rhs;
            }
        };
    }

    public static <T1> Comparator<Pair<T1, ?>> lhsComparator(final Comparator<T1> comparator) {
        return new Comparator<Pair<T1, ?>>(){

            @Override
            public int compare(Pair<T1, ?> o1, Pair<T1, ?> o2) {
                return comparator.compare(o1.lhs, o2.lhs);
            }
        };
    }
}

