/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.jackson;

import java.io.IOException;
import org.apache.hive.druid.com.fasterxml.jackson.core.JsonParser;
import org.apache.hive.druid.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.hive.druid.com.fasterxml.jackson.core.JsonToken;
import org.apache.hive.druid.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.hive.druid.com.fasterxml.jackson.databind.KeyDeserializer;
import org.apache.hive.druid.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import org.apache.hive.druid.com.fasterxml.jackson.databind.module.SimpleModule;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import org.apache.hive.druid.com.fasterxml.jackson.datatype.joda.deser.DurationDeserializer;
import org.apache.hive.druid.com.fasterxml.jackson.datatype.joda.deser.PeriodDeserializer;
import org.apache.hive.druid.io.druid.java.util.common.DateTimes;
import org.apache.hive.druid.io.druid.java.util.common.Intervals;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.Interval;
import org.joda.time.Period;

class JodaStuff {
    JodaStuff() {
    }

    static SimpleModule register(SimpleModule module) {
        module.addKeyDeserializer(DateTime.class, new DateTimeKeyDeserializer());
        module.addDeserializer(DateTime.class, new DateTimeDeserializer());
        module.addSerializer(DateTime.class, ToStringSerializer.instance);
        module.addDeserializer(Interval.class, new IntervalDeserializer());
        module.addSerializer(Interval.class, ToStringSerializer.instance);
        PeriodDeserializer periodDeserializer = new PeriodDeserializer();
        module.addDeserializer(Period.class, periodDeserializer);
        module.addSerializer(Period.class, ToStringSerializer.instance);
        module.addDeserializer(Duration.class, new DurationDeserializer());
        module.addSerializer(Duration.class, ToStringSerializer.instance);
        return module;
    }

    private static class DateTimeDeserializer
    extends StdDeserializer<DateTime> {
        public DateTimeDeserializer() {
            super(DateTime.class);
        }

        @Override
        public DateTime deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonToken t = jp.getCurrentToken();
            if (t == JsonToken.VALUE_NUMBER_INT) {
                return DateTimes.utc(jp.getLongValue());
            }
            if (t == JsonToken.VALUE_STRING) {
                String str = jp.getText().trim();
                if (str.length() == 0) {
                    return null;
                }
                return DateTimes.ISO_DATE_OR_TIME_WITH_OFFSET.parse(str);
            }
            throw ctxt.mappingException(this.getValueClass());
        }
    }

    private static class DateTimeKeyDeserializer
    extends KeyDeserializer {
        private DateTimeKeyDeserializer() {
        }

        @Override
        public Object deserializeKey(String key, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return DateTimes.of(key);
        }
    }

    private static class IntervalDeserializer
    extends StdDeserializer<Interval> {
        public IntervalDeserializer() {
            super(Interval.class);
        }

        @Override
        public Interval deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            return Intervals.of(jsonParser.getText());
        }
    }
}

