/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.data.input.impl.prefetch;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.io.druid.data.input.impl.prefetch.CacheManager;
import org.apache.hive.druid.io.druid.data.input.impl.prefetch.FetchedFile;
import org.apache.hive.druid.io.druid.data.input.impl.prefetch.ObjectOpenFunction;
import org.apache.hive.druid.io.druid.data.input.impl.prefetch.OpenedObject;
import org.apache.hive.druid.io.druid.java.util.common.ISE;
import org.apache.hive.druid.io.druid.java.util.common.logger.Logger;

public class Fetcher<T>
implements Iterator<OpenedObject<T>> {
    private static final Logger LOG = new Logger(Fetcher.class);
    private static final String FETCH_FILE_PREFIX = "fetch-";
    private static final int BUFFER_SIZE = 4096;
    private final CacheManager<T> cacheManager;
    private final List<T> objects;
    private final ExecutorService fetchExecutor;
    private final File temporaryDirectory;
    private final long maxFetchCapacityBytes;
    private final boolean prefetchEnabled;
    private final long prefetchTriggerBytes;
    private final long fetchTimeout;
    private final int maxFetchRetry;
    private final LinkedBlockingQueue<FetchedFile<T>> fetchedFiles = new LinkedBlockingQueue();
    private final AtomicLong fetchedBytes = new AtomicLong(0L);
    private final ObjectOpenFunction<T> openObjectFunction;
    private final byte[] buffer;
    private Future<Void> fetchFuture;
    private int nextFetchIndex;
    private int numRemainingObjects;

    Fetcher(CacheManager<T> cacheManager, List<T> objects, ExecutorService fetchExecutor, File temporaryDirectory, long maxFetchCapacityBytes, long prefetchTriggerBytes, long fetchTimeout, int maxFetchRetry, ObjectOpenFunction<T> openObjectFunction) {
        this.cacheManager = cacheManager;
        this.objects = objects;
        this.fetchExecutor = fetchExecutor;
        this.temporaryDirectory = temporaryDirectory;
        this.maxFetchCapacityBytes = maxFetchCapacityBytes;
        this.prefetchTriggerBytes = prefetchTriggerBytes;
        this.fetchTimeout = fetchTimeout;
        this.maxFetchRetry = maxFetchRetry;
        this.openObjectFunction = openObjectFunction;
        this.buffer = new byte[4096];
        this.prefetchEnabled = maxFetchCapacityBytes > 0L;
        this.numRemainingObjects = objects.size();
        this.fetchedFiles.addAll(cacheManager.getFiles());
        this.nextFetchIndex = this.fetchedFiles.size();
        if (this.prefetchEnabled) {
            this.fetchIfNeeded(0L);
        }
    }

    private void fetchIfNeeded(long remainingBytes) {
        if ((this.fetchFuture == null || this.fetchFuture.isDone()) && remainingBytes <= this.prefetchTriggerBytes) {
            this.fetchFuture = this.fetchExecutor.submit(() -> {
                this.fetch();
                return null;
            });
        }
    }

    private void fetch() throws Exception {
        while (this.nextFetchIndex < this.objects.size() && this.fetchedBytes.get() <= this.maxFetchCapacityBytes) {
            T object = this.objects.get(this.nextFetchIndex);
            LOG.info("Fetching [%d]th object[%s], fetchedBytes[%d]", this.nextFetchIndex, object, this.fetchedBytes.get());
            File outFile = File.createTempFile(FETCH_FILE_PREFIX, null, this.temporaryDirectory);
            this.fetchedBytes.addAndGet(this.download(object, outFile, 0));
            this.fetchedFiles.put(new FetchedFile<T>(object, outFile, Fetcher.getFileCloser(outFile, this.fetchedBytes)));
            ++this.nextFetchIndex;
        }
    }

    /*
     * Exception decompiling
     */
    private long download(T object, File outFile, int tryCount) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean hasNext() {
        return this.numRemainingObjects > 0;
    }

    @Override
    public OpenedObject<T> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.checkFetchException(false);
        try {
            OpenedObject<T> openedObject = this.prefetchEnabled ? this.openObjectFromLocal() : this.openObjectFromRemote();
            --this.numRemainingObjects;
            return openedObject;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void checkFetchException(boolean wait) {
        try {
            if (wait) {
                this.fetchFuture.get(this.fetchTimeout, TimeUnit.MILLISECONDS);
                this.fetchFuture = null;
            } else if (this.fetchFuture != null && this.fetchFuture.isDone()) {
                this.fetchFuture.get();
                this.fetchFuture = null;
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        catch (TimeoutException e) {
            throw new ISE(e, "Failed to fetch, but cannot check the reason in [%d] ms", this.fetchTimeout);
        }
    }

    private OpenedObject<T> openObjectFromLocal() throws IOException {
        FetchedFile<T> fetchedFile;
        if (!this.fetchedFiles.isEmpty()) {
            fetchedFile = this.fetchedFiles.poll();
        } else {
            try {
                this.fetchIfNeeded(this.fetchedBytes.get());
                fetchedFile = this.fetchedFiles.poll(this.fetchTimeout, TimeUnit.MILLISECONDS);
                if (fetchedFile == null) {
                    this.checkFetchException(true);
                    throw new RuntimeException(new TimeoutException());
                }
            }
            catch (InterruptedException e) {
                throw Throwables.propagate(e);
            }
        }
        FetchedFile<T> maybeCached = this.cacheIfPossible(fetchedFile);
        this.fetchIfNeeded(this.fetchedBytes.get());
        return new OpenedObject<T>(maybeCached);
    }

    private OpenedObject<T> openObjectFromRemote() throws IOException {
        if (this.fetchedFiles.size() > 0) {
            return new OpenedObject<T>(this.fetchedFiles.poll());
        }
        if (this.cacheManager.cacheable()) {
            try {
                this.fetch();
                FetchedFile<T> fetchedFile = this.fetchedFiles.poll();
                if (fetchedFile == null) {
                    throw new ISE("Cannot fetch object[%s]", this.objects.get(this.nextFetchIndex - 1));
                }
                FetchedFile<T> cached = this.cacheIfPossible(fetchedFile);
                return new OpenedObject<T>(cached);
            }
            catch (Exception e) {
                throw Throwables.propagate(e);
            }
        }
        T object = this.objects.get(this.nextFetchIndex);
        LOG.info("Reading [%d]th object[%s]", this.nextFetchIndex, object);
        ++this.nextFetchIndex;
        return new OpenedObject<T>(object, this.openObjectFunction.open(object), Fetcher.getNoopCloser());
    }

    private FetchedFile<T> cacheIfPossible(FetchedFile<T> fetchedFile) {
        if (this.cacheManager.cacheable()) {
            FetchedFile<T> cachedFile = this.cacheManager.cache(fetchedFile);
            this.fetchedBytes.addAndGet(-fetchedFile.length());
            return cachedFile;
        }
        return fetchedFile;
    }

    private static Closeable getNoopCloser() {
        return () -> {};
    }

    private static Closeable getFileCloser(File file, AtomicLong fetchedBytes) {
        return () -> {
            long fileSize = file.length();
            file.delete();
            fetchedBytes.addAndGet(-fileSize);
        };
    }
}

