/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.data.input.impl;

import java.util.List;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Optional;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.io.druid.data.input.impl.DimensionsSpec;
import org.apache.hive.druid.io.druid.data.input.impl.ParseSpec;
import org.apache.hive.druid.io.druid.data.input.impl.TimestampSpec;
import org.apache.hive.druid.io.druid.java.util.common.parsers.Parser;
import org.apache.hive.druid.io.druid.java.util.common.parsers.RegexParser;

public class RegexParseSpec
extends ParseSpec {
    private final String listDelimiter;
    private final List<String> columns;
    private final String pattern;

    @JsonCreator
    public RegexParseSpec(@JsonProperty(value="timestampSpec") TimestampSpec timestampSpec, @JsonProperty(value="dimensionsSpec") DimensionsSpec dimensionsSpec, @JsonProperty(value="listDelimiter") String listDelimiter, @JsonProperty(value="columns") List<String> columns, @JsonProperty(value="pattern") String pattern) {
        super(timestampSpec, dimensionsSpec);
        this.listDelimiter = listDelimiter;
        this.columns = columns;
        this.pattern = pattern;
        this.verify(dimensionsSpec.getDimensionNames());
    }

    @JsonProperty
    public String getListDelimiter() {
        return this.listDelimiter;
    }

    @JsonProperty(value="pattern")
    public String getPattern() {
        return this.pattern;
    }

    @JsonProperty
    public List<String> getColumns() {
        return this.columns;
    }

    @Override
    public void verify(List<String> usedCols) {
        if (this.columns != null) {
            for (String columnName : usedCols) {
                Preconditions.checkArgument(this.columns.contains(columnName), "column[%s] not in columns.", new Object[]{columnName});
            }
        }
    }

    @Override
    public Parser<String, Object> makeParser() {
        if (this.columns == null) {
            return new RegexParser(this.pattern, Optional.fromNullable(this.listDelimiter));
        }
        return new RegexParser(this.pattern, Optional.fromNullable(this.listDelimiter), this.columns);
    }

    @Override
    public ParseSpec withTimestampSpec(TimestampSpec spec) {
        return new RegexParseSpec(spec, this.getDimensionsSpec(), this.listDelimiter, this.columns, this.pattern);
    }

    @Override
    public ParseSpec withDimensionsSpec(DimensionsSpec spec) {
        return new RegexParseSpec(this.getTimestampSpec(), spec, this.listDelimiter, this.columns, this.pattern);
    }
}

