/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.data.input.impl;

import java.util.Objects;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonSubTypes;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonValue;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.io.druid.data.input.impl.DoubleDimensionSchema;
import org.apache.hive.druid.io.druid.data.input.impl.FloatDimensionSchema;
import org.apache.hive.druid.io.druid.data.input.impl.LongDimensionSchema;
import org.apache.hive.druid.io.druid.data.input.impl.NewSpatialDimensionSchema;
import org.apache.hive.druid.io.druid.data.input.impl.StringDimensionSchema;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type", defaultImpl=StringDimensionSchema.class)
@JsonSubTypes(value={@JsonSubTypes.Type(name="string", value=StringDimensionSchema.class), @JsonSubTypes.Type(name="long", value=LongDimensionSchema.class), @JsonSubTypes.Type(name="float", value=FloatDimensionSchema.class), @JsonSubTypes.Type(name="double", value=DoubleDimensionSchema.class), @JsonSubTypes.Type(name="spatial", value=NewSpatialDimensionSchema.class)})
public abstract class DimensionSchema {
    public static final String STRING_TYPE_NAME = "string";
    public static final String LONG_TYPE_NAME = "long";
    public static final String FLOAT_TYPE_NAME = "float";
    public static final String SPATIAL_TYPE_NAME = "spatial";
    public static final String DOUBLE_TYPE_NAME = "double";
    private final String name;
    private final MultiValueHandling multiValueHandling;

    protected DimensionSchema(String name, MultiValueHandling multiValueHandling) {
        this.name = Preconditions.checkNotNull(name, "Dimension name cannot be null.");
        this.multiValueHandling = multiValueHandling == null ? MultiValueHandling.ofDefault() : multiValueHandling;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public MultiValueHandling getMultiValueHandling() {
        return this.multiValueHandling;
    }

    @JsonIgnore
    public abstract String getTypeName();

    @JsonIgnore
    public abstract ValueType getValueType();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DimensionSchema that = (DimensionSchema)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!this.getValueType().equals((Object)that.getValueType())) {
            return false;
        }
        return Objects.equals((Object)this.multiValueHandling, (Object)that.multiValueHandling);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.getValueType(), this.multiValueHandling});
    }

    public String toString() {
        return "DimensionSchema{name='" + this.name + "', valueType='" + (Object)((Object)this.getValueType()) + "', multiValueHandling='" + (Object)((Object)this.getMultiValueHandling()) + "'}";
    }

    public static enum MultiValueHandling {
        SORTED_ARRAY,
        SORTED_SET,
        ARRAY{

            @Override
            public boolean needSorting() {
                return false;
            }
        };


        public boolean needSorting() {
            return true;
        }

        @JsonValue
        public String toString() {
            return StringUtils.toUpperCase(this.name());
        }

        @JsonCreator
        public static MultiValueHandling fromString(String name) {
            return name == null ? MultiValueHandling.ofDefault() : MultiValueHandling.valueOf(StringUtils.toUpperCase(name));
        }

        public static MultiValueHandling ofDefault() {
            return SORTED_ARRAY;
        }
    }

    public static enum ValueType {
        FLOAT,
        LONG,
        STRING,
        DOUBLE,
        COMPLEX;


        @JsonValue
        public String toString() {
            return StringUtils.toUpperCase(this.name());
        }

        @JsonCreator
        public static ValueType fromString(String name) {
            return ValueType.valueOf(StringUtils.toUpperCase(name));
        }
    }
}

