/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.curator.discovery;

import com.google.inject.Inject;
import java.util.Map;
import org.apache.curator.x.discovery.ServiceDiscovery;
import org.apache.curator.x.discovery.ServiceInstance;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.io.druid.curator.discovery.CuratorServiceUtils;
import org.apache.hive.druid.io.druid.curator.discovery.ServiceAnnouncer;
import org.apache.hive.druid.io.druid.java.util.emitter.EmittingLogger;
import org.apache.hive.druid.io.druid.server.DruidNode;

@Deprecated
public class CuratorServiceAnnouncer
implements ServiceAnnouncer {
    private static final EmittingLogger log = new EmittingLogger(CuratorServiceAnnouncer.class);
    private final ServiceDiscovery<Void> discovery;
    private final Map<String, ServiceInstance<Void>> instanceMap = Maps.newHashMap();
    private final Object monitor = new Object();

    @Inject
    public CuratorServiceAnnouncer(ServiceDiscovery<Void> discovery) {
        this.discovery = discovery;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void announce(DruidNode service) {
        ServiceInstance instance;
        String serviceName = CuratorServiceUtils.makeCanonicalServiceName(service.getServiceName());
        Object object = this.monitor;
        synchronized (object) {
            if (this.instanceMap.containsKey(serviceName)) {
                log.warn("Ignoring request to announce service[%s]", service);
                return;
            }
            try {
                instance = ServiceInstance.builder().name(serviceName).address(service.getHost()).port(service.getPlaintextPort()).sslPort(service.getTlsPort()).build();
            }
            catch (Exception e) {
                throw Throwables.propagate(e);
            }
            this.instanceMap.put(serviceName, (ServiceInstance<Void>)instance);
        }
        try {
            log.info("Announcing service[%s]", service);
            this.discovery.registerService(instance);
        }
        catch (Exception e) {
            log.warn("Failed to announce service[%s]", service);
            Object object2 = this.monitor;
            synchronized (object2) {
                this.instanceMap.remove(serviceName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unannounce(DruidNode service) {
        ServiceInstance<Void> instance;
        String serviceName = CuratorServiceUtils.makeCanonicalServiceName(service.getServiceName());
        Object object = this.monitor;
        synchronized (object) {
            instance = this.instanceMap.get(serviceName);
            if (instance == null) {
                log.warn("Ignoring request to unannounce service[%s]", service);
                return;
            }
        }
        log.info("Unannouncing service[%s]", service);
        try {
            this.discovery.unregisterService(instance);
        }
        catch (Exception e) {
            log.makeAlert(e, "Failed to unannounce service[%s], zombie znode perhaps in existence.", serviceName).addData("service", service).emit();
        }
        finally {
            Object object2 = this.monitor;
            synchronized (object2) {
                this.instanceMap.remove(serviceName);
            }
        }
    }
}

