/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.curator.discovery;

import com.google.inject.Inject;
import org.apache.curator.utils.ZKPaths;
import org.apache.hive.druid.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.io.druid.curator.announcement.Announcer;
import org.apache.hive.druid.io.druid.discovery.DiscoveryDruidNode;
import org.apache.hive.druid.io.druid.discovery.DruidNodeAnnouncer;
import org.apache.hive.druid.io.druid.guice.annotations.Json;
import org.apache.hive.druid.io.druid.java.util.common.logger.Logger;
import org.apache.hive.druid.io.druid.server.initialization.ZkPathsConfig;

public class CuratorDruidNodeAnnouncer
implements DruidNodeAnnouncer {
    private static final Logger log = new Logger(CuratorDruidNodeAnnouncer.class);
    private final Announcer announcer;
    private final ZkPathsConfig config;
    private final ObjectMapper jsonMapper;

    @Inject
    public CuratorDruidNodeAnnouncer(Announcer announcer, ZkPathsConfig config, @Json ObjectMapper jsonMapper) {
        this.announcer = announcer;
        this.config = config;
        this.jsonMapper = jsonMapper;
    }

    @Override
    public void announce(DiscoveryDruidNode discoveryDruidNode) {
        try {
            log.info("Announcing [%s].", discoveryDruidNode);
            this.announcer.announce(ZKPaths.makePath((String)this.config.getInternalDiscoveryPath(), (String)discoveryDruidNode.getNodeType(), (String[])new String[]{discoveryDruidNode.getDruidNode().getHostAndPortToUse()}), this.jsonMapper.writeValueAsBytes(discoveryDruidNode));
            log.info("Announced [%s].", discoveryDruidNode);
        }
        catch (JsonProcessingException e) {
            throw Throwables.propagate(e);
        }
    }

    @Override
    public void unannounce(DiscoveryDruidNode discoveryDruidNode) {
        log.info("Unannouncing [%s].", discoveryDruidNode);
        this.announcer.unannounce(ZKPaths.makePath((String)this.config.getInternalDiscoveryPath(), (String)discoveryDruidNode.getNodeType(), (String[])new String[]{discoveryDruidNode.getDruidNode().getHostAndPortToUse()}));
        log.info("Unannounced [%s].", discoveryDruidNode);
    }
}

