/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.concurrent;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;

public final class LifecycleLock {
    private final Sync sync = new Sync();

    public boolean canStart() {
        return this.sync.canStart();
    }

    public void started() {
        this.sync.started();
    }

    public void exitStart() {
        this.sync.exitStart();
    }

    public boolean isStarted() {
        return this.sync.isStarted();
    }

    public boolean awaitStarted() {
        return this.sync.awaitStarted();
    }

    public boolean awaitStarted(long timeout, TimeUnit unit) {
        return this.sync.awaitStarted(unit.toNanos(timeout));
    }

    public boolean canStop() {
        return this.sync.canStop();
    }

    public void exitStop() {
        this.sync.exitStop();
    }

    public void reset() {
        this.sync.reset();
    }

    private static class Sync
    extends AbstractQueuedSynchronizer {
        private static final int NOT_STARTED = 0;
        private static final int STARTING = 1;
        private static final int STARTED = 2;
        private static final int START_EXITED_SUCCESSFUL = 3;
        private static final int START_EXITED_FAIL = 4;
        private static final int STOPPING = 5;
        private static final int STOPPED = 6;

        private Sync() {
        }

        boolean canStart() {
            return this.compareAndSetState(0, 1);
        }

        void started() {
            if (!this.compareAndSetState(1, 2)) {
                throw new IllegalMonitorStateException("Called started() not in the context of start()");
            }
        }

        void exitStart() {
            this.releaseShared(1);
        }

        @Override
        protected boolean tryReleaseShared(int ignore) {
            block2: {
                while (true) {
                    int state;
                    if ((state = this.getState()) == 1) {
                        if (!this.compareAndSetState(1, 4)) continue;
                        return true;
                    }
                    if (state != 2) break block2;
                    if (this.compareAndSetState(2, 3)) break;
                }
                return true;
            }
            throw new IllegalMonitorStateException("exitStart() called not in the end of the start() method");
        }

        boolean isStarted() {
            return this.getState() == 3;
        }

        boolean awaitStarted() {
            try {
                this.acquireSharedInterruptibly(1);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            return this.isStarted();
        }

        boolean awaitStarted(long timeNanos) {
            try {
                if (!this.tryAcquireSharedNanos(1, timeNanos)) {
                    return false;
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            return this.isStarted();
        }

        @Override
        protected int tryAcquireShared(int ignore) {
            return this.getState() > 2 ? 1 : -1;
        }

        boolean canStop() {
            block2: {
                do {
                    int state;
                    if ((state = this.getState()) == 4 || state == 5) {
                        return false;
                    }
                    if (state != 3) break block2;
                } while (!this.compareAndSetState(3, 5));
                return true;
            }
            throw new IllegalMonitorStateException("Called canStop() before start()");
        }

        void exitStop() {
            if (!this.compareAndSetState(5, 6)) {
                throw new IllegalMonitorStateException("Called exitStop() not in the context of stop()");
            }
        }

        void reset() {
            if (!this.compareAndSetState(6, 0)) {
                throw new IllegalMonitorStateException("Not called exitStop() before reset()");
            }
        }
    }
}

