/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.common.utils;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.InvocationTargetException;
import org.apache.hive.druid.io.druid.java.util.common.UOE;

public class VMUtils {
    private static final ThreadMXBean THREAD_MX_BEAN = ManagementFactory.getThreadMXBean();

    public static boolean isThreadCpuTimeEnabled() {
        return THREAD_MX_BEAN.isThreadCpuTimeSupported() && THREAD_MX_BEAN.isThreadCpuTimeEnabled();
    }

    public static long safeGetThreadCpuTime() {
        if (!VMUtils.isThreadCpuTimeEnabled()) {
            return 0L;
        }
        return VMUtils.getCurrentThreadCpuTime();
    }

    public static long getCurrentThreadCpuTime() {
        return THREAD_MX_BEAN.getCurrentThreadCpuTime();
    }

    public static long getMaxDirectMemory() throws UnsupportedOperationException {
        try {
            Class<?> vmClass = Class.forName("sun.misc.VM");
            Object maxDirectMemoryObj = vmClass.getMethod("maxDirectMemory", new Class[0]).invoke(null, new Object[0]);
            if (maxDirectMemoryObj == null || !(maxDirectMemoryObj instanceof Number)) {
                throw new UOE("Cannot determine maxDirectMemory from [%s]", maxDirectMemoryObj);
            }
            return ((Number)maxDirectMemoryObj).longValue();
        }
        catch (ClassNotFoundException e) {
            throw new UnsupportedOperationException("No VM class, cannot do memory check.", e);
        }
        catch (NoSuchMethodException e) {
            throw new UnsupportedOperationException("VM.maxDirectMemory doesn't exist, cannot do memory check.", e);
        }
        catch (InvocationTargetException e) {
            throw new UnsupportedOperationException("static method shouldn't throw this", e);
        }
        catch (IllegalAccessException e) {
            throw new UnsupportedOperationException("public method, shouldn't throw this", e);
        }
    }
}

