/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.client.cache;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import net.spy.memcached.MemcachedClientIF;
import org.apache.hive.druid.com.google.common.annotations.VisibleForTesting;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.io.druid.collections.ResourceHolder;
import org.apache.hive.druid.io.druid.java.util.common.logger.Logger;
import sun.misc.Cleaner;

final class MemcacheClientPool
implements Supplier<ResourceHolder<MemcachedClientIF>> {
    private static final Logger log = new Logger(MemcacheClientPool.class);
    private static final AtomicLong leakedClients = new AtomicLong(0L);
    private final CountingHolder[] connections;

    public static long leakedClients() {
        return leakedClients.get();
    }

    MemcacheClientPool(int capacity, Supplier<MemcachedClientIF> generator) {
        Preconditions.checkArgument(capacity > 0, "capacity must be greater than 0");
        Preconditions.checkNotNull(generator);
        CountingHolder[] connections = new CountingHolder[capacity];
        for (int i = 0; i < capacity; ++i) {
            connections[i] = new CountingHolder(generator.get());
        }
        this.connections = connections;
    }

    @Override
    public synchronized IdempotentCloseableHolder get() {
        CountingHolder leastUsedClientHolder = this.connections[0];
        int minCount = leastUsedClientHolder.count.get();
        for (int i = 1; i < this.connections.length; ++i) {
            CountingHolder clientHolder = this.connections[i];
            int count = clientHolder.count.get();
            if (count >= minCount) continue;
            leastUsedClientHolder = clientHolder;
            minCount = count;
        }
        leastUsedClientHolder.count.incrementAndGet();
        return new IdempotentCloseableHolder(leastUsedClientHolder);
    }

    private static class ClientLeakNotifier
    implements Runnable {
        private final AtomicInteger count;
        private final MemcachedClientIF clientIF;

        private ClientLeakNotifier(AtomicInteger count, MemcachedClientIF clientIF) {
            this.count = count;
            this.clientIF = clientIF;
        }

        @Override
        public void run() {
            int shouldBeZero = this.count.get();
            if (shouldBeZero != 0) {
                leakedClients.incrementAndGet();
                log.warn("Expected 0 resource count, got [%d]! Object was[%s].", shouldBeZero, this.clientIF);
            }
        }
    }

    @VisibleForTesting
    static class IdempotentCloseableHolder
    implements ResourceHolder<MemcachedClientIF> {
        private CountingHolder countingHolder;

        private IdempotentCloseableHolder(CountingHolder countingHolder) {
            this.countingHolder = countingHolder;
        }

        @Override
        public MemcachedClientIF get() {
            return this.countingHolder.clientIF;
        }

        int count() {
            return this.countingHolder.count.get();
        }

        @Override
        public void close() {
            if (this.countingHolder != null) {
                this.countingHolder.count.decrementAndGet();
                this.countingHolder = null;
            }
        }
    }

    private static class CountingHolder {
        private final AtomicInteger count = new AtomicInteger(0);
        private final MemcachedClientIF clientIF;
        private final Cleaner cleaner;

        private CountingHolder(MemcachedClientIF clientIF) {
            this.clientIF = clientIF;
            this.cleaner = Cleaner.create((Object)this, (Runnable)new ClientLeakNotifier(this.count, clientIF));
        }
    }
}

