/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.com.metamx.common.parsers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Optional;
import org.apache.hive.druid.com.google.common.base.Splitter;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.metamx.common.collect.Utils;
import org.apache.hive.druid.com.metamx.common.parsers.ParseException;
import org.apache.hive.druid.com.metamx.common.parsers.Parser;
import org.apache.hive.druid.com.metamx.common.parsers.ParserUtils;

public class CSVParser
implements Parser<String, Object> {
    private final String listDelimiter;
    private final Splitter listSplitter;
    private final Function<String, Object> valueFunction;
    private final au.com.bytecode.opencsv.CSVParser parser = new au.com.bytecode.opencsv.CSVParser();
    private ArrayList<String> fieldNames = null;

    public CSVParser(Optional<String> listDelimiter) {
        this.listDelimiter = listDelimiter.isPresent() ? listDelimiter.get() : "\u0001";
        this.listSplitter = Splitter.on(this.listDelimiter);
        this.valueFunction = new Function<String, Object>(){

            @Override
            public Object apply(String input) {
                if (input.contains(CSVParser.this.listDelimiter)) {
                    return Lists.newArrayList(Iterables.transform(CSVParser.this.listSplitter.split(input), ParserUtils.nullEmptyStringFunction));
                }
                return ParserUtils.nullEmptyStringFunction.apply(input);
            }
        };
    }

    public CSVParser(Optional<String> listDelimiter, Iterable<String> fieldNames) {
        this(listDelimiter);
        this.setFieldNames(fieldNames);
    }

    public CSVParser(Optional<String> listDelimiter, String header) {
        this(listDelimiter);
        this.setFieldNames(header);
    }

    public String getListDelimiter() {
        return this.listDelimiter;
    }

    @Override
    public List<String> getFieldNames() {
        return this.fieldNames;
    }

    @Override
    public void setFieldNames(Iterable<String> fieldNames) {
        ParserUtils.validateFields(fieldNames);
        this.fieldNames = Lists.newArrayList(fieldNames);
    }

    public void setFieldNames(String header) {
        try {
            this.setFieldNames(Arrays.asList(this.parser.parseLine(header)));
        }
        catch (Exception e) {
            throw new ParseException(e, "Unable to parse header [%s]", header);
        }
    }

    @Override
    public Map<String, Object> parse(String input) {
        try {
            String[] values = this.parser.parseLine(input);
            if (this.fieldNames == null) {
                this.setFieldNames(ParserUtils.generateFieldNames(values.length));
            }
            return Utils.zipMapPartial(this.fieldNames, Iterables.transform(Lists.newArrayList(values), this.valueFunction));
        }
        catch (Exception e) {
            throw new ParseException(e, "Unable to parse row [%s]", input);
        }
    }
}

