/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.com.metamx.common;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.concurrent.Callable;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.hive.druid.com.google.common.base.Predicate;
import org.apache.hive.druid.com.google.common.base.Strings;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.com.google.common.io.ByteSink;
import org.apache.hive.druid.com.google.common.io.ByteSource;
import org.apache.hive.druid.com.google.common.io.ByteStreams;
import org.apache.hive.druid.com.google.common.io.FileWriteMode;
import org.apache.hive.druid.com.google.common.io.Files;
import org.apache.hive.druid.com.metamx.common.FileUtils;
import org.apache.hive.druid.com.metamx.common.IAE;
import org.apache.hive.druid.com.metamx.common.ISE;
import org.apache.hive.druid.com.metamx.common.RetryUtils;
import org.apache.hive.druid.com.metamx.common.StreamUtils;
import org.apache.hive.druid.com.metamx.common.logger.Logger;

public class CompressionUtils {
    private static final Logger log = new Logger(CompressionUtils.class);
    private static final int DEFAULT_RETRY_COUNT = 3;
    public static final String GZ_SUFFIX = ".gz";
    public static final String ZIP_SUFFIX = ".zip";

    public static long zip(File directory, File outputZipFile) throws IOException {
        if (!CompressionUtils.isZip(outputZipFile.getName())) {
            log.warn("No .zip suffix[%s], putting files from [%s] into it anyway.", outputZipFile, directory);
        }
        try (FileOutputStream out = new FileOutputStream(outputZipFile);){
            long l = CompressionUtils.zip(directory, out);
            return l;
        }
    }

    public static long zip(File directory, OutputStream out) throws IOException {
        if (!directory.isDirectory()) {
            throw new IOException(String.format("directory[%s] is not a directory", directory));
        }
        File[] files = directory.listFiles();
        long totalSize = 0L;
        try (ZipOutputStream zipOut = new ZipOutputStream(out);){
            for (File file : files) {
                log.info("Adding file[%s] with size[%,d].  Total size so far[%,d]", file, file.length(), totalSize);
                if (file.length() >= Integer.MAX_VALUE) {
                    zipOut.finish();
                    throw new IOException(String.format("file[%s] too large [%,d]", file, file.length()));
                }
                zipOut.putNextEntry(new ZipEntry(file.getName()));
                totalSize += Files.asByteSource(file).copyTo(zipOut);
            }
            zipOut.closeEntry();
            zipOut.flush();
        }
        return totalSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileUtils.FileCopyResult unzip(final ByteSource byteSource, final File outDir, Predicate<Throwable> shouldRetry, boolean cacheLocally) throws IOException {
        FileUtils.FileCopyResult fileCopyResult;
        block6: {
            if (!cacheLocally) {
                try {
                    return RetryUtils.retry(new Callable<FileUtils.FileCopyResult>(){

                        @Override
                        public FileUtils.FileCopyResult call() throws Exception {
                            return CompressionUtils.unzip(byteSource.openStream(), outDir);
                        }
                    }, shouldRetry, 3);
                }
                catch (Exception e) {
                    throw Throwables.propagate(e);
                }
            }
            File tmpFile = File.createTempFile("compressionUtilZipCache", ZIP_SUFFIX);
            try {
                FileUtils.retryCopy(byteSource, tmpFile, shouldRetry, 3);
                fileCopyResult = CompressionUtils.unzip(tmpFile, outDir);
                if (tmpFile.delete()) break block6;
            }
            catch (Throwable throwable) {
                if (!tmpFile.delete()) {
                    log.warn("Could not delete zip cache at [%s]", tmpFile.toString());
                }
                throw throwable;
            }
            log.warn("Could not delete zip cache at [%s]", tmpFile.toString());
        }
        return fileCopyResult;
    }

    public static FileUtils.FileCopyResult unzip(ByteSource byteSource, File outDir, boolean cacheLocally) throws IOException {
        return CompressionUtils.unzip(byteSource, outDir, FileUtils.IS_EXCEPTION, cacheLocally);
    }

    public static FileUtils.FileCopyResult unzip(File pulledFile, File outDir) throws IOException {
        if (!outDir.exists() || !outDir.isDirectory()) {
            throw new ISE("outDir[%s] must exist and be a directory", outDir);
        }
        log.info("Unzipping file[%s] to [%s]", pulledFile, outDir);
        FileUtils.FileCopyResult result = new FileUtils.FileCopyResult(new File[0]);
        try (final ZipFile zipFile = new ZipFile(pulledFile);){
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                final ZipEntry entry = enumeration.nextElement();
                result.addFiles(FileUtils.retryCopy(new ByteSource(){

                    @Override
                    public InputStream openStream() throws IOException {
                        return new BufferedInputStream(zipFile.getInputStream(entry));
                    }
                }, new File(outDir, entry.getName()), FileUtils.IS_EXCEPTION, 3).getFiles());
            }
        }
        return result;
    }

    public static FileUtils.FileCopyResult unzip(InputStream in, File outDir) throws IOException {
        try (ZipInputStream zipIn = new ZipInputStream(in);){
            ZipEntry entry;
            FileUtils.FileCopyResult result = new FileUtils.FileCopyResult(new File[0]);
            while ((entry = zipIn.getNextEntry()) != null) {
                File file = new File(outDir, entry.getName());
                Files.asByteSink(file, new FileWriteMode[0]).writeFrom(zipIn);
                result.addFile(file);
                zipIn.closeEntry();
            }
            FileUtils.FileCopyResult fileCopyResult = result;
            return fileCopyResult;
        }
    }

    public static FileUtils.FileCopyResult gunzip(File pulledFile, File outFile) throws IOException {
        return CompressionUtils.gunzip(Files.asByteSource(pulledFile), outFile);
    }

    public static FileUtils.FileCopyResult gunzip(InputStream in, File outFile) throws IOException {
        try (GZIPInputStream gzipInputStream = CompressionUtils.gzipInputStream(in);){
            Files.asByteSink(outFile, new FileWriteMode[0]).writeFrom(gzipInputStream);
            FileUtils.FileCopyResult fileCopyResult = new FileUtils.FileCopyResult(outFile);
            return fileCopyResult;
        }
    }

    public static GZIPInputStream gzipInputStream(InputStream in) throws IOException {
        return new GZIPInputStream(new FilterInputStream(in){

            @Override
            public int available() throws IOException {
                int otherAvailable = super.available();
                return otherAvailable == 0 ? 1024 : otherAvailable;
            }
        });
    }

    /*
     * Loose catch block
     */
    public static long gunzip(InputStream in, OutputStream out) throws IOException {
        try {
            try (GZIPInputStream gzipInputStream = CompressionUtils.gzipInputStream(in);){
                long result = ByteStreams.copy(gzipInputStream, out);
                out.flush();
                long l = result;
                return l;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            out.close();
        }
    }

    public static FileUtils.FileCopyResult gunzip(final ByteSource in, File outFile, Predicate<Throwable> shouldRetry) {
        return FileUtils.retryCopy(new ByteSource(){

            @Override
            public InputStream openStream() throws IOException {
                return CompressionUtils.gzipInputStream(in.openStream());
            }
        }, outFile, shouldRetry, 3);
    }

    public static FileUtils.FileCopyResult gunzip(ByteSource in, File outFile) {
        return CompressionUtils.gunzip(in, outFile, FileUtils.IS_EXCEPTION);
    }

    /*
     * Loose catch block
     */
    public static long gzip(InputStream inputStream, OutputStream out) throws IOException {
        try {
            try (GZIPOutputStream outputStream = new GZIPOutputStream(out);){
                long result = ByteStreams.copy(inputStream, outputStream);
                out.flush();
                long l = result;
                return l;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            inputStream.close();
        }
    }

    public static FileUtils.FileCopyResult gzip(File inFile, File outFile, Predicate<Throwable> shouldRetry) throws IOException {
        CompressionUtils.gzip(Files.asByteSource(inFile), Files.asByteSink(outFile, new FileWriteMode[0]), shouldRetry);
        return new FileUtils.FileCopyResult(outFile);
    }

    public static long gzip(ByteSource in, final ByteSink out, Predicate<Throwable> shouldRetry) throws IOException {
        return StreamUtils.retryCopy(in, new ByteSink(){

            @Override
            public OutputStream openStream() throws IOException {
                return new GZIPOutputStream(out.openStream());
            }
        }, shouldRetry, 3);
    }

    public static FileUtils.FileCopyResult gzip(File inFile, File outFile) throws IOException {
        return CompressionUtils.gzip(inFile, outFile, FileUtils.IS_EXCEPTION);
    }

    public static boolean isZip(String fName) {
        if (Strings.isNullOrEmpty(fName)) {
            return false;
        }
        return fName.endsWith(ZIP_SUFFIX);
    }

    public static boolean isGz(String fName) {
        if (Strings.isNullOrEmpty(fName)) {
            return false;
        }
        return fName.endsWith(GZ_SUFFIX) && fName.length() > GZ_SUFFIX.length();
    }

    public static String getGzBaseName(String fname) {
        String reducedFname = Files.getNameWithoutExtension(fname);
        if (CompressionUtils.isGz(fname) && !reducedFname.isEmpty()) {
            return reducedFname;
        }
        throw new IAE("[%s] is not a valid gz file name", fname);
    }
}

