/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.com.fasterxml.jackson.datatype.joda.ser;

import java.io.IOException;
import java.lang.reflect.Type;
import org.apache.hive.druid.com.fasterxml.jackson.core.JsonGenerationException;
import org.apache.hive.druid.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.hive.druid.com.fasterxml.jackson.databind.JsonNode;
import org.apache.hive.druid.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.hive.druid.com.fasterxml.jackson.datatype.joda.ser.JacksonJodaFormat;
import org.apache.hive.druid.com.fasterxml.jackson.datatype.joda.ser.JodaDateSerializerBase;
import org.joda.time.DateMidnight;
import org.joda.time.ReadableInstant;

public final class DateMidnightSerializer
extends JodaDateSerializerBase<DateMidnight> {
    protected static final JacksonJodaFormat DEFAULT_FORMAT = new JacksonJodaFormat(DEFAULT_DATEONLY_FORMAT);

    public DateMidnightSerializer() {
        this(DEFAULT_FORMAT);
    }

    public DateMidnightSerializer(JacksonJodaFormat format) {
        super(DateMidnight.class, format);
    }

    public DateMidnightSerializer withFormat(JacksonJodaFormat formatter) {
        return this._format == formatter ? this : new DateMidnightSerializer(this._format);
    }

    @Override
    public void serialize(DateMidnight value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        if (this._useTimestamp(provider)) {
            jgen.writeStartArray();
            jgen.writeNumber(value.year().get());
            jgen.writeNumber(value.monthOfYear().get());
            jgen.writeNumber(value.dayOfMonth().get());
            jgen.writeEndArray();
        } else {
            jgen.writeString(this._format.createFormatter(provider).print((ReadableInstant)value));
        }
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        return this.createSchemaNode(this._useTimestamp(provider) ? "array" : "string", true);
    }
}

