/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.druid.security;

import org.apache.hadoop.hive.druid.security.RetryResponseHolder;
import org.apache.hive.druid.com.metamx.http.client.response.ClientResponse;
import org.apache.hive.druid.com.metamx.http.client.response.HttpResponseHandler;
import org.apache.hive.druid.org.jboss.netty.handler.codec.http.HttpChunk;
import org.apache.hive.druid.org.jboss.netty.handler.codec.http.HttpResponse;
import org.apache.hive.druid.org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryIfUnauthorizedResponseHandler<Intermediate, Final>
implements HttpResponseHandler<RetryResponseHolder<Intermediate>, RetryResponseHolder<Final>> {
    protected static final Logger log = LoggerFactory.getLogger(RetryIfUnauthorizedResponseHandler.class);
    private final HttpResponseHandler<Intermediate, Final> httpResponseHandler;

    public RetryIfUnauthorizedResponseHandler(HttpResponseHandler<Intermediate, Final> httpResponseHandler) {
        this.httpResponseHandler = httpResponseHandler;
    }

    @Override
    public ClientResponse<RetryResponseHolder<Intermediate>> handleResponse(HttpResponse httpResponse) {
        log.debug("UnauthorizedResponseHandler - Got response status {}", (Object)httpResponse.getStatus());
        if (httpResponse.getStatus().equals(HttpResponseStatus.UNAUTHORIZED)) {
            httpResponse.getContent().toString();
            return ClientResponse.unfinished(RetryResponseHolder.retry());
        }
        return this.wrap(this.httpResponseHandler.handleResponse(httpResponse));
    }

    @Override
    public ClientResponse<RetryResponseHolder<Intermediate>> handleChunk(ClientResponse<RetryResponseHolder<Intermediate>> clientResponse, HttpChunk httpChunk) {
        if (clientResponse.getObj().shouldRetry()) {
            httpChunk.getContent().toString();
            return clientResponse;
        }
        return this.wrap(this.httpResponseHandler.handleChunk(this.unwrap(clientResponse), httpChunk));
    }

    @Override
    public ClientResponse<RetryResponseHolder<Final>> done(ClientResponse<RetryResponseHolder<Intermediate>> clientResponse) {
        if (clientResponse.getObj().shouldRetry()) {
            return ClientResponse.finished(RetryResponseHolder.retry());
        }
        return this.wrap(this.httpResponseHandler.done(this.unwrap(clientResponse)));
    }

    @Override
    public void exceptionCaught(ClientResponse<RetryResponseHolder<Intermediate>> clientResponse, Throwable throwable) {
        this.httpResponseHandler.exceptionCaught(this.unwrap(clientResponse), throwable);
    }

    private <T> ClientResponse<RetryResponseHolder<T>> wrap(ClientResponse<T> response) {
        if (response.isFinished()) {
            return ClientResponse.finished(new RetryResponseHolder<T>(false, response.getObj()));
        }
        return ClientResponse.unfinished(new RetryResponseHolder<T>(false, response.getObj()));
    }

    private <T> ClientResponse<T> unwrap(ClientResponse<RetryResponseHolder<T>> response) {
        if (response.isFinished()) {
            return ClientResponse.finished(response.getObj().getObj());
        }
        return ClientResponse.unfinished(response.getObj().getObj());
    }
}

