/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.druid.security;

import java.net.CookieManager;
import java.net.URI;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.druid.security.DruidKerberosUtil;
import org.apache.hadoop.hive.druid.security.ResponseCookieHandler;
import org.apache.hadoop.hive.druid.security.RetryIfUnauthorizedResponseHandler;
import org.apache.hadoop.hive.druid.security.RetryResponseHolder;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.com.google.common.util.concurrent.ListenableFuture;
import org.apache.hive.druid.com.google.common.util.concurrent.SettableFuture;
import org.apache.hive.druid.com.metamx.http.client.AbstractHttpClient;
import org.apache.hive.druid.com.metamx.http.client.HttpClient;
import org.apache.hive.druid.com.metamx.http.client.Request;
import org.apache.hive.druid.com.metamx.http.client.response.HttpResponseHandler;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerberosHttpClient
extends AbstractHttpClient {
    protected static final Logger log = LoggerFactory.getLogger(KerberosHttpClient.class);
    private final HttpClient delegate;
    private final CookieManager cookieManager;

    public KerberosHttpClient(HttpClient delegate) {
        this.delegate = delegate;
        this.cookieManager = new CookieManager();
    }

    @Override
    public <Intermediate, Final> ListenableFuture<Final> go(Request request, HttpResponseHandler<Intermediate, Final> httpResponseHandler, Duration duration) {
        SettableFuture retVal = SettableFuture.create();
        this.inner_go(request, httpResponseHandler, duration, retVal);
        return retVal;
    }

    private <Intermediate, Final> void inner_go(Request request, HttpResponseHandler<Intermediate, Final> httpResponseHandler, Duration duration, SettableFuture<Final> future) {
        try {
            boolean should_retry_on_unauthorized_response;
            final String host = request.getUrl().getHost();
            URI uri = request.getUrl().toURI();
            Map<String, List<String>> cookieMap = this.cookieManager.get(uri, Collections.emptyMap());
            for (Map.Entry<String, List<String>> entry : cookieMap.entrySet()) {
                request.addHeaderValues(entry.getKey(), (Iterable<String>)entry.getValue());
            }
            if (DruidKerberosUtil.needToSendCredentials(this.cookieManager.getCookieStore(), uri)) {
                log.debug("No Auth Cookie found for URI{}. Existing Cookies{} Authenticating... ", (Object)uri, this.cookieManager.getCookieStore().getCookies());
                UserGroupInformation currentUser = UserGroupInformation.getCurrentUser();
                currentUser.checkTGTAndReloginFromKeytab();
                log.debug("The user credential is {}", (Object)currentUser);
                String challenge = (String)currentUser.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<String>(){

                    @Override
                    public String run() throws Exception {
                        return DruidKerberosUtil.kerberosChallenge(host);
                    }
                });
                request.setHeader("Authorization", "Negotiate " + challenge);
                should_retry_on_unauthorized_response = false;
            } else {
                log.debug("Found Auth Cookie found for URI {} cookie {}", (Object)uri, (Object)DruidKerberosUtil.getAuthCookie(this.cookieManager.getCookieStore(), uri).toString());
                should_retry_on_unauthorized_response = true;
            }
            ListenableFuture<Final> internalFuture = this.delegate.go(request, new RetryIfUnauthorizedResponseHandler<Intermediate, Final>(new ResponseCookieHandler<Intermediate, Final>(request.getUrl().toURI(), this.cookieManager, httpResponseHandler)), duration);
            RetryResponseHolder responseHolder = (RetryResponseHolder)internalFuture.get();
            if (should_retry_on_unauthorized_response && responseHolder.shouldRetry()) {
                log.debug("Preparing for Retry boolean {} and result {}, object{} ", new Object[]{should_retry_on_unauthorized_response, responseHolder.shouldRetry(), responseHolder.getObj()});
                DruidKerberosUtil.removeAuthCookie(this.cookieManager.getCookieStore(), uri);
                request.setHeader("Cookie", "");
                this.inner_go(request.copy(), httpResponseHandler, duration, future);
            } else {
                future.set(responseHolder.getObj());
            }
        }
        catch (Throwable e) {
            throw Throwables.propagate(e);
        }
    }
}

