/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.druid;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.TimeZone;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.druid.serde.HiveDruidSerializationModule;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.io.retry.RetryProxy;
import org.apache.hadoop.util.StringUtils;
import org.apache.hive.druid.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.hive.druid.com.fasterxml.jackson.databind.InjectableValues;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.fasterxml.jackson.databind.jsontype.NamedType;
import org.apache.hive.druid.com.fasterxml.jackson.dataformat.smile.SmileFactory;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.com.google.common.collect.ImmutableCollection;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Interner;
import org.apache.hive.druid.com.google.common.collect.Interners;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Ordering;
import org.apache.hive.druid.com.google.common.io.CharStreams;
import org.apache.hive.druid.com.metamx.common.JodaUtils;
import org.apache.hive.druid.com.metamx.common.MapUtils;
import org.apache.hive.druid.com.metamx.emitter.EmittingLogger;
import org.apache.hive.druid.com.metamx.emitter.core.NoopEmitter;
import org.apache.hive.druid.com.metamx.emitter.service.ServiceEmitter;
import org.apache.hive.druid.com.metamx.http.client.HttpClient;
import org.apache.hive.druid.com.metamx.http.client.Request;
import org.apache.hive.druid.com.metamx.http.client.response.InputStreamResponseHandler;
import org.apache.hive.druid.io.druid.data.input.impl.DimensionSchema;
import org.apache.hive.druid.io.druid.data.input.impl.StringDimensionSchema;
import org.apache.hive.druid.io.druid.jackson.DefaultObjectMapper;
import org.apache.hive.druid.io.druid.java.util.common.Pair;
import org.apache.hive.druid.io.druid.java.util.common.granularity.Granularity;
import org.apache.hive.druid.io.druid.math.expr.ExprMacroTable;
import org.apache.hive.druid.io.druid.metadata.MetadataStorageTablesConfig;
import org.apache.hive.druid.io.druid.metadata.SQLMetadataConnector;
import org.apache.hive.druid.io.druid.metadata.storage.mysql.MySQLConnector;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.DoubleSumAggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.FloatSumAggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.hive.druid.io.druid.query.expression.LikeExprMacro;
import org.apache.hive.druid.io.druid.query.expression.RegexpExtractExprMacro;
import org.apache.hive.druid.io.druid.query.expression.TimestampCeilExprMacro;
import org.apache.hive.druid.io.druid.query.expression.TimestampExtractExprMacro;
import org.apache.hive.druid.io.druid.query.expression.TimestampFloorExprMacro;
import org.apache.hive.druid.io.druid.query.expression.TimestampFormatExprMacro;
import org.apache.hive.druid.io.druid.query.expression.TimestampParseExprMacro;
import org.apache.hive.druid.io.druid.query.expression.TimestampShiftExprMacro;
import org.apache.hive.druid.io.druid.query.expression.TrimExprMacro;
import org.apache.hive.druid.io.druid.query.scan.ScanQuery;
import org.apache.hive.druid.io.druid.query.select.SelectQueryConfig;
import org.apache.hive.druid.io.druid.query.spec.MultipleIntervalSegmentSpec;
import org.apache.hive.druid.io.druid.segment.IndexIO;
import org.apache.hive.druid.io.druid.segment.IndexMergerV9;
import org.apache.hive.druid.io.druid.segment.IndexSpec;
import org.apache.hive.druid.io.druid.segment.data.ConciseBitmapSerdeFactory;
import org.apache.hive.druid.io.druid.segment.data.RoaringBitmapSerdeFactory;
import org.apache.hive.druid.io.druid.segment.indexing.granularity.GranularitySpec;
import org.apache.hive.druid.io.druid.segment.indexing.granularity.UniformGranularitySpec;
import org.apache.hive.druid.io.druid.segment.loading.DataSegmentPusher;
import org.apache.hive.druid.io.druid.segment.realtime.appenderator.SegmentIdentifier;
import org.apache.hive.druid.io.druid.segment.writeout.TmpFileSegmentWriteOutMediumFactory;
import org.apache.hive.druid.io.druid.storage.hdfs.HdfsDataSegmentPusher;
import org.apache.hive.druid.io.druid.storage.hdfs.HdfsDataSegmentPusherConfig;
import org.apache.hive.druid.io.druid.timeline.DataSegment;
import org.apache.hive.druid.io.druid.timeline.TimelineObjectHolder;
import org.apache.hive.druid.io.druid.timeline.VersionedIntervalTimeline;
import org.apache.hive.druid.io.druid.timeline.partition.LinearShardSpec;
import org.apache.hive.druid.io.druid.timeline.partition.NoneShardSpec;
import org.apache.hive.druid.io.druid.timeline.partition.NumberedShardSpec;
import org.apache.hive.druid.io.druid.timeline.partition.PartitionChunk;
import org.apache.hive.druid.io.druid.timeline.partition.ShardSpec;
import org.apache.hive.druid.org.jboss.netty.handler.codec.http.HttpMethod;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.chrono.ISOChronology;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.PreparedBatch;
import org.skife.jdbi.v2.Update;
import org.skife.jdbi.v2.exceptions.CallbackFailedException;
import org.skife.jdbi.v2.util.ByteArrayMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DruidStorageHandlerUtils {
    private static final Logger LOG = LoggerFactory.getLogger(DruidStorageHandlerUtils.class);
    private static final int NUM_RETRIES = 8;
    private static final int SECONDS_BETWEEN_RETRIES = 2;
    private static final int DEFAULT_FS_BUFFER_SIZE = 262144;
    private static final int DEFAULT_STREAMING_RESULT_SIZE = 100;
    private static final String SMILE_CONTENT_TYPE = "application/x-jackson-smile";
    public static final String DEFAULT_TIMESTAMP_COLUMN = "__time";
    public static final String EVENT_TIMESTAMP_COLUMN = "timestamp";
    public static final String INDEX_ZIP = "index.zip";
    public static final String DESCRIPTOR_JSON = "descriptor.json";
    public static final Interval DEFAULT_INTERVAL = new Interval((ReadableInstant)new DateTime((Object)"1900-01-01", (Chronology)ISOChronology.getInstanceUTC()), (ReadableInstant)new DateTime((Object)"3000-01-01", (Chronology)ISOChronology.getInstanceUTC())).withChronology((Chronology)ISOChronology.getInstanceUTC());
    public static final ObjectMapper JSON_MAPPER = new DefaultObjectMapper();
    public static final ObjectMapper SMILE_MAPPER = new DefaultObjectMapper(new SmileFactory());
    private static final int DEFAULT_MAX_TRIES = 10;
    public static final IndexIO INDEX_IO;
    public static final IndexMergerV9 INDEX_MERGER_V9;
    public static final Interner<DataSegment> DATA_SEGMENT_INTERNER;

    public static Request createSmileRequest(String address, Query query) throws IOException {
        return new Request(HttpMethod.POST, new URL(String.format("%s/druid/v2/", "http://" + address))).setContent(SMILE_MAPPER.writeValueAsBytes(query)).setHeader("Content-Type", SMILE_CONTENT_TYPE);
    }

    public static InputStream submitRequest(HttpClient client, Request request) throws IOException {
        InputStream response;
        try {
            response = (InputStream)client.go(request, new InputStreamResponseHandler()).get();
        }
        catch (ExecutionException e) {
            throw new IOException(e.getCause());
        }
        catch (InterruptedException e) {
            throw new IOException(e.getCause());
        }
        return response;
    }

    public static String getURL(HttpClient client, URL url) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(DruidStorageHandlerUtils.submitRequest(client, new Request(HttpMethod.GET, url)));){
            String string = CharStreams.toString(reader);
            return string;
        }
    }

    public static List<DataSegment> getCreatedSegments(Path taskDir, Configuration conf) throws IOException {
        FileStatus[] fss;
        ImmutableList.Builder publishedSegmentsBuilder = ImmutableList.builder();
        FileSystem fs = taskDir.getFileSystem(conf);
        for (FileStatus fileStatus : fss = fs.listStatus(taskDir)) {
            DataSegment segment = JSON_MAPPER.readValue((InputStream)fs.open(fileStatus.getPath()), DataSegment.class);
            publishedSegmentsBuilder.add(segment);
        }
        return publishedSegmentsBuilder.build();
    }

    public static void writeSegmentDescriptor(FileSystem outputFS, DataSegment segment, Path descriptorPath) throws IOException {
        DataPusher descriptorPusher = (DataPusher)RetryProxy.create(DataPusher.class, () -> {
            if (outputFS.exists(descriptorPath) && !outputFS.delete(descriptorPath, false)) {
                throw new IOException(String.format("Failed to delete descriptor at [%s]", descriptorPath));
            }
            try (FSDataOutputStream descriptorOut = outputFS.create(descriptorPath, true, 262144);){
                JSON_MAPPER.writeValue((OutputStream)descriptorOut, (Object)segment);
                descriptorOut.flush();
            }
            return -1L;
        }, (RetryPolicy)RetryPolicies.exponentialBackoffRetry((int)8, (long)2L, (TimeUnit)TimeUnit.SECONDS));
        descriptorPusher.push();
    }

    public static Collection<String> getAllDataSourceNames(SQLMetadataConnector connector, MetadataStorageTablesConfig metadataStorageTablesConfig) {
        return connector.getDBI().withHandle(handle -> handle.createQuery(String.format("SELECT DISTINCT(datasource) FROM %s WHERE used = true", metadataStorageTablesConfig.getSegmentsTable())).fold(Lists.newArrayList(), (druidDataSources, stringObjectMap, foldController, statementContext) -> {
            druidDataSources.add(MapUtils.getString(stringObjectMap, "datasource"));
            return druidDataSources;
        }));
    }

    public static boolean disableDataSource(SQLMetadataConnector connector, MetadataStorageTablesConfig metadataStorageTablesConfig, String dataSource) {
        try {
            if (!DruidStorageHandlerUtils.getAllDataSourceNames(connector, metadataStorageTablesConfig).contains(dataSource)) {
                LOG.warn("Cannot delete data source {}, does not exist", (Object)dataSource);
                return false;
            }
            connector.getDBI().withHandle(handle -> {
                DruidStorageHandlerUtils.disableDataSourceWithHandle(handle, metadataStorageTablesConfig, dataSource);
                return null;
            });
        }
        catch (Exception e) {
            LOG.error(String.format("Error removing dataSource %s", dataSource), (Throwable)e);
            return false;
        }
        return true;
    }

    public static List<DataSegment> publishSegmentsAndCommit(SQLMetadataConnector connector, MetadataStorageTablesConfig metadataStorageTablesConfig, String dataSource, List<DataSegment> segments, boolean overwrite, Configuration conf, DataSegmentPusher dataSegmentPusher) throws CallbackFailedException {
        return connector.getDBI().inTransaction((handle, transactionStatus) -> {
            VersionedIntervalTimeline<Object, Object> timeline;
            if (overwrite) {
                DruidStorageHandlerUtils.disableDataSourceWithHandle(handle, metadataStorageTablesConfig, dataSource);
                timeline = new VersionedIntervalTimeline(Ordering.natural());
            } else {
                if (segments.isEmpty()) {
                    return Collections.EMPTY_LIST;
                }
                Interval indexedInterval = JodaUtils.umbrellaInterval(Iterables.transform(segments, input -> input.getInterval()));
                LOG.info("Building timeline for umbrella Interval [{}]", (Object)indexedInterval);
                timeline = DruidStorageHandlerUtils.getTimelineForIntervalWithHandle(handle, dataSource, indexedInterval, metadataStorageTablesConfig);
            }
            ArrayList<DataSegment> finalSegmentsToPublish = Lists.newArrayList();
            for (DataSegment segment : segments) {
                String newVersion;
                ShardSpec newShardSpec;
                List<TimelineObjectHolder<Object, Object>> existingChunks = timeline.lookup(segment.getInterval());
                if (existingChunks.size() > 1) {
                    throw new IllegalStateException(String.format("Cannot allocate new segment for dataSource[%s], interval[%s], already have [%,d] chunks. Not possible to append new segment.", dataSource, segment.getInterval(), existingChunks.size()));
                }
                SegmentIdentifier max = null;
                if (!existingChunks.isEmpty()) {
                    TimelineObjectHolder<Object, Object> existingHolder = Iterables.getOnlyElement(existingChunks);
                    for (PartitionChunk<Object> partitionChunk : existingHolder.getObject()) {
                        if (max != null && max.getShardSpec().getPartitionNum() >= ((DataSegment)partitionChunk.getObject()).getShardSpec().getPartitionNum()) continue;
                        max = SegmentIdentifier.fromDataSegment((DataSegment)partitionChunk.getObject());
                    }
                }
                if (max == null) {
                    newShardSpec = segment.getShardSpec();
                    newVersion = segment.getVersion();
                } else {
                    newShardSpec = DruidStorageHandlerUtils.getNextPartitionShardSpec(max.getShardSpec());
                    newVersion = max.getVersion();
                }
                DataSegment publishedSegment = DruidStorageHandlerUtils.publishSegmentWithShardSpec(segment, newShardSpec, newVersion, DruidStorageHandlerUtils.getPath(segment).getFileSystem(conf), dataSegmentPusher);
                finalSegmentsToPublish.add(publishedSegment);
                timeline.add(publishedSegment.getInterval(), publishedSegment.getVersion(), publishedSegment.getShardSpec().createChunk(publishedSegment));
            }
            PreparedBatch batch = handle.prepareBatch(String.format("INSERT INTO %1$s (id, dataSource, created_date, start, \"end\", partitioned, version, used, payload) VALUES (:id, :dataSource, :created_date, :start, :end, :partitioned, :version, :used, :payload)", metadataStorageTablesConfig.getSegmentsTable()));
            for (DataSegment segment : finalSegmentsToPublish) {
                batch.add(new ImmutableMap.Builder<String, String>().put("id", segment.getIdentifier()).put("dataSource", segment.getDataSource()).put("created_date", new DateTime().toString()).put("start", segment.getInterval().getStart().toString()).put("end", segment.getInterval().getEnd().toString()).put("partitioned", (String)((Object)Boolean.valueOf(!(segment.getShardSpec() instanceof NoneShardSpec)))).put("version", segment.getVersion()).put("used", (String)((Object)Boolean.valueOf(true))).put("payload", (String)JSON_MAPPER.writeValueAsBytes(segment)).build());
                LOG.info("Published {}", (Object)segment.getIdentifier());
            }
            batch.execute();
            return finalSegmentsToPublish;
        });
    }

    public static void disableDataSourceWithHandle(Handle handle, MetadataStorageTablesConfig metadataStorageTablesConfig, String dataSource) {
        ((Update)handle.createStatement(String.format("UPDATE %s SET used=false WHERE dataSource = :dataSource", metadataStorageTablesConfig.getSegmentsTable())).bind("dataSource", dataSource)).execute();
    }

    public static List<DataSegment> getDataSegmentList(SQLMetadataConnector connector, MetadataStorageTablesConfig metadataStorageTablesConfig, String dataSource) {
        List segmentList = connector.retryTransaction((handle, status) -> ((org.skife.jdbi.v2.Query)handle.createQuery(String.format("SELECT payload FROM %s WHERE dataSource = :dataSource", metadataStorageTablesConfig.getSegmentsTable())).setFetchSize(DruidStorageHandlerUtils.getStreamingFetchSize(connector)).bind("dataSource", dataSource)).map(ByteArrayMapper.FIRST).fold(new ArrayList(), (accumulator, payload, control, ctx) -> {
            try {
                DataSegment segment = DATA_SEGMENT_INTERNER.intern(JSON_MAPPER.readValue((byte[])payload, DataSegment.class));
                accumulator.add(segment);
                return accumulator;
            }
            catch (Exception e) {
                throw new SQLException(e.toString());
            }
        }), 3, 10);
        return segmentList;
    }

    private static int getStreamingFetchSize(SQLMetadataConnector connector) {
        if (connector instanceof MySQLConnector) {
            return Integer.MIN_VALUE;
        }
        return 100;
    }

    public static Path makeSegmentDescriptorOutputPath(DataSegment pushedSegment, Path segmentsDescriptorDir) {
        return new Path(segmentsDescriptorDir, String.format("%s.json", pushedSegment.getIdentifier().replace(":", "")));
    }

    public static String createScanAllQuery(String dataSourceName) throws JsonProcessingException {
        ScanQuery.ScanQueryBuilder scanQueryBuilder = ScanQuery.newScanQueryBuilder();
        List<Interval> intervals = Arrays.asList(DEFAULT_INTERVAL);
        ScanQuery scanQuery = scanQueryBuilder.dataSource(dataSourceName).resultFormat("compactedList").intervals(new MultipleIntervalSegmentSpec(intervals)).build();
        return JSON_MAPPER.writeValueAsString(scanQuery);
    }

    public static void addDependencyJars(Configuration conf, Class<?> ... classes) throws IOException {
        LocalFileSystem localFs = FileSystem.getLocal((Configuration)conf);
        HashSet<String> jars = new HashSet<String>();
        jars.addAll(conf.getStringCollection("tmpjars"));
        for (Class<?> clazz : classes) {
            if (clazz == null) continue;
            String path = Utilities.jarFinderGetJar(clazz);
            if (path == null) {
                throw new RuntimeException("Could not find jar for class " + clazz + " in order to ship it to the cluster.");
            }
            if (!localFs.exists(new Path(path))) {
                throw new RuntimeException("Could not validate jar file " + path + " for class " + clazz);
            }
            jars.add(path.toString());
        }
        if (jars.isEmpty()) {
            return;
        }
        conf.set("tmpjars", StringUtils.arrayToString((String[])jars.toArray(new String[jars.size()])));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static VersionedIntervalTimeline<String, DataSegment> getTimelineForIntervalWithHandle(Handle handle, String dataSource, Interval interval, MetadataStorageTablesConfig dbTables) throws IOException {
        org.skife.jdbi.v2.Query sql = (org.skife.jdbi.v2.Query)((org.skife.jdbi.v2.Query)((org.skife.jdbi.v2.Query)handle.createQuery(String.format("SELECT payload FROM %s WHERE used = true AND dataSource = ? AND start <= ? AND \"end\" >= ?", dbTables.getSegmentsTable())).bind(0, dataSource)).bind(1, interval.getEnd().toString())).bind(2, interval.getStart().toString());
        VersionedIntervalTimeline<String, DataSegment> timeline = new VersionedIntervalTimeline<String, DataSegment>(Ordering.natural());
        try (Iterator dbSegments = sql.map(ByteArrayMapper.FIRST).iterator();){
            while (dbSegments.hasNext()) {
                byte[] payload = (byte[])dbSegments.next();
                DataSegment segment = JSON_MAPPER.readValue(payload, DataSegment.class);
                timeline.add(segment.getInterval(), segment.getVersion(), segment.getShardSpec().createChunk(segment));
            }
        }
        return timeline;
    }

    public static DataSegmentPusher createSegmentPusherForDirectory(String segmentDirectory, Configuration configuration) throws IOException {
        HdfsDataSegmentPusherConfig hdfsDataSegmentPusherConfig = new HdfsDataSegmentPusherConfig();
        hdfsDataSegmentPusherConfig.setStorageDirectory(segmentDirectory);
        return new HdfsDataSegmentPusher(hdfsDataSegmentPusherConfig, configuration, JSON_MAPPER);
    }

    public static DataSegment publishSegmentWithShardSpec(DataSegment segment, ShardSpec shardSpec, String version, FileSystem fs, DataSegmentPusher dataSegmentPusher) throws IOException {
        boolean retry = true;
        DataSegment.Builder dataSegmentBuilder = new DataSegment.Builder(segment).version(version);
        Path finalPath = null;
        while (retry) {
            retry = false;
            dataSegmentBuilder.shardSpec(shardSpec);
            Path intermediatePath = DruidStorageHandlerUtils.getPath(segment);
            finalPath = new Path(dataSegmentPusher.getPathForHadoop(), dataSegmentPusher.makeIndexPathName(dataSegmentBuilder.build(), INDEX_ZIP));
            fs.mkdirs(finalPath.getParent());
            if (fs.rename(intermediatePath, finalPath)) continue;
            if (fs.exists(finalPath)) {
                shardSpec = DruidStorageHandlerUtils.getNextPartitionShardSpec(shardSpec);
                retry = true;
                continue;
            }
            throw new IOException(String.format("Failed to rename intermediate segment[%s] to final segment[%s] is not present.", intermediatePath, finalPath));
        }
        DataSegment dataSegment = dataSegmentBuilder.loadSpec(dataSegmentPusher.makeLoadSpec(finalPath.toUri())).build();
        DruidStorageHandlerUtils.writeSegmentDescriptor(fs, dataSegment, new Path(finalPath.getParent(), DESCRIPTOR_JSON));
        return dataSegment;
    }

    private static ShardSpec getNextPartitionShardSpec(ShardSpec shardSpec) {
        if (shardSpec instanceof LinearShardSpec) {
            return new LinearShardSpec(shardSpec.getPartitionNum() + 1);
        }
        if (shardSpec instanceof NumberedShardSpec) {
            return new NumberedShardSpec(shardSpec.getPartitionNum(), ((NumberedShardSpec)shardSpec).getPartitions());
        }
        throw new IllegalStateException(String.format("Cannot expand shard spec [%s]", shardSpec));
    }

    public static Path getPath(DataSegment dataSegment) {
        return new Path(String.valueOf(dataSegment.getLoadSpec().get("path")));
    }

    public static GranularitySpec getGranularitySpec(Configuration configuration, Properties tableProperties) {
        String segmentGranularity = tableProperties.getProperty("druid.segment.granularity") != null ? tableProperties.getProperty("druid.segment.granularity") : HiveConf.getVar((Configuration)configuration, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_DRUID_INDEXING_GRANULARITY);
        return new UniformGranularitySpec(Granularity.fromString(segmentGranularity), Granularity.fromString(tableProperties.getProperty("druid.query.granularity") == null ? "NONE" : tableProperties.getProperty("druid.query.granularity")), null);
    }

    public static IndexSpec getIndexSpec(Configuration jc) {
        IndexSpec indexSpec = "concise".equals(HiveConf.getVar((Configuration)jc, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_DRUID_BITMAP_FACTORY_TYPE)) ? new IndexSpec(new ConciseBitmapSerdeFactory(), null, null, null) : new IndexSpec(new RoaringBitmapSerdeFactory(true), null, null, null);
        return indexSpec;
    }

    public static Pair<List<DimensionSchema>, AggregatorFactory[]> getDimensionsAndAggregates(Configuration jc, List<String> columnNames, List<TypeInfo> columnTypes) {
        ArrayList<StringDimensionSchema> dimensions = new ArrayList<StringDimensionSchema>();
        ImmutableList.Builder aggregatorFactoryBuilder = ImmutableList.builder();
        block8: for (int i = 0; i < columnTypes.size(); ++i) {
            AggregatorFactory af;
            PrimitiveObjectInspector.PrimitiveCategory primitiveCategory = ((PrimitiveTypeInfo)columnTypes.get(i)).getPrimitiveCategory();
            switch (primitiveCategory) {
                case BYTE: 
                case SHORT: 
                case INT: 
                case LONG: {
                    af = new LongSumAggregatorFactory(columnNames.get(i), columnNames.get(i));
                    break;
                }
                case FLOAT: {
                    af = new FloatSumAggregatorFactory(columnNames.get(i), columnNames.get(i));
                    break;
                }
                case DOUBLE: {
                    af = new DoubleSumAggregatorFactory(columnNames.get(i), columnNames.get(i));
                    break;
                }
                case DECIMAL: {
                    throw new UnsupportedOperationException(String.format("Druid does not support decimal column type cast column [%s] to double", columnNames.get(i)));
                }
                case TIMESTAMP: {
                    String tColumnName = columnNames.get(i);
                    if (tColumnName.equals("__time_granularity") || tColumnName.equals(DEFAULT_TIMESTAMP_COLUMN)) continue block8;
                    throw new IllegalArgumentException("Dimension " + tColumnName + " does not have STRING type: " + primitiveCategory);
                }
                case TIMESTAMPLOCALTZ: {
                    String tLocalTZColumnName = columnNames.get(i);
                    if (tLocalTZColumnName.equals(DEFAULT_TIMESTAMP_COLUMN)) continue block8;
                    throw new IllegalArgumentException("Dimension " + tLocalTZColumnName + " does not have STRING type: " + primitiveCategory);
                }
                default: {
                    String dColumnName = columnNames.get(i);
                    if (PrimitiveObjectInspectorUtils.getPrimitiveGrouping((PrimitiveObjectInspector.PrimitiveCategory)primitiveCategory) != PrimitiveObjectInspectorUtils.PrimitiveGrouping.STRING_GROUP && primitiveCategory != PrimitiveObjectInspector.PrimitiveCategory.BOOLEAN) {
                        throw new IllegalArgumentException("Dimension " + dColumnName + " does not have STRING type: " + primitiveCategory);
                    }
                    dimensions.add(new StringDimensionSchema(dColumnName));
                    continue block8;
                }
            }
            aggregatorFactoryBuilder.add(af);
        }
        ImmutableCollection aggregatorFactories = aggregatorFactoryBuilder.build();
        return Pair.of(dimensions, aggregatorFactories.toArray(new AggregatorFactory[aggregatorFactories.size()]));
    }

    static {
        InjectableValues.Std injectableValues = new InjectableValues.Std().addValue(SelectQueryConfig.class, (Object)new SelectQueryConfig(false)).addValue(ExprMacroTable.class, (Object)new ExprMacroTable(ImmutableList.of(new LikeExprMacro(), new RegexpExtractExprMacro(), new TimestampCeilExprMacro(), new TimestampExtractExprMacro(), new TimestampFormatExprMacro(), new TimestampParseExprMacro(), new TimestampShiftExprMacro(), new TimestampFloorExprMacro(), new TrimExprMacro.BothTrimExprMacro(), new TrimExprMacro.LeftTrimExprMacro(), new TrimExprMacro.RightTrimExprMacro()))).addValue(ObjectMapper.class, (Object)JSON_MAPPER).addValue(DataSegment.PruneLoadSpecHolder.class, (Object)DataSegment.PruneLoadSpecHolder.DEFAULT);
        JSON_MAPPER.setInjectableValues(injectableValues);
        SMILE_MAPPER.setInjectableValues(injectableValues);
        HiveDruidSerializationModule hiveDruidSerializationModule = new HiveDruidSerializationModule();
        JSON_MAPPER.registerModule(hiveDruidSerializationModule);
        SMILE_MAPPER.registerModule(hiveDruidSerializationModule);
        JSON_MAPPER.registerSubtypes(new NamedType(LinearShardSpec.class, "linear"));
        JSON_MAPPER.registerSubtypes(new NamedType(NumberedShardSpec.class, "numbered"));
        JSON_MAPPER.setTimeZone(TimeZone.getTimeZone("UTC"));
        try {
            EmittingLogger.registerEmitter(new ServiceEmitter("druid-hive-indexer", InetAddress.getLocalHost().getHostName(), new NoopEmitter()));
        }
        catch (UnknownHostException e) {
            throw Throwables.propagate(e);
        }
        INDEX_IO = new IndexIO(JSON_MAPPER, TmpFileSegmentWriteOutMediumFactory.instance(), () -> 0);
        INDEX_MERGER_V9 = new IndexMergerV9(JSON_MAPPER, INDEX_IO, TmpFileSegmentWriteOutMediumFactory.instance());
        DATA_SEGMENT_INTERNER = Interners.newWeakInterner();
    }

    public static interface DataPusher {
        public long push() throws IOException;
    }
}

