/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.druid;

import org.apache.hadoop.hive.druid.json.KafkaSupervisorReport;
import org.apache.hadoop.hive.ql.metadata.StorageHandlerInfo;

public class DruidStorageHandlerInfo
implements StorageHandlerInfo {
    public static final StorageHandlerInfo UNREACHABLE = new StorageHandlerInfo(){

        public String formatAsText() {
            return "Druid Overlord is Unreachable, Runtime Status : unknown";
        }
    };
    private final KafkaSupervisorReport kafkaSupervisorReport;

    DruidStorageHandlerInfo(KafkaSupervisorReport kafkaSupervisorReport) {
        this.kafkaSupervisorReport = kafkaSupervisorReport;
    }

    public String formatAsText() {
        StringBuilder sb = new StringBuilder();
        sb.append("Druid Storage Handler Runtime Status for " + this.kafkaSupervisorReport.getId());
        sb.append("\n");
        sb.append("kafkaPartitions=" + this.kafkaSupervisorReport.getPayload().getPartitions());
        sb.append("\n");
        sb.append("activeTasks=" + this.kafkaSupervisorReport.getPayload().getActiveTasks());
        sb.append("\n");
        sb.append("publishingTasks=" + this.kafkaSupervisorReport.getPayload().getPublishingTasks());
        if (this.kafkaSupervisorReport.getPayload().getLatestOffsets() != null) {
            sb.append("\n");
            sb.append("latestOffsets=" + this.kafkaSupervisorReport.getPayload().getLatestOffsets());
        }
        if (this.kafkaSupervisorReport.getPayload().getMinimumLag() != null) {
            sb.append("\n");
            sb.append("minimumLag=" + this.kafkaSupervisorReport.getPayload().getMinimumLag());
        }
        if (this.kafkaSupervisorReport.getPayload().getAggregateLag() != null) {
            sb.append("\n");
            sb.append("aggregateLag=" + this.kafkaSupervisorReport.getPayload().getAggregateLag());
        }
        if (this.kafkaSupervisorReport.getPayload().getOffsetsLastUpdated() != null) {
            sb.append("\n");
            sb.append("lastUpdateTime=" + this.kafkaSupervisorReport.getPayload().getOffsetsLastUpdated());
        }
        return sb.toString();
    }
}

