/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.coordinator.helper;

import com.google.inject.Inject;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hive.druid.io.druid.client.indexing.IndexingServiceClient;
import org.apache.hive.druid.io.druid.common.config.JacksonConfigManager;
import org.apache.hive.druid.io.druid.java.util.emitter.EmittingLogger;
import org.apache.hive.druid.io.druid.server.coordinator.DatasourceWhitelist;
import org.apache.hive.druid.io.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.hive.druid.io.druid.server.coordinator.helper.DruidCoordinatorHelper;
import org.apache.hive.druid.io.druid.timeline.DataSegment;

public class DruidCoordinatorVersionConverter
implements DruidCoordinatorHelper {
    private static final EmittingLogger log = new EmittingLogger(DruidCoordinatorVersionConverter.class);
    private final IndexingServiceClient indexingServiceClient;
    private final AtomicReference<DatasourceWhitelist> whitelistRef;

    @Inject
    public DruidCoordinatorVersionConverter(IndexingServiceClient indexingServiceClient, JacksonConfigManager configManager) {
        this.indexingServiceClient = indexingServiceClient;
        this.whitelistRef = configManager.watch("coordinator.whitelist", DatasourceWhitelist.class);
    }

    @Override
    public DruidCoordinatorRuntimeParams run(DruidCoordinatorRuntimeParams params) {
        DatasourceWhitelist whitelist = this.whitelistRef.get();
        for (DataSegment dataSegment : params.getAvailableSegments()) {
            Integer binaryVersion;
            if (whitelist != null && !whitelist.contains(dataSegment.getDataSource()) || (binaryVersion = dataSegment.getBinaryVersion()) != null && binaryVersion >= 9) continue;
            log.info("Upgrading version on segment[%s]", dataSegment.getIdentifier());
            this.indexingServiceClient.upgradeSegment(dataSegment);
        }
        return params;
    }
}

