/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.coordination;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.annotations.VisibleForTesting;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.util.concurrent.AbstractFuture;
import org.apache.hive.druid.com.google.common.util.concurrent.ListenableFuture;
import org.apache.hive.druid.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.hive.druid.io.druid.java.util.common.IAE;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.apache.hive.druid.io.druid.server.coordination.DataSegmentChangeRequest;
import org.apache.hive.druid.io.druid.server.coordination.SegmentChangeRequestsSnapshot;

public class SegmentChangeRequestHistory {
    private static int MAX_SIZE = 1000;
    private final int maxSize;
    private final CircularBuffer<Holder> changes;
    @VisibleForTesting
    final LinkedHashMap<CustomSettableFuture, Counter> waitingFutures;
    private final ExecutorService singleThreadedExecutor;
    private final Runnable resolveWaitingFuturesRunnable;

    public SegmentChangeRequestHistory() {
        this(MAX_SIZE);
    }

    public SegmentChangeRequestHistory(int maxSize) {
        this.maxSize = maxSize;
        this.changes = new CircularBuffer(maxSize);
        this.waitingFutures = new LinkedHashMap();
        this.resolveWaitingFuturesRunnable = new Runnable(){

            @Override
            public void run() {
                SegmentChangeRequestHistory.this.resolveWaitingFutures();
            }
        };
        this.singleThreadedExecutor = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("SegmentChangeRequestHistory").build());
    }

    public synchronized void addSegmentChangeRequests(List<DataSegmentChangeRequest> requests) {
        for (DataSegmentChangeRequest request : requests) {
            this.changes.add(new Holder(request, this.getLastCounter().inc()));
        }
        this.singleThreadedExecutor.execute(this.resolveWaitingFuturesRunnable);
    }

    public synchronized void addSegmentChangeRequest(DataSegmentChangeRequest request) {
        this.addSegmentChangeRequests(ImmutableList.of(request));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ListenableFuture<SegmentChangeRequestsSnapshot> getRequestsSince(Counter counter) {
        CustomSettableFuture future = new CustomSettableFuture(this.waitingFutures);
        if (counter.counter < 0L) {
            future.setException(new IAE("counter[%s] must be >= 0", counter));
            return future;
        }
        Counter lastCounter = this.getLastCounter();
        if (counter.counter == lastCounter.counter) {
            if (!counter.matches(lastCounter)) {
                future.setException(new IAE("counter[%s] failed to match with [%s]", counter, lastCounter));
            } else {
                LinkedHashMap<CustomSettableFuture, Counter> linkedHashMap = this.waitingFutures;
                synchronized (linkedHashMap) {
                    this.waitingFutures.put(future, counter);
                }
            }
        } else {
            try {
                future.set(this.getRequestsSinceWithoutWait(counter));
            }
            catch (Exception ex) {
                future.setException(ex);
            }
        }
        return future;
    }

    private synchronized SegmentChangeRequestsSnapshot getRequestsSinceWithoutWait(Counter counter) {
        Counter counterToMatch;
        Counter lastCounter = this.getLastCounter();
        if (counter.counter >= lastCounter.counter) {
            throw new IAE("counter[%s] >= last counter[%s]", counter, lastCounter);
        }
        if (lastCounter.counter - counter.counter >= (long)this.maxSize) {
            return SegmentChangeRequestsSnapshot.fail(StringUtils.format("can't serve request, not enough history is kept. given counter [%s] and current last counter [%s]", counter, lastCounter));
        }
        int changeStartIndex = (int)(counter.counter + (long)this.changes.size() - lastCounter.counter);
        Counter counter2 = counterToMatch = counter.counter == 0L ? Counter.ZERO : this.changes.get(changeStartIndex - 1).counter;
        if (!counterToMatch.matches(counter)) {
            throw new IAE("counter[%s] failed to match with [%s]", counter, counterToMatch);
        }
        ArrayList<DataSegmentChangeRequest> result = new ArrayList<DataSegmentChangeRequest>();
        for (int i = changeStartIndex; i < this.changes.size(); ++i) {
            result.add(this.changes.get(i).changeRequest);
        }
        return SegmentChangeRequestsSnapshot.success(this.changes.get(this.changes.size() - 1).counter, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolveWaitingFutures() {
        LinkedHashMap<CustomSettableFuture, Counter> waitingFuturesCopy = new LinkedHashMap<CustomSettableFuture, Counter>();
        LinkedHashMap<CustomSettableFuture, Counter> linkedHashMap = this.waitingFutures;
        synchronized (linkedHashMap) {
            waitingFuturesCopy.putAll(this.waitingFutures);
            this.waitingFutures.clear();
        }
        for (Map.Entry entry : waitingFuturesCopy.entrySet()) {
            try {
                ((CustomSettableFuture)entry.getKey()).set(this.getRequestsSinceWithoutWait((Counter)entry.getValue()));
            }
            catch (Exception ex) {
                ((CustomSettableFuture)entry.getKey()).setException(ex);
            }
        }
    }

    public synchronized Counter getLastCounter() {
        if (this.changes.size() > 0) {
            return this.changes.get(this.changes.size() - 1).counter;
        }
        return Counter.ZERO;
    }

    static class CircularBuffer<E> {
        private final E[] buffer;
        private int start = 0;
        private int size = 0;

        CircularBuffer(int capacity) {
            this.buffer = new Object[capacity];
        }

        void add(E item) {
            this.buffer[this.start++] = item;
            if (this.start >= this.buffer.length) {
                this.start = 0;
            }
            if (this.size < this.buffer.length) {
                ++this.size;
            }
        }

        E get(int index) {
            Preconditions.checkArgument(index >= 0 && index < this.size, "invalid index");
            int bufferIndex = (this.start - this.size + index) % this.buffer.length;
            if (bufferIndex < 0) {
                bufferIndex += this.buffer.length;
            }
            return this.buffer[bufferIndex];
        }

        int size() {
            return this.size;
        }
    }

    private static class CustomSettableFuture
    extends AbstractFuture<SegmentChangeRequestsSnapshot> {
        private final LinkedHashMap<CustomSettableFuture, Counter> waitingFutures;

        private CustomSettableFuture(LinkedHashMap<CustomSettableFuture, Counter> waitingFutures) {
            this.waitingFutures = waitingFutures;
        }

        @Override
        public boolean set(SegmentChangeRequestsSnapshot value) {
            return super.set(value);
        }

        @Override
        public boolean setException(Throwable throwable) {
            return super.setException(throwable);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean cancel(boolean interruptIfRunning) {
            LinkedHashMap<CustomSettableFuture, Counter> linkedHashMap = this.waitingFutures;
            synchronized (linkedHashMap) {
                this.waitingFutures.remove(this);
            }
            return true;
        }
    }

    public static class Counter {
        public static final Counter ZERO = new Counter(0L);
        private final long counter;
        private final long hash;

        public Counter(long counter) {
            this(counter, System.currentTimeMillis());
        }

        @JsonCreator
        public Counter(@JsonProperty(value="counter") long counter, @JsonProperty(value="hash") long hash) {
            this.counter = counter;
            this.hash = hash;
        }

        @JsonProperty
        public long getCounter() {
            return this.counter;
        }

        @JsonProperty
        public long getHash() {
            return this.hash;
        }

        public Counter inc() {
            return new Counter(this.counter + 1L);
        }

        public boolean matches(Counter other) {
            return this.counter == other.counter && this.hash == other.hash;
        }

        public String toString() {
            return "Counter{counter=" + this.counter + ", hash=" + this.hash + '}';
        }
    }

    private static class Holder {
        private final DataSegmentChangeRequest changeRequest;
        private final Counter counter;

        public Holder(DataSegmentChangeRequest changeRequest, Counter counter) {
            this.changeRequest = changeRequest;
            this.counter = counter;
        }
    }
}

