/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.incremental;

import javax.annotation.Nullable;
import org.apache.hive.druid.io.druid.query.dimension.DimensionSpec;
import org.apache.hive.druid.io.druid.query.extraction.ExtractionFn;
import org.apache.hive.druid.io.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.hive.druid.io.druid.segment.ColumnSelectorFactory;
import org.apache.hive.druid.io.druid.segment.ColumnValueSelector;
import org.apache.hive.druid.io.druid.segment.DimensionIndexer;
import org.apache.hive.druid.io.druid.segment.DimensionSelector;
import org.apache.hive.druid.io.druid.segment.DimensionSelectorUtils;
import org.apache.hive.druid.io.druid.segment.LongColumnSelector;
import org.apache.hive.druid.io.druid.segment.SingleScanTimeDimSelector;
import org.apache.hive.druid.io.druid.segment.VirtualColumns;
import org.apache.hive.druid.io.druid.segment.column.ColumnCapabilities;
import org.apache.hive.druid.io.druid.segment.incremental.IncrementalIndex;
import org.apache.hive.druid.io.druid.segment.incremental.TimeAndDimsHolder;

class IncrementalIndexColumnSelectorFactory
implements ColumnSelectorFactory {
    private final IncrementalIndex<?> index;
    private final VirtualColumns virtualColumns;
    private final boolean descending;
    private final TimeAndDimsHolder timeAndDimsHolder;

    IncrementalIndexColumnSelectorFactory(IncrementalIndex<?> index, VirtualColumns virtualColumns, boolean descending, TimeAndDimsHolder timeAndDimsHolder) {
        this.index = index;
        this.virtualColumns = virtualColumns;
        this.descending = descending;
        this.timeAndDimsHolder = timeAndDimsHolder;
    }

    @Override
    public DimensionSelector makeDimensionSelector(DimensionSpec dimensionSpec) {
        if (this.virtualColumns.exists(dimensionSpec.getDimension())) {
            return this.virtualColumns.makeDimensionSelector(dimensionSpec, this);
        }
        return dimensionSpec.decorate(this.makeDimensionSelectorUndecorated(dimensionSpec));
    }

    private DimensionSelector makeDimensionSelectorUndecorated(DimensionSpec dimensionSpec) {
        String dimension = dimensionSpec.getDimension();
        ExtractionFn extractionFn = dimensionSpec.getExtractionFn();
        if (dimension.equals("__time")) {
            return new SingleScanTimeDimSelector(this.makeColumnValueSelector(dimension), extractionFn, this.descending);
        }
        IncrementalIndex.DimensionDesc dimensionDesc = this.index.getDimension(dimensionSpec.getDimension());
        if (dimensionDesc == null) {
            ColumnCapabilities capabilities = this.getColumnCapabilities(dimension);
            if (capabilities == null) {
                return DimensionSelectorUtils.constantSelector(null, extractionFn);
            }
            if (capabilities.getType().isNumeric()) {
                return capabilities.getType().makeNumericWrappingDimensionSelector(this.makeColumnValueSelector(dimension), extractionFn);
            }
            return DimensionSelectorUtils.constantSelector(null, extractionFn);
        }
        DimensionIndexer indexer = dimensionDesc.getIndexer();
        return indexer.makeDimensionSelector(dimensionSpec, this.timeAndDimsHolder, dimensionDesc);
    }

    @Override
    public ColumnValueSelector<?> makeColumnValueSelector(String columnName) {
        if (this.virtualColumns.exists(columnName)) {
            return this.virtualColumns.makeColumnValueSelector(columnName, this);
        }
        if (columnName.equals("__time")) {
            class TimeLongColumnSelector
            implements LongColumnSelector {
                TimeLongColumnSelector() {
                }

                @Override
                public long getLong() {
                    return IncrementalIndexColumnSelectorFactory.this.timeAndDimsHolder.get().getTimestamp();
                }

                @Override
                public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                }
            }
            return new TimeLongColumnSelector();
        }
        Integer dimIndex = this.index.getDimensionIndex(columnName);
        if (dimIndex != null) {
            IncrementalIndex.DimensionDesc dimensionDesc = this.index.getDimension(columnName);
            DimensionIndexer indexer = dimensionDesc.getIndexer();
            return indexer.makeColumnValueSelector(this.timeAndDimsHolder, dimensionDesc);
        }
        return this.index.makeMetricColumnValueSelector(columnName, this.timeAndDimsHolder);
    }

    @Override
    @Nullable
    public ColumnCapabilities getColumnCapabilities(String columnName) {
        if (this.virtualColumns.exists(columnName)) {
            return this.virtualColumns.getColumnCapabilities(columnName);
        }
        return this.index.getCapabilities(columnName);
    }
}

